/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class ValueRangeRecord
extends Record {
    public static final short sid = 4127;
    private double field_1_minimumAxisValue;
    private double field_2_maximumAxisValue;
    private double field_3_majorIncrement;
    private double field_4_minorIncrement;
    private double field_5_categoryAxisCross;
    private short field_6_options;
    private BitField automaticMinimum = new BitField(1);
    private BitField automaticMaximum = new BitField(2);
    private BitField automaticMajor = new BitField(4);
    private BitField automaticMinor = new BitField(8);
    private BitField automaticCategoryCrossing = new BitField(16);
    private BitField logarithmicScale = new BitField(32);
    private BitField valuesInReverse = new BitField(64);
    private BitField crossCategoryAxisAtMaximum = new BitField(128);
    private BitField reserved = new BitField(256);

    public ValueRangeRecord() {
    }

    public ValueRangeRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ValueRangeRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4127) {
            throw new RecordFormatException("Not a ValueRange record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_minimumAxisValue = LittleEndian.getDouble(data, 0 + offset);
        this.field_2_maximumAxisValue = LittleEndian.getDouble(data, 8 + offset);
        this.field_3_majorIncrement = LittleEndian.getDouble(data, 16 + offset);
        this.field_4_minorIncrement = LittleEndian.getDouble(data, 24 + offset);
        this.field_5_categoryAxisCross = LittleEndian.getDouble(data, 32 + offset);
        this.field_6_options = LittleEndian.getShort(data, 40 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ValueRange]\n");
        buffer.append("    .minimumAxisValue     = ").append(" (").append(this.getMinimumAxisValue()).append(" )\n");
        buffer.append("    .maximumAxisValue     = ").append(" (").append(this.getMaximumAxisValue()).append(" )\n");
        buffer.append("    .majorIncrement       = ").append(" (").append(this.getMajorIncrement()).append(" )\n");
        buffer.append("    .minorIncrement       = ").append(" (").append(this.getMinorIncrement()).append(" )\n");
        buffer.append("    .categoryAxisCross    = ").append(" (").append(this.getCategoryAxisCross()).append(" )\n");
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )\n");
        buffer.append("         .automaticMinimum         = ").append(this.isAutomaticMinimum()).append('\n');
        buffer.append("         .automaticMaximum         = ").append(this.isAutomaticMaximum()).append('\n');
        buffer.append("         .automaticMajor           = ").append(this.isAutomaticMajor()).append('\n');
        buffer.append("         .automaticMinor           = ").append(this.isAutomaticMinor()).append('\n');
        buffer.append("         .automaticCategoryCrossing     = ").append(this.isAutomaticCategoryCrossing()).append('\n');
        buffer.append("         .logarithmicScale         = ").append(this.isLogarithmicScale()).append('\n');
        buffer.append("         .valuesInReverse          = ").append(this.isValuesInReverse()).append('\n');
        buffer.append("         .crossCategoryAxisAtMaximum     = ").append(this.isCrossCategoryAxisAtMaximum()).append('\n');
        buffer.append("         .reserved                 = ").append(this.isReserved()).append('\n');
        buffer.append("[/ValueRange]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4127);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putDouble(data, 4 + offset, this.field_1_minimumAxisValue);
        LittleEndian.putDouble(data, 12 + offset, this.field_2_maximumAxisValue);
        LittleEndian.putDouble(data, 20 + offset, this.field_3_majorIncrement);
        LittleEndian.putDouble(data, 28 + offset, this.field_4_minorIncrement);
        LittleEndian.putDouble(data, 36 + offset, this.field_5_categoryAxisCross);
        LittleEndian.putShort(data, 44 + offset, this.field_6_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 46;
    }

    public short getSid() {
        return 4127;
    }

    public double getMinimumAxisValue() {
        return this.field_1_minimumAxisValue;
    }

    public void setMinimumAxisValue(double field_1_minimumAxisValue) {
        this.field_1_minimumAxisValue = field_1_minimumAxisValue;
    }

    public double getMaximumAxisValue() {
        return this.field_2_maximumAxisValue;
    }

    public void setMaximumAxisValue(double field_2_maximumAxisValue) {
        this.field_2_maximumAxisValue = field_2_maximumAxisValue;
    }

    public double getMajorIncrement() {
        return this.field_3_majorIncrement;
    }

    public void setMajorIncrement(double field_3_majorIncrement) {
        this.field_3_majorIncrement = field_3_majorIncrement;
    }

    public double getMinorIncrement() {
        return this.field_4_minorIncrement;
    }

    public void setMinorIncrement(double field_4_minorIncrement) {
        this.field_4_minorIncrement = field_4_minorIncrement;
    }

    public double getCategoryAxisCross() {
        return this.field_5_categoryAxisCross;
    }

    public void setCategoryAxisCross(double field_5_categoryAxisCross) {
        this.field_5_categoryAxisCross = field_5_categoryAxisCross;
    }

    public short getOptions() {
        return this.field_6_options;
    }

    public void setOptions(short field_6_options) {
        this.field_6_options = field_6_options;
    }

    public void setAutomaticMinimum(boolean value) {
        this.field_6_options = this.automaticMinimum.setShortBoolean(this.field_6_options, value);
    }

    public boolean isAutomaticMinimum() {
        return this.automaticMinimum.isSet(this.field_6_options);
    }

    public void setAutomaticMaximum(boolean value) {
        this.field_6_options = this.automaticMaximum.setShortBoolean(this.field_6_options, value);
    }

    public boolean isAutomaticMaximum() {
        return this.automaticMaximum.isSet(this.field_6_options);
    }

    public void setAutomaticMajor(boolean value) {
        this.field_6_options = this.automaticMajor.setShortBoolean(this.field_6_options, value);
    }

    public boolean isAutomaticMajor() {
        return this.automaticMajor.isSet(this.field_6_options);
    }

    public void setAutomaticMinor(boolean value) {
        this.field_6_options = this.automaticMinor.setShortBoolean(this.field_6_options, value);
    }

    public boolean isAutomaticMinor() {
        return this.automaticMinor.isSet(this.field_6_options);
    }

    public void setAutomaticCategoryCrossing(boolean value) {
        this.field_6_options = this.automaticCategoryCrossing.setShortBoolean(this.field_6_options, value);
    }

    public boolean isAutomaticCategoryCrossing() {
        return this.automaticCategoryCrossing.isSet(this.field_6_options);
    }

    public void setLogarithmicScale(boolean value) {
        this.field_6_options = this.logarithmicScale.setShortBoolean(this.field_6_options, value);
    }

    public boolean isLogarithmicScale() {
        return this.logarithmicScale.isSet(this.field_6_options);
    }

    public void setValuesInReverse(boolean value) {
        this.field_6_options = this.valuesInReverse.setShortBoolean(this.field_6_options, value);
    }

    public boolean isValuesInReverse() {
        return this.valuesInReverse.isSet(this.field_6_options);
    }

    public void setCrossCategoryAxisAtMaximum(boolean value) {
        this.field_6_options = this.crossCategoryAxisAtMaximum.setShortBoolean(this.field_6_options, value);
    }

    public boolean isCrossCategoryAxisAtMaximum() {
        return this.crossCategoryAxisAtMaximum.isSet(this.field_6_options);
    }

    public void setReserved(boolean value) {
        this.field_6_options = this.reserved.setShortBoolean(this.field_6_options, value);
    }

    public boolean isReserved() {
        return this.reserved.isSet(this.field_6_options);
    }

    static {
        sid = (short)4127;
    }
}

