/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.InfoSetUtil;
import org.apache.commons.jxpath.ri.axes.UnionContext;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.Operation;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class CoreOperation
extends Operation {
    public CoreOperation(int code, Expression[] args) {
        super(code, args);
    }

    public CoreOperation(int code, Expression arg) {
        super(code, new Expression[]{arg});
    }

    public CoreOperation(int code, Expression arg1, Expression arg2) {
        super(code, new Expression[]{arg1, arg2});
    }

    public Expression getArg1() {
        return this.args[0];
    }

    public Expression getArg2() {
        return this.args[1];
    }

    public Object compute(EvalContext context) {
        return this.computeValue(context);
    }

    public Object computeValue(EvalContext context) {
        switch (this.getExpressionTypeCode()) {
            case 19: {
                return this.union(context, this.args[0], this.args[1]);
            }
            case 9: {
                return this.minus(context, this.args[0]);
            }
            case 1: {
                return this.sum(context, this.args);
            }
            case 2: {
                return this.minus(context, this.args[0], this.args[1]);
            }
            case 3: {
                return this.mult(context, this.args[0], this.args[1]);
            }
            case 4: {
                return this.div(context, this.args[0], this.args[1]);
            }
            case 10: {
                return this.mod(context, this.args[0], this.args[1]);
            }
            case 11: {
                return this.lt(context, this.args[0], this.args[1]);
            }
            case 12: {
                return this.gt(context, this.args[0], this.args[1]);
            }
            case 13: {
                return this.lte(context, this.args[0], this.args[1]);
            }
            case 14: {
                return this.gte(context, this.args[0], this.args[1]);
            }
            case 15: {
                return this.eq(context, this.args[0], this.args[1]);
            }
            case 16: {
                return this.ne(context, this.args[0], this.args[1]);
            }
            case 7: {
                return this.and(context, this.args);
            }
            case 8: {
                return this.or(context, this.args);
            }
        }
        return null;
    }

    protected Object union(EvalContext context, Expression left, Expression right) {
        Object l = left.compute(context);
        Object r = right.compute(context);
        EvalContext lctx = l instanceof EvalContext ? (EvalContext)l : context.getRootContext().getConstantContext(l);
        EvalContext rctx = r instanceof EvalContext ? (EvalContext)r : context.getRootContext().getConstantContext(r);
        return new UnionContext(context.getRootContext(), new EvalContext[]{lctx, rctx});
    }

    protected Object minus(EvalContext context, Expression arg) {
        double a = InfoSetUtil.doubleValue(arg.computeValue(context));
        return new Double(-a);
    }

    protected Object sum(EvalContext context, Expression[] arguments) {
        double s = 0.0;
        int i = 0;
        while (i < arguments.length) {
            s += InfoSetUtil.doubleValue(arguments[i].computeValue(context));
            ++i;
        }
        return new Double(s);
    }

    protected Object minus(EvalContext context, Expression left, Expression right) {
        double l = InfoSetUtil.doubleValue(left.computeValue(context));
        double r = InfoSetUtil.doubleValue(right.computeValue(context));
        return new Double(l - r);
    }

    protected Object div(EvalContext context, Expression left, Expression right) {
        double l = InfoSetUtil.doubleValue(left.computeValue(context));
        double r = InfoSetUtil.doubleValue(right.computeValue(context));
        return new Double(l / r);
    }

    protected Object mult(EvalContext context, Expression left, Expression right) {
        double l = InfoSetUtil.doubleValue(left.computeValue(context));
        double r = InfoSetUtil.doubleValue(right.computeValue(context));
        return new Double(l * r);
    }

    protected Object mod(EvalContext context, Expression left, Expression right) {
        long l = (long)InfoSetUtil.doubleValue(left.computeValue(context));
        long r = (long)InfoSetUtil.doubleValue(right.computeValue(context));
        return new Double(l % r);
    }

    protected Object lt(EvalContext context, Expression left, Expression right) {
        double r;
        double l = InfoSetUtil.doubleValue(left.computeValue(context));
        return l < (r = InfoSetUtil.doubleValue(right.computeValue(context))) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object gt(EvalContext context, Expression left, Expression right) {
        double r;
        double l = InfoSetUtil.doubleValue(left.computeValue(context));
        return l > (r = InfoSetUtil.doubleValue(right.computeValue(context))) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object lte(EvalContext context, Expression left, Expression right) {
        double r;
        double l = InfoSetUtil.doubleValue(left.computeValue(context));
        return l <= (r = InfoSetUtil.doubleValue(right.computeValue(context))) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object gte(EvalContext context, Expression left, Expression right) {
        double r;
        double l = InfoSetUtil.doubleValue(left.computeValue(context));
        return l >= (r = InfoSetUtil.doubleValue(right.computeValue(context))) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object eq(EvalContext context, Expression left, Expression right) {
        return this.equal(context, left, right) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object ne(EvalContext context, Expression left, Expression right) {
        return this.equal(context, left, right) ? Boolean.FALSE : Boolean.TRUE;
    }

    protected boolean equal(EvalContext context, Expression left, Expression right) {
        boolean result;
        Object r;
        Object l = left.computeValue(context);
        if (l == (r = right.computeValue(context))) {
            return true;
        }
        if (l instanceof EvalContext && r instanceof EvalContext) {
            HashSet lset = new HashSet(this.valueSet((EvalContext)l));
            HashSet rset = new HashSet(this.valueSet((EvalContext)r));
            return lset.equals(rset);
        }
        if (l instanceof EvalContext) {
            l = ((EvalContext)l).getSingleNodePointer();
        }
        if (r instanceof EvalContext) {
            r = ((EvalContext)r).getSingleNodePointer();
        }
        if (l instanceof Pointer && r instanceof Pointer && l.equals(r)) {
            return true;
        }
        if (l instanceof NodePointer) {
            l = ((NodePointer)l).getValue();
        }
        if (r instanceof NodePointer) {
            r = ((NodePointer)r).getValue();
        }
        if (l instanceof Boolean || r instanceof Boolean) {
            result = InfoSetUtil.booleanValue(l) == InfoSetUtil.booleanValue(r);
        } else if (l instanceof Number || r instanceof Number) {
            result = InfoSetUtil.doubleValue(l) == InfoSetUtil.doubleValue(r);
        } else if (l instanceof String || r instanceof String) {
            result = InfoSetUtil.stringValue(l).equals(InfoSetUtil.stringValue(r));
        } else {
            if (l == null) {
                return r == null;
            }
            result = l.equals(r);
        }
        return result;
    }

    private Set valueSet(EvalContext context) {
        HashSet<Object> set = new HashSet<Object>();
        while (context.hasNext()) {
            context.next();
            NodePointer pointer = context.getCurrentNodePointer();
            set.add(pointer.getValue());
        }
        return set;
    }

    protected Object and(EvalContext context, Expression[] arguments) {
        int i = 0;
        while (i < arguments.length) {
            if (!InfoSetUtil.booleanValue(arguments[i].computeValue(context))) {
                return Boolean.FALSE;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    protected Object or(EvalContext context, Expression[] arguments) {
        int i = 0;
        while (i < arguments.length) {
            if (InfoSetUtil.booleanValue(arguments[i].computeValue(context))) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return Boolean.FALSE;
    }
}

