/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.util.TypeUtils;

public class MethodLookupUtils {
    private static final int NO_MATCH = 0;
    private static final int APPROXIMATE_MATCH = 1;
    private static final int EXACT_MATCH = 2;
    private static final Object[] EMPTY_ARRAY;
    static /* synthetic */ Class class$org$apache$commons$jxpath$ExpressionContext;

    public static Constructor lookupConstructor(Class targetClass, Object[] parameters) {
        boolean tryExact = true;
        int count = parameters.length;
        Class[] types = new Class[count];
        int i = 0;
        while (i < count) {
            Object param = parameters[i];
            if (param != null) {
                types[i] = param.getClass();
            } else {
                types[i] = null;
                tryExact = false;
            }
            ++i;
        }
        Constructor<Object> constructor = null;
        if (tryExact) {
            try {
                constructor = targetClass.getConstructor(types);
                if (constructor != null) {
                    return constructor;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        Constructor<?>[] constructors = targetClass.getConstructors();
        int i2 = 0;
        while (i2 < constructors.length) {
            int match = MethodLookupUtils.matchParameterTypes(constructors[i2].getParameterTypes(), parameters);
            if (match != 0) {
                if (match > currentMatch) {
                    constructor = constructors[i2];
                    currentMatch = match;
                    ambiguous = false;
                } else if (match == currentMatch) {
                    ambiguous = true;
                }
            }
            ++i2;
        }
        if (ambiguous) {
            throw new JXPathException("Ambigous constructor " + Arrays.asList(parameters));
        }
        return constructor;
    }

    public static Method lookupStaticMethod(Class targetClass, String name, Object[] parameters) {
        boolean tryExact = true;
        int count = parameters.length;
        Class[] types = new Class[count];
        int i = 0;
        while (i < count) {
            Object param = parameters[i];
            if (param != null) {
                types[i] = param.getClass();
            } else {
                types[i] = null;
                tryExact = false;
            }
            ++i;
        }
        Method method = null;
        if (tryExact) {
            try {
                method = targetClass.getMethod(name, types);
                if (method != null && Modifier.isStatic(method.getModifiers())) {
                    return method;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        Method[] methods = targetClass.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            int match;
            if (Modifier.isStatic(methods[i2].getModifiers()) && methods[i2].getName().equals(name) && (match = MethodLookupUtils.matchParameterTypes(methods[i2].getParameterTypes(), parameters)) != 0) {
                if (match > currentMatch) {
                    method = methods[i2];
                    currentMatch = match;
                    ambiguous = false;
                } else if (match == currentMatch) {
                    ambiguous = true;
                }
            }
            ++i2;
        }
        if (ambiguous) {
            throw new JXPathException("Ambigous method call: " + name);
        }
        return method;
    }

    public static Method lookupMethod(Class targetClass, String name, Object[] parameters) {
        if (parameters.length < 1 || parameters[0] == null) {
            return null;
        }
        if (MethodLookupUtils.matchType(targetClass, parameters[0]) == 0) {
            return null;
        }
        targetClass = TypeUtils.convert(parameters[0], targetClass).getClass();
        boolean tryExact = true;
        int count = parameters.length - 1;
        Class[] types = new Class[count];
        Object[] arguments = new Object[count];
        int i = 0;
        while (i < count) {
            Object param;
            arguments[i] = param = parameters[i + 1];
            if (param != null) {
                types[i] = param.getClass();
            } else {
                types[i] = null;
                tryExact = false;
            }
            ++i;
        }
        Method method = null;
        if (tryExact) {
            try {
                method = targetClass.getMethod(name, types);
                if (method != null && !Modifier.isStatic(method.getModifiers())) {
                    return method;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        Method[] methods = targetClass.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            int match;
            if (!Modifier.isStatic(methods[i2].getModifiers()) && methods[i2].getName().equals(name) && (match = MethodLookupUtils.matchParameterTypes(methods[i2].getParameterTypes(), arguments)) != 0) {
                if (match > currentMatch) {
                    method = methods[i2];
                    currentMatch = match;
                    ambiguous = false;
                } else if (match == currentMatch) {
                    ambiguous = true;
                }
            }
            ++i2;
        }
        if (ambiguous) {
            throw new JXPathException("Ambigous method call: " + name);
        }
        return method;
    }

    private static int matchParameterTypes(Class[] types, Object[] parameters) {
        int pi = 0;
        if (types.length >= 1 && (class$org$apache$commons$jxpath$ExpressionContext == null ? (class$org$apache$commons$jxpath$ExpressionContext = MethodLookupUtils.class$("org.apache.commons.jxpath.ExpressionContext")) : class$org$apache$commons$jxpath$ExpressionContext).isAssignableFrom(types[0])) {
            ++pi;
        }
        if (types.length != parameters.length + pi) {
            return 0;
        }
        int totalMatch = 2;
        int i = 0;
        while (i < parameters.length) {
            int match = MethodLookupUtils.matchType(types[i + pi], parameters[i]);
            if (match == 0) {
                return 0;
            }
            if (match < totalMatch) {
                totalMatch = match;
            }
            ++i;
        }
        return totalMatch;
    }

    private static int matchType(Class expected, Object object) {
        if (object == null) {
            return 1;
        }
        Class<?> actual = object.getClass();
        if (expected.equals(actual)) {
            return 2;
        }
        if (expected.isAssignableFrom(actual)) {
            return 2;
        }
        if (TypeUtils.canConvert(object, expected)) {
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NO_MATCH = 0;
        APPROXIMATE_MATCH = 1;
        EXACT_MATCH = 2;
        EMPTY_ARRAY = new Object[0];
    }
}

