/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLClass;
import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.DAMLObjectProperty;
import com.hp.hpl.jena.daml.DAMLProperty;
import com.hp.hpl.jena.daml.LiteralAccessor;
import com.hp.hpl.jena.daml.PropertyAccessor;
import com.hp.hpl.jena.daml.PropertyIterator;
import com.hp.hpl.jena.daml.common.DAMLHierarchy;
import com.hp.hpl.jena.daml.common.DAMLModelImpl;
import com.hp.hpl.jena.daml.common.LiteralAccessorImpl;
import com.hp.hpl.jena.daml.common.PropertyAccessorImpl;
import com.hp.hpl.jena.daml.common.VocabularyManager;
import com.hp.hpl.jena.util.ConcatenatedIterator;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.mesa.rdf.jena.common.NodeIteratorImpl;
import com.hp.hpl.mesa.rdf.jena.common.ResourceImpl;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.model.AnonId;
import com.hp.hpl.mesa.rdf.jena.model.NodeIterator;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDFS;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public abstract class DAMLCommonImpl
extends ResourceImpl
implements DAMLCommon {
    private LiteralAccessor m_propLabel = new LiteralAccessorImpl(RDFS.label, this);
    private LiteralAccessor m_propComment = new LiteralAccessorImpl(RDFS.comment, this);
    private PropertyAccessor m_propEquivalentTo = null;
    private DAMLVocabulary m_vocabulary = null;
    private PropertyAccessor m_propType = null;
    protected static HashMap s_UIDs = new HashMap();
    protected static int s_count = 0;

    public DAMLCommonImpl(String string, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string);
        this.model = dAMLModel;
        this.m_vocabulary = dAMLVocabulary;
    }

    public DAMLCommonImpl(String string, String string2, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        this(string + string2, dAMLModel, dAMLVocabulary);
    }

    public DAMLModel getDAMLModel() {
        return (DAMLModel)this.getModel();
    }

    public void setRDFType(Resource resource) {
        this.setRDFType(resource, true);
    }

    public void setRDFType(Resource resource, boolean bl) {
        if (this.getModel() != null) {
            if (bl) {
                this.replaceProperty(RDF.type, resource);
            } else {
                try {
                    this.addProperty(RDF.type, resource);
                }
                catch (RDFException rDFException) {
                    Log.severe("RDF exception " + rDFException, rDFException);
                    throw new RuntimeException("RDF Exception " + rDFException);
                }
            }
        }
    }

    public boolean hasRDFType(String string) {
        DAMLCommon dAMLCommon = ((DAMLModel)this.getModel()).getDAMLValue(string);
        if (dAMLCommon != null && dAMLCommon instanceof DAMLClass) {
            return this.hasRDFType((DAMLClass)dAMLCommon);
        }
        return this.hasRDFType(new ResourceImpl(string, this.getModel()));
    }

    public boolean hasRDFType(Resource resource) {
        boolean bl = false;
        String string = resource.getURI();
        Iterator iterator = this.getRDFTypes(true);
        while (!bl && iterator.hasNext()) {
            Resource resource2 = (Resource)iterator.next();
            boolean bl2 = bl = resource2.equals(resource) || DAMLHierarchy.getInstance().isDAMLSubClassOf(resource2.getURI(), string);
        }
        return bl;
    }

    public Iterator getRDFTypes(boolean bl) {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        Iterator iterator = this.prop_type().getAll(false);
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            hashSet.add(resource);
            if (!bl || !(resource instanceof DAMLClass)) continue;
            Iterator iterator2 = ((DAMLClass)resource).getSuperClasses();
            while (iterator2.hasNext()) {
                hashSet.add((Resource)iterator2.next());
            }
        }
        if (bl && this.getDefaultType() != null) {
            hashSet.add(this.getDefaultType());
        }
        return hashSet.iterator();
    }

    public RDFNode getPropertyValue(Property property) {
        try {
            return this.getProperty(property).getObject();
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception while getting property " + property + " value was: " + rDFException, rDFException);
            throw new RuntimeException("RDF error when getting values for property " + property + ": " + rDFException);
        }
    }

    public NodeIterator getPropertyValues(Property property) {
        return new NodeIteratorImpl(new PropertyIterator(this, property, null, false, false), null);
    }

    public void setPropertyValue(Property property, RDFNode rDFNode) {
        if (rDFNode == null) {
            this.removeAll(property);
        } else {
            this.replaceProperty(property, rDFNode);
        }
    }

    public void removeProperty(Property property, RDFNode rDFNode) {
        this.removeProperties(this.getEquivalenceClass(property), this.getEquivalenceClass(rDFNode));
    }

    public void removeAll(Property property) {
        this.removeAll(this.getEquivalenceClass(property));
    }

    public void replaceProperty(Property property, RDFNode rDFNode) {
        try {
            this.removeAll(property);
            this.addProperty(property, rDFNode);
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception while replacing value of DAML property: " + rDFException, rDFException);
            throw new RuntimeException("RDF exception while replacing value of DAML property: " + rDFException);
        }
    }

    public int getNumPropertyValues(Property property) {
        try {
            int n = 0;
            NodeIterator nodeIterator = this.getPropertyValues(property);
            while (nodeIterator.hasNext()) {
                ++n;
                nodeIterator.next();
            }
            return n;
        }
        catch (RDFException rDFException) {
            Log.severe("Exception while listing values: " + rDFException, rDFException);
            throw new RuntimeException("RDF failure while listing values: " + rDFException);
        }
    }

    public Iterator getAll(Property property, boolean bl) {
        PropertyIterator propertyIterator = new PropertyIterator(this.getEquivalentValues(), property, this.getPropertyInverse(property), bl && this.isTransitive(property), false);
        return propertyIterator;
    }

    public DAMLVocabulary getVocabulary() {
        if (this.m_vocabulary == null) {
            this.m_vocabulary = VocabularyManager.getVocabulary(this);
        }
        return this.m_vocabulary;
    }

    abstract Object getKey();

    public Iterator getEquivalentValues() {
        return new ConcatenatedIterator(new PropertyIterator(this, this.getVocabulary().equivalentTo(), this.getVocabulary().equivalentTo(), true, true, false), DAMLHierarchy.getInstance().getEquivalentValues(this));
    }

    public Iterator getEquivalenceSet() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.getEquivalentValues();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.equals(e)) continue;
            hashSet.add(e);
        }
        return hashSet.iterator();
    }

    public Iterator getSelfIterator() {
        LinkedList<DAMLCommonImpl> linkedList = new LinkedList<DAMLCommonImpl>();
        linkedList.add(this);
        return linkedList.iterator();
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.indexOf("Impl");
        int n2 = string.lastIndexOf(".") + 1;
        string = n > 0 ? string.substring(n2, n) : string.substring(n2);
        return this.isAnon() ? "<Anonymous " + DAMLCommonImpl.getIDTranslation(this.getId()) + " " + string + "@" + Integer.toHexString(this.hashCode()) + ">" : "<" + string + " " + this.getURI() + ">";
    }

    public void remove() {
        try {
            StmtIterator stmtIterator = this.listProperties();
            while (stmtIterator.hasNext()) {
                stmtIterator.next().remove();
            }
            ((DAMLModelImpl)this.getModel()).unindex(this);
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception while removing object from model: " + rDFException, rDFException);
        }
    }

    public LiteralAccessor prop_label() {
        return this.m_propLabel;
    }

    public LiteralAccessor prop_comment() {
        return this.m_propComment;
    }

    public PropertyAccessor prop_equivalentTo() {
        if (this.m_propEquivalentTo == null) {
            this.m_propEquivalentTo = new PropertyAccessorImpl(this.getVocabulary().equivalentTo(), this);
        }
        return this.m_propEquivalentTo;
    }

    public PropertyAccessor prop_type() {
        if (this.m_propType == null) {
            this.m_propType = new PropertyAccessorImpl(RDF.type, this);
        }
        return this.m_propType;
    }

    protected static String getIDTranslation(AnonId anonId) {
        Integer n = (Integer)s_UIDs.get(anonId);
        if (n == null) {
            n = new Integer(s_count++);
            s_UIDs.put(anonId, n);
        }
        return n.toString();
    }

    protected Iterator getEquivalenceClass(RDFNode rDFNode) {
        if (rDFNode instanceof DAMLCommon) {
            return ((DAMLCommon)rDFNode).getEquivalentValues();
        }
        Vector<RDFNode> vector = new Vector<RDFNode>();
        vector.add(rDFNode);
        return ((AbstractList)vector).iterator();
    }

    protected void removeProperties(Iterator iterator, Iterator iterator2) {
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        while (iterator2.hasNext()) {
            RDFNode rDFNode = (RDFNode)iterator2.next();
            Iterator iterator3 = ((AbstractList)vector).iterator();
            while (iterator3.hasNext()) {
                Property property = (Property)iterator3.next();
                try {
                    StmtIterator stmtIterator = this.getModel().listStatements(new SelectorImpl((Resource)this, property, rDFNode));
                    while (stmtIterator.hasNext()) {
                        stmtIterator.next().remove();
                    }
                }
                catch (RDFException rDFException) {
                    Log.severe("Possible RDF error when zapping from model: " + rDFException, rDFException);
                }
            }
        }
    }

    protected void removeAll(Iterator iterator) {
        try {
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                StmtIterator stmtIterator = this.getModel().listStatements(new SelectorImpl((Resource)this, property, (RDFNode)null));
                while (stmtIterator.hasNext()) {
                    stmtIterator.next().remove();
                }
            }
        }
        catch (RDFException rDFException) {
            Log.severe("Possible RDF error when zapping from model: " + rDFException, rDFException);
        }
    }

    protected Property getPropertyInverse(Property property) {
        if (property instanceof DAMLObjectProperty) {
            DAMLProperty dAMLProperty = (DAMLProperty)property;
            try {
                Statement statement = dAMLProperty.getProperty(dAMLProperty.getVocabulary().inverseOf());
                return (Property)statement.getObject();
            }
            catch (RDFException rDFException) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean isTransitive(Property property) {
        return property instanceof DAMLObjectProperty && ((DAMLObjectProperty)property).isTransitive();
    }

    protected Resource getDefaultType() {
        return null;
    }
}

