/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.common.DatatypeTranslator;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.common.ResourceImpl;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import java.util.Hashtable;
import java.util.Iterator;

public class XMLDatatypeRegistry {
    public static final String XSD_NAMESPACE_URI = "http://www.w3.org/2000/10/XMLSchema#";
    public static final Resource XSD_INTEGER = new ResourceImpl("http://www.w3.org/2000/10/XMLSchema#integer");
    protected Hashtable m_registry = new Hashtable();

    public XMLDatatypeRegistry() {
        this.registerDefaultTypes();
    }

    public DatatypeTranslator getTranslator(String string) {
        return (DatatypeTranslator)this.m_registry.get(string);
    }

    public void registerTranslator(String string, DatatypeTranslator datatypeTranslator) {
        this.m_registry.put(string, datatypeTranslator);
    }

    public Iterator getRegisteredTypes() {
        return this.m_registry.keySet().iterator();
    }

    public boolean isRegisteredType(String string) {
        return this.m_registry.containsKey(string);
    }

    protected void registerDefaultTypes() {
        this.m_registry.put("http://www.w3.org/2000/10/XMLSchema#integer", new DatatypeTranslator(){

            public Object deserialize(RDFNode rDFNode) {
                try {
                    if (rDFNode instanceof Literal) {
                        return new Integer(((Literal)rDFNode).getString());
                    }
                    if (rDFNode instanceof Resource) {
                        RDFNode rDFNode2 = ((Resource)rDFNode).getProperty(RDF.value).getObject();
                        return this.deserialize(rDFNode2);
                    }
                }
                catch (RDFException rDFException) {
                    Log.severe("RDF exception while converting datatype instance: " + rDFException, rDFException);
                }
                return null;
            }

            public RDFNode serialize(Object object, DAMLModel dAMLModel) {
                try {
                    return dAMLModel.createLiteral(((Integer)object).intValue());
                }
                catch (RDFException rDFException) {
                    Log.severe("RDF exception while converting datatype instance: " + rDFException, rDFException);
                    return null;
                }
            }
        });
        this.m_registry.put("http://www.w3.org/2000/10/XMLSchema#string", new DatatypeTranslator(){

            public Object deserialize(RDFNode rDFNode) {
                try {
                    if (rDFNode instanceof Literal) {
                        return ((Literal)rDFNode).getString();
                    }
                    if (rDFNode instanceof Resource) {
                        RDFNode rDFNode2 = ((Resource)rDFNode).getProperty(RDF.value).getObject();
                        return this.deserialize(rDFNode2);
                    }
                }
                catch (RDFException rDFException) {
                    Log.severe("RDF exception while converting datatype instance: " + rDFException, rDFException);
                }
                return null;
            }

            public RDFNode serialize(Object object, DAMLModel dAMLModel) {
                try {
                    return dAMLModel.createLiteral((String)object);
                }
                catch (RDFException rDFException) {
                    Log.severe("RDF exception while converting datatype instance: " + rDFException, rDFException);
                    return null;
                }
            }
        });
        this.m_registry.put("http://www.w3.org/2000/10/XMLSchema#real", new DatatypeTranslator(){

            public Object deserialize(RDFNode rDFNode) {
                try {
                    if (rDFNode instanceof Literal) {
                        return new Float(((Literal)rDFNode).getString());
                    }
                    if (rDFNode instanceof Resource) {
                        RDFNode rDFNode2 = ((Resource)rDFNode).getProperty(RDF.value).getObject();
                        return this.deserialize(rDFNode2);
                    }
                }
                catch (RDFException rDFException) {
                    Log.severe("RDF exception while converting datatype instance: " + rDFException, rDFException);
                }
                return null;
            }

            public RDFNode serialize(Object object, DAMLModel dAMLModel) {
                try {
                    return dAMLModel.createLiteral(((Float)object).floatValue());
                }
                catch (RDFException rDFException) {
                    Log.severe("RDF exception while converting datatype instance: " + rDFException, rDFException);
                    return null;
                }
            }
        });
        this.m_registry.put("http://www.w3.org/2000/10/XMLSchema#decimal", new DatatypeTranslator(){

            public Object deserialize(RDFNode rDFNode) {
                try {
                    if (rDFNode instanceof Literal) {
                        return new Long(((Literal)rDFNode).getString());
                    }
                    if (rDFNode instanceof Resource) {
                        RDFNode rDFNode2 = ((Resource)rDFNode).getProperty(RDF.value).getObject();
                        return this.deserialize(rDFNode2);
                    }
                }
                catch (RDFException rDFException) {
                    Log.severe("RDF exception while converting datatype instance: " + rDFException, rDFException);
                }
                return null;
            }

            public RDFNode serialize(Object object, DAMLModel dAMLModel) {
                try {
                    return dAMLModel.createLiteral((Long)object);
                }
                catch (RDFException rDFException) {
                    Log.severe("RDF exception while converting datatype instance: " + rDFException, rDFException);
                    return null;
                }
            }
        });
    }
}

