/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xmlizer.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.excalibur.component.DefaultComponentSelector;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xmlizer.XMLizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class XMLizerImpl
extends DefaultComponentSelector
implements XMLizer,
ThreadSafe {
    private final String m_defaultMimeType;

    public XMLizerImpl() {
        this("text/xml");
    }

    public XMLizerImpl(String defaultMimeType) {
        this.m_defaultMimeType = defaultMimeType;
    }

    public void toSAX(InputStream stream, String specifiedMimeType, String systemID, ContentHandler handler) throws SAXException, IOException, ComponentException {
        String message;
        if (null == stream) {
            throw new NullPointerException("stream");
        }
        if (null == handler) {
            throw new NullPointerException("handler");
        }
        String mimeType = specifiedMimeType;
        if (null == mimeType) {
            if (this.getLogger().isDebugEnabled()) {
                message = "No mime-type for xmlizing " + systemID + ", guessing " + this.m_defaultMimeType;
                this.getLogger().debug(message);
            }
            mimeType = this.m_defaultMimeType;
        }
        if (!this.hasComponent(mimeType)) {
            message = "No XMLizer registered for mimeType " + mimeType;
            throw new ComponentException(message);
        }
        XMLizer realXMLizer = (XMLizer)this.select(mimeType);
        try {
            realXMLizer.toSAX(stream, mimeType, systemID, handler);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.release(realXMLizer);
            throw throwable;
        }
        this.release(realXMLizer);
    }
}

