/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;

public class HttpState {
    private HashMap credMap = new HashMap();
    private ArrayList cookies = new ArrayList();

    public void addCookie(Cookie cookie) {
        if (cookie != null) {
            Iterator it = ((AbstractList)this.cookies).iterator();
            while (it.hasNext()) {
                Cookie tmp = (Cookie)it.next();
                if (!cookie.equals(tmp)) continue;
                it.remove();
                break;
            }
            if (!cookie.isExpired()) {
                this.cookies.add(cookie);
            }
        }
    }

    public void addCookies(Cookie[] newcookies) {
        if (newcookies != null) {
            int i = 0;
            while (i < newcookies.length) {
                this.addCookie(newcookies[i]);
                ++i;
            }
        }
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public Cookie[] getCookies(String domain, int port, String path, boolean secure, Date now) {
        ArrayList<Cookie> list = new ArrayList<Cookie>(this.cookies.size());
        int i = 0;
        int m = this.cookies.size();
        while (i < m) {
            Cookie c = (Cookie)this.cookies.get(i);
            if (c.matches(domain, port, path, secure, now)) {
                list.add(c);
            }
            ++i;
        }
        return list.toArray(new Cookie[list.size()]);
    }

    public boolean purgeExpiredCookies() {
        return this.purgeExpiredCookies(new Date());
    }

    public boolean purgeExpiredCookies(Date date) {
        boolean removed = false;
        Iterator it = ((AbstractList)this.cookies).iterator();
        while (it.hasNext()) {
            if (!((Cookie)it.next()).isExpired(date)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public void setCredentials(String realm, Credentials credentials) {
        this.credMap.put(realm, credentials);
    }

    public Credentials getCredentials(String realm) {
        return (Credentials)this.credMap.get(realm);
    }
}

