/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableScript;

public class InterpretedScript
extends NativeScript
implements DebuggableScript {
    InterpreterData itsData;

    InterpretedScript(Context context, InterpreterData interpreterData, String[] stringArray, short s) {
        this.itsData = interpreterData;
        this.argNames = stringArray;
        this.argCount = s;
        this.functionName = "";
        this.nestedFunctions = this.itsData.itsNestedFunctions;
        this.version = (short)context.getLanguageVersion();
    }

    public Object exec(Context context, Scriptable scriptable) throws JavaScriptException {
        return this.call(context, scriptable, scriptable, null);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        scriptable = ScriptRuntime.initScript(context, scriptable, this, scriptable2, this.itsData.itsFromEvalCode);
        return Interpreter.interpret(context, scriptable, scriptable2, objectArray, this, this.itsData);
    }

    public boolean isFunction() {
        return false;
    }

    public Scriptable getScriptable() {
        return this;
    }

    public String getSourceName() {
        return this.itsData.itsSourceFile;
    }

    public int[] getLineNumbers() {
        return this.itsData.itsLineNumberTable.getKeys();
    }

    public boolean placeBreakpoint(int n) {
        return this.itsData.placeBreakpoint(n);
    }

    public boolean removeBreakpoint(int n) {
        return this.itsData.removeBreakpoint(n);
    }
}

