/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class ToolErrorReporter
implements ErrorReporter {
    private final String messagePrefix = "js: ";
    private boolean hasReportedErrorFlag;
    private boolean reportWarnings;
    private PrintStream err;

    public ToolErrorReporter(boolean bl) {
        this(bl, System.err);
    }

    public ToolErrorReporter(boolean bl, PrintStream printStream) {
        this.reportWarnings = bl;
        this.err = printStream;
    }

    public static String getMessage(String string) {
        return ToolErrorReporter.getMessage(string, (Object[])null);
    }

    public static String getMessage(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return ToolErrorReporter.getMessage(string, objectArray);
    }

    public static String getMessage(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return ToolErrorReporter.getMessage(string, objectArray);
    }

    public static String getMessage(String string, Object[] objectArray) {
        String string2;
        Context context = Context.getCurrentContext();
        Locale locale = context == null ? Locale.getDefault() : context.getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.mozilla.javascript.tools.resources.Messages", locale);
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException("no message resource found for message property " + string);
        }
        if (objectArray == null) {
            return string2;
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        return messageFormat.format(objectArray);
    }

    public void warning(String string, String string2, int n, String string3, int n2) {
        if (!this.reportWarnings) {
            return;
        }
        Object[] objectArray = new Object[]{this.formatMessage(string, string2, n)};
        string = ToolErrorReporter.getMessage("msg.warning", objectArray);
        this.err.println("js: " + string);
        if (null != string3) {
            this.err.println("js: " + string3);
            this.err.println("js: " + this.buildIndicator(n2));
        }
    }

    public void error(String string, String string2, int n, String string3, int n2) {
        this.hasReportedErrorFlag = true;
        string = this.formatMessage(string, string2, n);
        this.err.println("js: " + string);
        if (null != string3) {
            this.err.println("js: " + string3);
            this.err.println("js: " + this.buildIndicator(n2));
        }
    }

    public EvaluatorException runtimeError(String string, String string2, int n, String string3, int n2) {
        this.error(string, string2, n, string3, n2);
        return new EvaluatorException(string);
    }

    public boolean hasReportedError() {
        return this.hasReportedErrorFlag;
    }

    public boolean isReportingWarnings() {
        return this.reportWarnings;
    }

    public void setIsReportingWarnings(boolean bl) {
        this.reportWarnings = bl;
    }

    private String formatMessage(String string, String string2, int n) {
        if (n > 0) {
            if (string2 != null) {
                Object[] objectArray = new Object[]{string2, new Integer(n), string};
                return ToolErrorReporter.getMessage("msg.format3", objectArray);
            }
            Object[] objectArray = new Object[]{new Integer(n), string};
            return ToolErrorReporter.getMessage("msg.format2", objectArray);
        }
        Object[] objectArray = new Object[]{string};
        return ToolErrorReporter.getMessage("msg.format1", objectArray);
    }

    private String buildIndicator(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n - 1) {
            stringBuffer.append(".");
            ++n2;
        }
        stringBuffer.append("^");
        return stringBuffer.toString();
    }
}

