/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.mpool;

import java.lang.reflect.Method;
import org.apache.excalibur.mpool.Resettable;

public final class PoolUtil {
    private static final Object[] EMPTY = new Object[0];
    private static final Class[] EMPTY_ARGS = new Class[0];

    private PoolUtil() {
    }

    public static Object recycle(Object obj) {
        if (obj instanceof Resettable) {
            ((Resettable)obj).reset();
        } else {
            try {
                Class<?> klass = obj.getClass();
                Class<?> recyclable = klass.getClassLoader().loadClass("org.apache.avalon.excalibur.pool.Recyclable");
                if (recyclable.isAssignableFrom(klass)) {
                    PoolUtil.recycleLegacy(obj);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj;
    }

    private static void recycleLegacy(Object obj) throws Exception {
        Class<?> klass = obj.getClass();
        Method recycle = klass.getMethod("recycle", EMPTY_ARGS);
        recycle.invoke(obj, EMPTY);
    }
}

