/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.lexicon;

import java.util.Enumeration;
import java.util.Vector;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.lexicon.Lexeme;

public class Lexicon {
    private Vector lexemes = new Vector();
    private String location = null;

    public void addLexeme(Lexeme lexeme) {
        this.lexemes.addElement(lexeme);
    }

    public void addLexeme(Lexeme[] lexemes) {
        int i = 0;
        while (i < lexemes.length) {
            this.addLexeme(lexemes[i]);
            ++i;
        }
    }

    public void removeLexeme(Lexeme lexeme) {
        this.lexemes.removeElement(lexeme);
    }

    public Lexeme getLexeme(int index) {
        return (Lexeme)this.lexemes.elementAt(index);
    }

    public Lexeme[] getLexeme() {
        Lexeme[] lexemes = new Lexeme[this.getLexemeCount()];
        int i = 0;
        while (i < this.getLexemeCount()) {
            lexemes[i] = this.getLexeme(i);
            ++i;
        }
        return lexemes;
    }

    public int getLexemeCount() {
        return this.lexemes.size();
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.lexemes.size() == 0) {
            violations.addViolation("Lexicon contains not lexemes", this.location);
        }
        Enumeration en = this.lexemes.elements();
        while (en.hasMoreElements()) {
            violations.addViolations(((Lexeme)en.nextElement()).validate());
        }
        return violations;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Enumeration en = this.lexemes.elements();
        while (en.hasMoreElements()) {
            buffer.append(en.nextElement().toString());
            if (!en.hasMoreElements()) continue;
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        Lexicon clone = new Lexicon();
        int i = 0;
        while (i < this.lexemes.size()) {
            clone.lexemes.addElement(((Lexeme)this.lexemes.elementAt(i)).clone());
            ++i;
        }
        clone.location = this.location;
        return clone;
    }
}

