/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.pattern;

import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.pattern.Pattern;
import net.sourceforge.chaperon.model.pattern.PatternList;

public class PatternGroup
extends PatternList {
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        int i = 0;
        while (i < this.getPatternCount()) {
            buffer.append(this.getPattern(i).toString());
            ++i;
        }
        buffer.append(")");
        if (this.getMinOccurs() != 1 || this.getMaxOccurs() != 1) {
            if (this.getMinOccurs() == 0 && this.getMaxOccurs() == 1) {
                buffer.append("?");
            } else if (this.getMinOccurs() == 0 && this.getMaxOccurs() == Integer.MAX_VALUE) {
                buffer.append("*");
            } else if (this.getMinOccurs() == 1 && this.getMaxOccurs() == Integer.MAX_VALUE) {
                buffer.append("+");
            } else {
                buffer.append("{");
                buffer.append(String.valueOf(this.getMinOccurs()));
                buffer.append(",");
                buffer.append(String.valueOf(this.getMaxOccurs()));
                buffer.append("}");
            }
        }
        return buffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        PatternGroup clone = new PatternGroup();
        clone.setMinOccurs(this.getMinOccurs());
        clone.setMaxOccurs(this.getMaxOccurs());
        int i = 0;
        while (i < this.getPatternCount()) {
            clone.addPattern((Pattern)this.getPattern(i).clone());
            ++i;
        }
        return clone;
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.getPatternCount() < 1) {
            violations.addViolation("Pattern group doesn't contain elements", this.getLocation());
        }
        int i = 0;
        while (i < this.getPatternCount()) {
            violations.addViolations(this.getPattern(i).validate());
            ++i;
        }
        return violations;
    }
}

