/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.process;

import java.util.HashSet;
import java.util.Stack;
import net.sourceforge.chaperon.common.Decoder;
import net.sourceforge.chaperon.common.IntegerList;
import net.sourceforge.chaperon.process.ParseException;
import net.sourceforge.chaperon.process.ParserAutomaton;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class ParserProcessor
implements ContentHandler,
LexicalHandler {
    public static final String NS_OUTPUT = "http://chaperon.sourceforge.net/schema/syntaxtree/2.0";
    public static final String OUTPUT = "output";
    public static final String ERROR = "error";
    private boolean flatten = false;
    private boolean localizable = false;
    private String source;
    private int lineNumber;
    private int columnNumber;
    private ContentHandler contentHandler = null;
    private LexicalHandler lexicalHandler = null;
    private Locator locator = null;
    private LocatorImpl locatorImpl = null;
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_INSIDE = 1;
    private static final int STATE_LEXEME = 2;
    private static final int STATE_GROUP = 3;
    private static final int STATE_ERROR = 4;
    private int state = 0;
    private ParserAutomaton automaton;
    private IntegerList statestack = new IntegerList();
    private Stack treestack = new Stack();
    private Log log;
    private boolean aborted = false;
    private boolean failsafe = false;
    private StringBuffer erroneoustext = new StringBuffer();
    private ParseException exception = null;
    private HashSet prefixes = new HashSet();

    public ParserProcessor() {
    }

    public ParserProcessor(ParserAutomaton automaton, Log log) {
        this.automaton = automaton;
        this.log = log;
    }

    public void setParserAutomaton(ParserAutomaton automaton) {
        this.automaton = automaton;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setLocalizable(boolean localizable) {
        this.localizable = localizable;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setFailSafe(boolean failsafe) {
        this.failsafe = failsafe;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.locatorImpl = null;
        if (locator != null) {
            this.locatorImpl = new LocatorImpl(locator);
            this.contentHandler.setDocumentLocator(this.locatorImpl);
        }
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
        this.state = 0;
    }

    public void endDocument() throws SAXException {
        if (this.state == 0) {
            this.contentHandler.endDocument();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.state == 0) {
            if (namespaceURI != null && namespaceURI.equals("http://chaperon.sourceforge.net/schema/lexer/2.0") && localName.equals(OUTPUT)) {
                this.handleStartDocument();
                this.state = 1;
                this.source = atts.getValue("source") != null ? atts.getValue("source") : (this.locator != null ? this.locator.getSystemId() : "unknown");
                return;
            } else {
                this.contentHandler.startElement(namespaceURI, localName, qName, atts);
            }
            return;
        } else if (this.state == 1) {
            if (namespaceURI != null && namespaceURI.equals("http://chaperon.sourceforge.net/schema/lexer/2.0") && localName.equals("lexeme")) {
                this.columnNumber = atts.getValue("column") != null ? Integer.parseInt(atts.getValue("column")) : (this.locator != null ? this.locator.getColumnNumber() : 1);
                this.lineNumber = atts.getValue("line") != null ? Integer.parseInt(atts.getValue("line")) : (this.locator != null ? this.locator.getLineNumber() : 1);
                this.handleLexeme(atts.getValue("symbol"), atts.getValue("text"));
                this.state = 2;
                return;
            } else {
                if (namespaceURI == null || !namespaceURI.equals("http://chaperon.sourceforge.net/schema/lexer/2.0") || !localName.equals(ERROR)) throw new SAXException("Unexpected start element.");
                this.columnNumber = atts.getValue("column") != null ? Integer.parseInt(atts.getValue("column")) : (this.locator != null ? this.locator.getColumnNumber() : 1);
                this.lineNumber = atts.getValue("line") != null ? Integer.parseInt(atts.getValue("line")) : (this.locator != null ? this.locator.getLineNumber() : 1);
                this.handleLexeme(ERROR, atts.getValue("text"));
                this.state = 4;
            }
            return;
        } else if (this.state == 2) {
            if (namespaceURI == null || !namespaceURI.equals("http://chaperon.sourceforge.net/schema/lexer/2.0") || !localName.equals("group")) throw new SAXException("Unexpected start element.");
            this.state = 3;
            return;
        } else {
            if (this.state != 4 && this.state != 3) return;
            throw new SAXException("Unexpected start element.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.state == 0) {
            this.contentHandler.endElement(namespaceURI, localName, qName);
            return;
        } else if (this.state == 1) {
            if (namespaceURI == null || !namespaceURI.equals("http://chaperon.sourceforge.net/schema/lexer/2.0") || !localName.equals(OUTPUT)) throw new SAXException("Unexpected end element.");
            this.contentHandler.startPrefixMapping("", NS_OUTPUT);
            AttributesImpl atts = new AttributesImpl();
            if (this.localizable) {
                atts.addAttribute("", "source", "source", "CDATA", this.source);
            }
            this.contentHandler.startElement(NS_OUTPUT, OUTPUT, OUTPUT, atts);
            this.handleEndDocument();
            if (this.exception != null) {
                atts = new AttributesImpl();
                atts.addAttribute("", "message", "message", "CDATA", this.exception.getMessage());
                if (this.exception.isLocalized()) {
                    atts.addAttribute("", "line", "line", "CDATA", String.valueOf(this.exception.getLineNumber()));
                    atts.addAttribute("", "column", "column", "CDATA", String.valueOf(this.exception.getColumnNumber()));
                }
                this.contentHandler.startElement(NS_OUTPUT, ERROR, ERROR, atts);
                if (this.erroneoustext.length() > 0) {
                    this.contentHandler.characters(this.erroneoustext.toString().toCharArray(), 0, this.erroneoustext.length());
                }
                this.contentHandler.endElement(NS_OUTPUT, ERROR, ERROR);
            }
            this.contentHandler.endElement(NS_OUTPUT, OUTPUT, OUTPUT);
            this.contentHandler.endPrefixMapping("");
            this.state = 0;
            return;
        } else if (this.state == 2 || this.state == 4) {
            this.state = 1;
            return;
        } else {
            if (this.state != 3) return;
            this.state = 2;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state == 0) {
            this.contentHandler.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.state == 0) {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!uri.equals("http://chaperon.sourceforge.net/schema/lexer/2.0")) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        } else {
            this.prefixes.add(prefix);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.prefixes.contains(prefix)) {
            this.prefixes.remove(prefix);
        } else {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.locatorImpl != null) {
            this.locatorImpl.setLineNumber(this.locator.getLineNumber());
            this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        }
        if (this.state == 0) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.locatorImpl != null) {
            this.locatorImpl.setLineNumber(this.locator.getLineNumber());
            this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        }
        if (this.state == 0) {
            this.contentHandler.skippedEntity(name);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, len);
        }
    }

    private void handleStartDocument() {
        this.statestack.clear();
        this.statestack.push(0);
        this.treestack.clear();
        this.aborted = false;
        this.erroneoustext = new StringBuffer();
        this.exception = null;
    }

    /*
     * Unable to fully structure code
     */
    private void handleLexeme(String symbolname, String text) throws SAXException {
        if (this.aborted) {
            this.erroneoustext.append(text);
            return;
        }
        symbol = -1;
        i = 0;
        while (i < this.automaton.getTerminalCount() && symbol == -1) {
            if (this.automaton.getTerminal(i).equals(symbolname)) {
                symbol = i;
            }
            ++i;
        }
        state = this.statestack.peek();
        if (symbol == -1) {
            i = 0;
            while (i < this.automaton.getTerminalCount() && symbol == -1) {
                if (this.automaton.getTerminal(i).equals("error")) {
                    symbol = i;
                }
                ++i;
            }
            if (symbol == -1) {
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("State " + state + " unexpected token " + Decoder.toString(text) + "(" + symbolname + ")"));
                }
                this.aborted = true;
                this.exception = new ParseException("Unexpected token " + symbolname + "[" + Decoder.toString(text) + "]", this.source, this.lineNumber, this.columnNumber);
                if (this.failsafe) {
                    return;
                }
                throw this.exception;
            }
            symbolname = "error";
        }
        while (this.automaton.isReduceAction(state, symbol)) {
            production = this.automaton.getReduceProduction(state, symbol);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("State " + state + " reduce " + this.automaton.getNonterminal(this.automaton.getProductionSymbol(production)) + " (" + production + ")"));
            }
            productionnode = new ProductionNode(this.automaton.getNonterminal(this.automaton.getProductionSymbol(production)));
            node = null;
            i = 0;
            while (i < this.automaton.getProductionLength(production)) {
                this.statestack.pop();
                node = (TreeNode)this.treestack.pop();
                productionnode.insert(node);
                ++i;
            }
            if (node != null) {
                productionnode.linenumber = node.linenumber;
                productionnode.columnnumber = node.columnnumber;
            }
            this.treestack.push(productionnode);
            this.statestack.push(this.automaton.getTransition(this.statestack.peek(), this.automaton.getProductionSymbol(production)));
            state = this.statestack.peek();
        }
        if (!this.automaton.isErrorAction(state, symbol)) ** GOTO lbl106
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("State " + state + " error token " + Decoder.toString(text) + "(" + symbolname + ")"));
        }
        while (!(this.statestack.getCount() <= 1 || this.automaton.hasErrorTransition(state, symbol) || !this.automaton.isErrorAction(state, symbol) && symbolname.equals("error"))) {
            this.statestack.pop();
            node = (TreeNode)this.treestack.pop();
            this.erroneoustext.insert(0, node.getText());
            state = this.statestack.peek();
        }
        if (!symbolname.equals("error") && !this.automaton.hasErrorTransition(state, symbol) || symbolname.equals("error") && this.automaton.isErrorAction(state, symbol)) {
            this.erroneoustext.append(text);
            this.aborted = true;
            this.exception = new ParseException("Couldn't accept input " + symbolname + " [" + Decoder.toString(text) + "]", this.source, this.lineNumber, this.columnNumber);
            if (this.failsafe) {
                return;
            }
            throw this.exception;
        }
        if (this.automaton.hasErrorTransition(state, symbol)) {
            this.statestack.push(this.automaton.getErrorTransition(state, symbol));
        } else {
            this.statestack.push(this.automaton.getShiftTransition(state, symbol));
        }
        state = this.statestack.peek();
        if (this.automaton.isErrorAction(state, symbol)) {
            this.erroneoustext.append(text);
        }
        tokennode = new TokenNode("error", this.erroneoustext.toString());
        tokennode.linenumber = this.lineNumber;
        tokennode.columnnumber = this.columnNumber;
        this.erroneoustext = new StringBuffer();
        this.treestack.push(tokennode);
        if (!this.automaton.isErrorAction(state, symbol)) ** GOTO lbl106
        return;
lbl-1000:
        // 1 sources

        {
            production = this.automaton.getReduceProduction(state, symbol);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("State " + state + " reduce " + this.automaton.getNonterminal(this.automaton.getProductionSymbol(production)) + " (" + production + ")"));
            }
            productionnode = new ProductionNode(this.automaton.getNonterminal(this.automaton.getProductionSymbol(production)));
            node = null;
            i = 0;
            while (i < this.automaton.getProductionLength(production)) {
                this.statestack.pop();
                node = (TreeNode)this.treestack.pop();
                productionnode.insert(node);
                ++i;
            }
            if (node != null) {
                productionnode.linenumber = node.linenumber;
                productionnode.columnnumber = node.columnnumber;
            }
            this.treestack.push(productionnode);
            this.statestack.push(this.automaton.getTransition(this.statestack.peek(), this.automaton.getProductionSymbol(production)));
            state = this.statestack.peek();
lbl106:
            // 3 sources

            ** while (this.automaton.isReduceAction((int)state, (int)symbol))
        }
lbl107:
        // 1 sources

        if (this.automaton.isShiftAction(state, symbol)) {
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("State " + state + " shift token " + symbolname + " (" + symbol + ")"));
            }
            this.statestack.push(this.automaton.getShiftTransition(state, symbol));
            tokennode = new TokenNode(symbolname, text);
            tokennode.linenumber = this.lineNumber;
            tokennode.columnnumber = this.columnNumber;
            this.treestack.push(tokennode);
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.aborted) {
            return;
        }
        int state = this.statestack.peek();
        if (this.automaton.isErrorAction(state)) {
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("State " + state + " error unexpected end of file"));
            }
            while (this.statestack.getCount() > 1 && this.automaton.getErrorTransition(state) == 0) {
                this.statestack.pop();
                TreeNode node = (TreeNode)this.treestack.pop();
                this.erroneoustext.insert(0, node.getText());
                state = this.statestack.peek();
            }
            this.statestack.push(this.automaton.getErrorTransition(state));
            state = this.statestack.peek();
            if (this.automaton.isErrorAction(state)) {
                this.exception = new ParseException("Document is incomplete", this.source, this.lineNumber, this.columnNumber);
                if (this.failsafe) {
                    return;
                }
                throw this.exception;
            }
            TokenNode tokennode = new TokenNode(ERROR, this.erroneoustext.toString());
            tokennode.linenumber = this.lineNumber;
            tokennode.columnnumber = this.columnNumber;
            this.erroneoustext = new StringBuffer();
            this.treestack.push(tokennode);
        }
        while (this.automaton.isReduceAction(state) || this.automaton.isAcceptAction(state)) {
            int production = this.automaton.getReduceProduction(state);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("State " + state + " reduce " + this.automaton.getNonterminal(this.automaton.getProductionSymbol(production)) + " (" + production + ")"));
            }
            ProductionNode productionnode = new ProductionNode(this.automaton.getNonterminal(this.automaton.getProductionSymbol(production)));
            TreeNode node = null;
            int i = 0;
            while (i < this.automaton.getProductionLength(production)) {
                this.statestack.pop();
                node = (TreeNode)this.treestack.pop();
                productionnode.insert(node);
                ++i;
            }
            if (node != null) {
                productionnode.linenumber = node.linenumber;
                productionnode.columnnumber = node.columnnumber;
            }
            this.treestack.push(productionnode);
            if (this.automaton.isAcceptAction(state) && this.statestack.getCount() == 1) {
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("State " + state + " accept"));
                }
                if (this.locatorImpl != null) {
                    this.locatorImpl.setSystemId(this.source);
                }
                this.fireEvents(productionnode);
                return;
            }
            this.statestack.push(this.automaton.getTransition(this.statestack.peek(), this.automaton.getProductionSymbol(production)));
            state = this.statestack.peek();
        }
        if (this.automaton.isErrorAction(state) && this.statestack.getCount() > 1) {
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("State " + state + " error unexpected end of file"));
            }
            while (this.statestack.getCount() > 1) {
                this.statestack.pop();
                TreeNode node = (TreeNode)this.treestack.pop();
                this.erroneoustext.insert(0, node.getText());
            }
            this.aborted = true;
            this.exception = new ParseException("Document is incomplete", this.source, this.lineNumber, this.columnNumber);
            if (this.failsafe) {
                return;
            }
            throw this.exception;
        }
    }

    private void fireEvents(TreeNode node) throws SAXException {
        Stack<TreeNode> stack = new Stack<TreeNode>();
        ProductionNode previous = null;
        TreeNode next = node;
        while (true) {
            if (next != null) {
                stack.push(next);
                if (this.locatorImpl != null) {
                    this.locatorImpl.setLineNumber(next.linenumber);
                    this.locatorImpl.setColumnNumber(next.columnnumber);
                }
                if (!this.flatten || previous == null || !previous.symbol.equals(next.symbol)) {
                    AttributesImpl atts = new AttributesImpl();
                    if (this.localizable) {
                        atts.addAttribute("", "line", "line", "CDATA", String.valueOf(next.linenumber));
                        atts.addAttribute("", "column", "column", "CDATA", String.valueOf(next.columnnumber));
                    }
                    this.contentHandler.startElement(NS_OUTPUT, next.symbol, next.symbol, atts);
                }
                if (next instanceof ProductionNode) {
                    ProductionNode production;
                    previous = production = (ProductionNode)next;
                    next = production.firstchild;
                    continue;
                }
                TokenNode token = (TokenNode)next;
                this.contentHandler.characters(token.text.toCharArray(), 0, token.text.length());
                next = null;
                continue;
            }
            next = (TreeNode)stack.pop();
            ProductionNode productionNode = previous = stack.isEmpty() ? null : (ProductionNode)stack.peek();
            if (this.locatorImpl != null) {
                this.locatorImpl.setLineNumber(next.linenumber);
                this.locatorImpl.setColumnNumber(next.columnnumber);
            }
            if (!this.flatten || previous == null || !previous.symbol.equals(next.symbol)) {
                this.contentHandler.endElement(NS_OUTPUT, next.symbol, next.symbol);
            }
            next = next.nextsibling;
            if (stack.isEmpty()) break;
        }
    }

    private class ProductionNode
    extends TreeNode {
        public TreeNode firstchild = null;
        public TreeNode lastchild = null;

        public ProductionNode(String symbol) {
            this.symbol = symbol;
        }

        public void insert(TreeNode node) {
            if (this.firstchild == null) {
                this.firstchild = node;
                this.lastchild = node;
            } else {
                this.firstchild.previoussibling = node;
                node.nextsibling = this.firstchild;
                this.firstchild = node;
            }
        }

        public void insertChilds(ProductionNode production) {
            if (this.firstchild == null) {
                this.firstchild = production.firstchild;
                this.lastchild = production.lastchild;
            } else {
                this.firstchild.previoussibling = production.lastchild;
                production.lastchild.nextsibling = this.firstchild;
                this.firstchild = production.firstchild;
            }
        }

        public String getText() {
            return (this.firstchild != null ? this.firstchild.getText() : "") + (this.nextsibling != null ? this.nextsibling.getText() : "");
        }
    }

    private class TokenNode
    extends TreeNode {
        public String text = null;

        public TokenNode(String symbol, String text) {
            this.symbol = symbol;
            this.text = text;
        }

        public String getText() {
            return this.text + (this.nextsibling != null ? this.nextsibling.getText() : "");
        }
    }

    private abstract class TreeNode {
        public String symbol = null;
        public int linenumber = 1;
        public int columnnumber = 1;
        public TreeNode previoussibling = null;
        public TreeNode nextsibling = null;

        private TreeNode() {
        }

        public abstract String getText();

        public String toString() {
            return this.symbol;
        }
    }
}

