/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import org.apache.batik.ext.awt.geom.RectListManager;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;
import org.apache.batik.ext.awt.image.rendered.TranslateRed;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.ImageRenderer;

public class StaticRenderer
implements ImageRenderer {
    private static final String ILLEGAL_ARGUMENT_NULL_OFFSCREEN = "offScreen should not be null";
    private static final String ILLEGAL_ARGUMENT_ZERO_WIDTH_OR_HEIGHT = "offScreen should have positive width/height";
    protected GraphicsNode rootGN;
    protected Filter rootFilter;
    protected CachableRed rootCR;
    protected SoftReference lastCR;
    protected SoftReference lastCache;
    protected boolean isDoubleBuffered = false;
    protected WritableRaster currentBaseRaster;
    protected WritableRaster currentRaster;
    protected BufferedImage currentOffScreen;
    protected WritableRaster workingBaseRaster;
    protected WritableRaster workingRaster;
    protected BufferedImage workingOffScreen;
    protected int offScreenWidth;
    protected int offScreenHeight;
    protected RenderingHints renderingHints;
    protected AffineTransform usr2dev;
    protected static RenderingHints defaultRenderingHints = new RenderingHints(null);

    public StaticRenderer(RenderingHints renderingHints, AffineTransform affineTransform) {
        this.renderingHints = new RenderingHints(renderingHints);
        this.usr2dev = new AffineTransform(affineTransform);
    }

    public StaticRenderer() {
        this.renderingHints = new RenderingHints(defaultRenderingHints);
        this.usr2dev = new AffineTransform();
    }

    public void dispose() {
        this.rootGN = null;
        this.rootFilter = null;
        this.rootCR = null;
        this.workingOffScreen = null;
        this.workingBaseRaster = null;
        this.workingRaster = null;
        this.currentOffScreen = null;
        this.currentBaseRaster = null;
        this.currentRaster = null;
        this.renderingHints = null;
    }

    public void setTree(GraphicsNode graphicsNode) {
        this.rootGN = graphicsNode;
        this.rootFilter = null;
        this.rootCR = null;
        this.workingOffScreen = null;
        this.workingRaster = null;
        this.currentOffScreen = null;
        this.currentRaster = null;
    }

    public GraphicsNode getTree() {
        return this.rootGN;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = new RenderingHints(renderingHints);
        this.rootFilter = null;
        this.rootCR = null;
        this.workingOffScreen = null;
        this.workingRaster = null;
        this.currentOffScreen = null;
        this.currentRaster = null;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setTransform(AffineTransform affineTransform) {
        if (this.usr2dev.equals(affineTransform)) {
            return;
        }
        this.usr2dev = affineTransform == null ? new AffineTransform() : new AffineTransform(affineTransform);
        this.rootCR = null;
    }

    public AffineTransform getTransform() {
        return this.usr2dev;
    }

    public boolean isDoubleBuffered() {
        return this.isDoubleBuffered;
    }

    public void setDoubleBuffered(boolean bl) {
        if (this.isDoubleBuffered == bl) {
            return;
        }
        this.isDoubleBuffered = bl;
        if (bl) {
            this.currentOffScreen = null;
            this.currentBaseRaster = null;
            this.currentRaster = null;
        } else {
            this.currentOffScreen = this.workingOffScreen;
            this.currentBaseRaster = this.workingBaseRaster;
            this.currentRaster = this.workingRaster;
        }
    }

    public void updateOffScreen(int n, int n2) {
        this.offScreenWidth = n;
        this.offScreenHeight = n2;
    }

    public BufferedImage getOffScreen() {
        if (this.rootGN == null) {
            return null;
        }
        return this.currentOffScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOffScreen() {
        WritableRaster writableRaster;
        if (this.isDoubleBuffered) {
            return;
        }
        this.updateWorkingBuffers();
        if (this.rootCR == null || this.workingBaseRaster == null) {
            return;
        }
        ColorModel colorModel = this.rootCR.getColorModel();
        WritableRaster writableRaster2 = writableRaster = this.workingBaseRaster;
        synchronized (writableRaster2) {
            BufferedImage bufferedImage = new BufferedImage(colorModel, this.workingBaseRaster, colorModel.isAlphaPremultiplied(), null);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.dispose();
        }
    }

    public void repaint(Shape shape) {
        if (shape == null) {
            return;
        }
        RectListManager rectListManager = new RectListManager();
        rectListManager.add(this.usr2dev.createTransformedShape(shape).getBounds());
        this.repaint(rectListManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(RectListManager rectListManager) {
        if (rectListManager == null) {
            return;
        }
        this.updateWorkingBuffers();
        if (this.rootCR == null || this.workingBaseRaster == null) {
            return;
        }
        CachableRed cachableRed = this.rootCR;
        WritableRaster writableRaster = this.workingBaseRaster;
        WritableRaster writableRaster2 = this.workingRaster;
        Rectangle rectangle = this.rootCR.getBounds();
        Rectangle rectangle2 = this.workingRaster.getBounds();
        if (rectangle2.x < rectangle.x || rectangle2.y < rectangle.y || rectangle2.x + rectangle2.width > rectangle.x + rectangle.width || rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
            cachableRed = new PadRed(cachableRed, rectangle2, PadMode.ZERO_PAD, null);
        }
        Object object = writableRaster;
        synchronized (object) {
            cachableRed.copyData(writableRaster2);
        }
        if (!Thread.currentThread().isInterrupted()) {
            object = this.workingOffScreen;
            this.workingBaseRaster = this.currentBaseRaster;
            this.workingRaster = this.currentRaster;
            this.workingOffScreen = this.currentOffScreen;
            this.currentRaster = writableRaster2;
            this.currentBaseRaster = writableRaster;
            this.currentOffScreen = object;
        }
    }

    public void flush() {
        if (this.lastCache == null) {
            return;
        }
        Object t = this.lastCache.get();
        if (t == null) {
            return;
        }
        TileCacheRed tileCacheRed = (TileCacheRed)t;
        tileCacheRed.flushCache(tileCacheRed.getBounds());
    }

    public void flush(Collection collection) {
        AffineTransform affineTransform = this.getTransform();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Shape shape = (Shape)iterator.next();
            Rectangle rectangle = affineTransform.createTransformedShape(shape).getBounds();
            this.flush(rectangle);
        }
    }

    public void flush(Rectangle rectangle) {
        if (this.lastCache == null) {
            return;
        }
        Object t = this.lastCache.get();
        if (t == null) {
            return;
        }
        TileCacheRed tileCacheRed = (TileCacheRed)t;
        rectangle = (Rectangle)rectangle.clone();
        rectangle.x -= Math.round((float)this.usr2dev.getTranslateX());
        rectangle.y -= Math.round((float)this.usr2dev.getTranslateY());
        tileCacheRed.flushCache(rectangle);
    }

    protected CachableRed setupCache(CachableRed cachableRed) {
        if (this.lastCR == null || cachableRed != this.lastCR.get()) {
            this.lastCR = new SoftReference<CachableRed>(cachableRed);
            this.lastCache = null;
        }
        Object var2_2 = null;
        if (this.lastCache != null) {
            var2_2 = this.lastCache.get();
        }
        if (var2_2 != null) {
            return var2_2;
        }
        cachableRed = new TileCacheRed(cachableRed);
        this.lastCache = new SoftReference<CachableRed>(cachableRed);
        return cachableRed;
    }

    protected CachableRed renderGNR() {
        AffineTransform affineTransform = this.usr2dev;
        AffineTransform affineTransform2 = new AffineTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), 0.0, 0.0);
        RenderContext renderContext = new RenderContext(affineTransform2, null, this.renderingHints);
        RenderedImage renderedImage = this.rootFilter.createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed = GraphicsUtil.wrap(renderedImage);
        cachableRed = this.setupCache(cachableRed);
        int n = Math.round((float)affineTransform.getTranslateX());
        int n2 = Math.round((float)affineTransform.getTranslateY());
        cachableRed = new TranslateRed(cachableRed, cachableRed.getMinX() + n, cachableRed.getMinY() + n2);
        cachableRed = GraphicsUtil.convertTosRGB(cachableRed);
        return cachableRed;
    }

    protected void updateWorkingBuffers() {
        if (this.rootFilter == null) {
            this.rootFilter = this.rootGN.getGraphicsNodeRable(true);
            this.rootCR = null;
        }
        this.rootCR = this.renderGNR();
        if (this.rootCR == null) {
            this.workingRaster = null;
            this.workingOffScreen = null;
            this.workingBaseRaster = null;
            this.currentOffScreen = null;
            this.currentBaseRaster = null;
            this.currentRaster = null;
            return;
        }
        SampleModel sampleModel = this.rootCR.getSampleModel();
        int n = this.offScreenWidth;
        int n2 = this.offScreenHeight;
        int n3 = sampleModel.getWidth();
        int n4 = sampleModel.getHeight();
        n = ((n + n3 - 1) / n3 + 1) * n3;
        n2 = ((n2 + n4 - 1) / n4 + 1) * n4;
        if (this.workingBaseRaster == null || this.workingBaseRaster.getWidth() < n || this.workingBaseRaster.getHeight() < n2) {
            sampleModel = sampleModel.createCompatibleSampleModel(n, n2);
            this.workingBaseRaster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
        }
        int n5 = -this.rootCR.getTileGridXOffset();
        int n6 = -this.rootCR.getTileGridYOffset();
        int n7 = n5 >= 0 ? n5 / n3 : (n5 - n3 + 1) / n3;
        int n8 = n6 >= 0 ? n6 / n4 : (n6 - n4 + 1) / n4;
        int n9 = n7 * n3 - n5;
        int n10 = n8 * n4 - n6;
        this.workingRaster = this.workingBaseRaster.createWritableChild(0, 0, n, n2, n9, n10, null);
        this.workingOffScreen = new BufferedImage(this.rootCR.getColorModel(), this.workingRaster.createWritableChild(0, 0, this.offScreenWidth, this.offScreenHeight, 0, 0, null), this.rootCR.getColorModel().isAlphaPremultiplied(), null);
        if (!this.isDoubleBuffered) {
            this.currentOffScreen = this.workingOffScreen;
            this.currentBaseRaster = this.workingBaseRaster;
            this.currentRaster = this.workingRaster;
        }
    }

    static {
        defaultRenderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        defaultRenderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }
}

