/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript.fom;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.matching.helpers.WildcardHelper;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class JavaScriptAspectWeaver
extends AbstractLogEnabled
implements Serviceable {
    ArrayList interceptorGroups = new ArrayList();
    ServiceManager manager = null;
    boolean serializeResultScript = false;
    Source source = null;
    JSTokenList baseScriptTokenList = null;
    boolean areScriptsApplied = false;
    ArrayList stopExecutionFunctions = null;

    public void setBaseScript(Source source) throws Exception {
        this.source = source;
        this.baseScriptTokenList = JSParser.parse(JavaScriptAspectWeaver.readSourceIntoCharArray(source.getInputStream()));
        List scriptsApplied = this.baseScriptTokenList.getScriptsApplied();
        int i = 0;
        while (i < scriptsApplied.size()) {
            this.addInterceptorGroup((String)scriptsApplied.get(i));
            this.areScriptsApplied = true;
            ++i;
        }
    }

    public Reader getInterceptedScriptAsReader() throws Exception {
        this.baseScriptTokenList.commentScriptsApplied();
        this.baseScriptTokenList.addInterceptionEvents(this.stopExecutionFunctions);
        this.baseScriptTokenList.replaceReturnStatements();
        this.baseScriptTokenList.addInterceptions(this.interceptorGroups);
        this.getLogger().info("\n\n" + this.baseScriptTokenList.toString() + "\n");
        if (this.serializeResultScript) {
            this.baseScriptTokenList.writeToFile(this.source);
        }
        return this.baseScriptTokenList.getScriptAsReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInterceptorGroup(String source) throws Exception {
        JSTokenList interceptorsTokensList;
        this.getLogger().info("applied script: " + source);
        SourceResolver resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
        Source src = resolver.resolveURI(source);
        try {
            interceptorsTokensList = JSParser.parse(JavaScriptAspectWeaver.readSourceIntoCharArray(src.getInputStream()));
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            resolver.release(src);
            this.manager.release((Object)resolver);
            throw throwable;
        }
        resolver.release(src);
        this.manager.release((Object)resolver);
        InterceptionList interceptors = interceptorsTokensList.readInterceptionTokens();
        interceptors.setSourceScript(source);
        int i = 0;
        while (i < interceptors.size()) {
            Interceptor interceptor = (Interceptor)interceptors.get(i);
            this.getLogger().info("added Interceptor name[" + interceptor.getName() + "], type[" + interceptor.getType() + "] value[" + new String(interceptor.stream()) + "]");
            ++i;
        }
        this.interceptorGroups.add(interceptors);
    }

    public void setSerializeResultScriptParam(boolean serialize) {
        this.serializeResultScript = serialize;
    }

    public void setStopExecutionFunctionsConf(Configuration conf) throws ConfigurationException {
        this.stopExecutionFunctions = new ArrayList();
        Configuration[] stopExecutionFunctionsConf = conf.getChildren();
        int i = 0;
        while (i < stopExecutionFunctionsConf.length) {
            this.stopExecutionFunctions.add(stopExecutionFunctionsConf[i].getValue());
            ++i;
        }
    }

    protected void clearInterceptorGroups() {
        this.interceptorGroups.clear();
    }

    /*
     * WARNING - void declaration
     */
    public static char[] readSourceIntoCharArray(InputStream is) throws IOException {
        int n;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        char[] b = new char[1024];
        char[] charComplete = new char[]{};
        while ((n = br.read(b)) > 0) {
            void var3_4;
            char[] copy = new char[charComplete.length + var3_4];
            System.arraycopy(charComplete, 0, copy, 0, charComplete.length);
            System.arraycopy(b, 0, copy, charComplete.length, (int)var3_4);
            charComplete = copy;
        }
        return charComplete;
    }

    public boolean areScriptsApplied() {
        return this.areScriptsApplied;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    static class InterceptorEvent
    extends JSToken {
        public static int FNC_START = 51;
        public static int FNC_END = 52;
        public static int STOP_EXEC = 53;
        public static int CONT_EXEC = 54;
        String interceptorName;
        int type;

        public InterceptorEvent(int type) {
            super(type);
        }

        public InterceptorEvent(int type, String name) {
            super(type);
            this.interceptorName = name;
        }

        public String getName() {
            return this.interceptorName;
        }
    }

    static class JSToken
    implements Cloneable {
        public static int START = 0;
        public static int COMMENT = 1;
        public static int LINE_COMMENT = 2;
        public static int LF = 3;
        public static int WHITESPACE = 4;
        public static int BRACKET_LEFT = 5;
        public static int BRACKET_RIGHT = 6;
        public static int BRACKET1_LEFT = 7;
        public static int BRACKET1_RIGHT = 8;
        public static int BRACKET2_LEFT = 9;
        public static int BRACKET2_RIGHT = 10;
        public static int CODE = 11;
        public static int CODE_LITERAL = 12;
        public static int SEMICOLON = 13;
        public static int POINT = 14;
        public static int EQUAL_SIGN = 15;
        public static int COMMA = 16;
        public static int COLON = 17;
        public static int REGEXP = 18;
        public static int UNKNOWN = 19;
        public static int ASTERISK = 20;
        char[] token;
        int type;

        public JSToken(int type) {
            this.type = type;
            this.token = new char[0];
        }

        public JSToken(int type, String tokenValue) {
            this.type = type;
            this.token = tokenValue.toCharArray();
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public boolean equals(String comp) {
            return new String(this.token).equals(comp);
        }

        public char[] stream() {
            return this.token;
        }

        public int size() {
            return this.token.length;
        }

        public JSToken append(char c) {
            char[] copy = new char[this.token.length + 1];
            System.arraycopy(this.token, 0, copy, 0, this.token.length);
            this.token = copy;
            this.token[this.token.length - 1] = c;
            return this;
        }

        public JSToken append(char[] c) {
            char[] copy = new char[this.token.length + c.length];
            System.arraycopy(this.token, 0, copy, 0, this.token.length);
            System.arraycopy(c, 0, copy, this.token.length, c.length);
            this.token = copy;
            return this;
        }

        public JSToken append(String str) {
            char[] c = str.toCharArray();
            this.append(c);
            return this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.token.length) {
                sb.append(this.token[i]);
                ++i;
            }
            return sb.toString();
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public JSToken getClone() {
            JSToken t = null;
            try {
                t = (JSToken)this.clone();
            }
            catch (CloneNotSupportedException e) {}
            return t;
        }
    }

    static class Interceptor
    implements Cloneable {
        public static String STR_BEFORE = "before";
        public static String STR_AFTER = "after";
        public static String STR_AROUND = "around";
        public static String STR_STOP_EXEC = "stopExecution";
        public static String STR_CONT_EXEC = "continueExecution";
        public static String DELIMITER = ":";
        String name;
        String type;
        JSTokenList tokens = new JSTokenList();
        String baseScript;

        public Interceptor(String functionName, String type) {
            this.name = functionName + DELIMITER + type;
            this.type = type;
        }

        public void setBaseScript(String src) {
            this.baseScript = src;
        }

        public String getBaseScript() {
            return this.baseScript;
        }

        public void addToken(JSToken token) {
            this.tokens.add(token);
        }

        public JSTokenList getTokens() {
            return this.tokens;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public char[] stream() {
            char[] charComplete = new char[]{};
            ListIterator li = this.tokens.listIterator();
            while (li.hasNext()) {
                JSToken t = (JSToken)li.next();
                char[] theChar = t.stream();
                char[] copy = new char[charComplete.length + theChar.length];
                System.arraycopy(charComplete, 0, copy, 0, charComplete.length);
                System.arraycopy(theChar, 0, copy, charComplete.length, theChar.length);
                charComplete = copy;
            }
            return charComplete;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public Interceptor getClone() {
            Interceptor interceptor = null;
            try {
                interceptor = (Interceptor)this.clone();
            }
            catch (CloneNotSupportedException e) {}
            return interceptor;
        }
    }

    static class InterceptionList
    extends ArrayList {
        String sourceScript;

        InterceptionList() {
        }

        public void setSourceScript(String source) {
            this.sourceScript = source;
        }

        public String getSourceScript() {
            return this.sourceScript;
        }
    }

    static class JSTokenList
    extends LinkedList {
        public static String RETURN_VARIABLE = "____interceptionReturn____";
        ArrayList cocoonPositions = new ArrayList();
        List stopExecutionFunctions = null;

        JSTokenList() {
        }

        protected void addInterceptions(ArrayList interceptionsList) {
            ListIterator li = this.listIterator();
            boolean inAround = false;
            while (li.hasNext()) {
                Object o = li.next();
                if (inAround) {
                    li.remove();
                }
                if (!(o instanceof InterceptorEvent)) continue;
                InterceptorEvent ie = (InterceptorEvent)o;
                int type = ie.getType();
                if (type == InterceptorEvent.FNC_START) {
                    this.addInterceptionTokens(interceptionsList, ie.getName(), Interceptor.STR_BEFORE, li);
                    inAround = this.addInterceptionTokens(interceptionsList, ie.getName(), Interceptor.STR_AROUND, li);
                    continue;
                }
                if (type == InterceptorEvent.FNC_END) {
                    this.addInterceptionTokens(interceptionsList, ie.getName(), Interceptor.STR_AFTER, li);
                    inAround = false;
                    continue;
                }
                if (type == InterceptorEvent.CONT_EXEC) {
                    this.addInterceptionTokens(interceptionsList, ie.getName(), Interceptor.STR_CONT_EXEC, li);
                    continue;
                }
                if (type != InterceptorEvent.STOP_EXEC) continue;
                this.addInterceptionTokens(interceptionsList, ie.getName(), Interceptor.STR_STOP_EXEC, li);
            }
        }

        public void writeToFile(Source source) throws Exception {
            if (source.getScheme().equals("file")) {
                String filename = source.getURI().substring("file:/".length()) + "_intercepted.js";
                FileOutputStream fos = new FileOutputStream(filename);
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                char[] completeChar = this.getScriptAsCharArray();
                int i = 0;
                while (i < completeChar.length) {
                    bs.write(completeChar[i]);
                    ++i;
                }
                fos.write(bs.toByteArray());
                fos.close();
            }
        }

        private boolean addInterceptionTokens(ArrayList interceptionGroupList, String functionName, String eventType, ListIterator tokensListIt) {
            JSToken t = new JSToken(JSToken.COMMENT);
            ArrayList<Interceptor> matchingInterceptors = new ArrayList<Interceptor>();
            int i = 0;
            while (i < interceptionGroupList.size()) {
                InterceptionList interceptionList = (InterceptionList)interceptionGroupList.get(i);
                ListIterator li = interceptionList.listIterator();
                while (li.hasNext()) {
                    Interceptor interceptor = (Interceptor)li.next();
                    interceptor.setBaseScript(interceptionList.getSourceScript());
                    boolean success = WildcardHelper.match(new HashMap(), (String)(functionName + Interceptor.DELIMITER + eventType), (int[])WildcardHelper.compilePattern((String)interceptor.getName()));
                    if (!success) continue;
                    matchingInterceptors.add(interceptor);
                }
                ++i;
            }
            if (matchingInterceptors.size() > 0) {
                t.append("\n\n/* " + eventType + "():" + "         */\n");
                tokensListIt.add(t);
                ListIterator ili = matchingInterceptors.listIterator();
                while (ili.hasNext()) {
                    Interceptor interceptor = (Interceptor)ili.next();
                    t = new JSToken(JSToken.COMMENT);
                    t.append("\n// interception from: " + interceptor.getName() + " [" + interceptor.getBaseScript() + "]\n");
                    tokensListIt.add(t.getClone());
                    ListIterator interceptorTokensIt = interceptor.getTokens().listIterator();
                    while (interceptorTokensIt.hasNext()) {
                        tokensListIt.add(interceptorTokensIt.next());
                    }
                }
                t = new JSToken(JSToken.COMMENT);
                t.append("\n/* end " + eventType + "():" + "     */\n\n");
                tokensListIt.add(t.getClone());
                return true;
            }
            return false;
        }

        private String getFunctionName(int functionPosition) {
            String functionName = "";
            boolean foundName = false;
            ListIterator li = this.listIterator(functionPosition);
            while (li.hasNext() && !foundName) {
                JSToken t = (JSToken)li.next();
                if (t.getType() == JSToken.CODE) {
                    functionName = t.toString();
                    foundName = true;
                    continue;
                }
                if (t.getType() == JSToken.BRACKET_LEFT) break;
            }
            return functionName;
        }

        private List getFunctionPositions() {
            ArrayList<Integer> functionPosition = new ArrayList<Integer>();
            ListIterator li = this.listIterator();
            while (li.hasNext()) {
                JSToken t = (JSToken)li.next();
                if (t.getType() != JSToken.CODE || !t.equals("function")) continue;
                functionPosition.add(new Integer(li.nextIndex() - 1));
            }
            return functionPosition;
        }

        private String isStopFunction(JSToken curToken, ListIterator liTokens) {
            JSToken n1token = (JSToken)liTokens.next();
            JSToken n2token = (JSToken)liTokens.next();
            liTokens.previous();
            liTokens.previous();
            ListIterator li = this.stopExecutionFunctions.listIterator();
            while (li.hasNext()) {
                String object = "";
                String function = "";
                StringTokenizer st = new StringTokenizer((String)li.next(), ".");
                int countTokens = st.countTokens();
                if (countTokens == 1) {
                    function = st.nextToken();
                    if (!(function = function.substring(0, function.indexOf("("))).equals(curToken.toString())) continue;
                    return function;
                }
                if (countTokens != 2) continue;
                object = st.nextToken();
                function = st.nextToken();
                function = function.substring(0, function.indexOf("("));
                if (!object.equals(curToken.toString()) || n1token.getType() != JSToken.POINT || !function.equals(n2token.toString())) continue;
                return object + "." + function;
            }
            return null;
        }

        protected void addInterceptionEvents(List stopExecutionFunctions) {
            this.stopExecutionFunctions = stopExecutionFunctions;
            List functionPositions = this.getFunctionPositions();
            int diff = 1;
            int i = 0;
            while (i < functionPositions.size()) {
                int pos = (Integer)functionPositions.get(i);
                String functionName = this.getFunctionName(pos + diff);
                ListIterator<InterceptorEvent> li = this.listIterator(pos + diff);
                boolean functionStartSet = false;
                boolean isExecStopFunctionSet = false;
                int countOpenBrackets = 0;
                int countCurToken = pos - 1;
                while (li.hasNext()) {
                    String fnc;
                    ++countCurToken;
                    JSToken t = (JSToken)li.next();
                    int type = t.getType();
                    if (type == JSToken.BRACKET2_LEFT && !functionStartSet) {
                        li.add(new InterceptorEvent(InterceptorEvent.FNC_START, functionName));
                        ++diff;
                        functionStartSet = true;
                        continue;
                    }
                    if (!functionStartSet) continue;
                    if (type == JSToken.BRACKET2_RIGHT && countOpenBrackets == 0) {
                        li.previous();
                        li.add(new InterceptorEvent(InterceptorEvent.FNC_END, functionName));
                        ++diff;
                        break;
                    }
                    if (type == JSToken.BRACKET2_LEFT) {
                        ++countOpenBrackets;
                        continue;
                    }
                    if (type == JSToken.BRACKET2_RIGHT) {
                        --countOpenBrackets;
                        continue;
                    }
                    if (isExecStopFunctionSet) {
                        if (type != JSToken.SEMICOLON) continue;
                        li.add(new InterceptorEvent(InterceptorEvent.CONT_EXEC, functionName));
                        ++diff;
                        isExecStopFunctionSet = false;
                        continue;
                    }
                    if (type != JSToken.CODE || null == (fnc = this.isStopFunction(t, li))) continue;
                    li.previous();
                    li.add(new InterceptorEvent(InterceptorEvent.STOP_EXEC, functionName));
                    ++diff;
                    isExecStopFunctionSet = true;
                }
                ++i;
            }
        }

        protected List getScriptsApplied() {
            ArrayList<String> scriptsApplied = new ArrayList<String>();
            boolean foundCocoon = false;
            boolean foundApply = false;
            int curCocoonPosition = 0;
            ListIterator li = this.listIterator();
            while (li.hasNext()) {
                JSToken t = (JSToken)li.next();
                if (t.getType() == JSToken.CODE) {
                    if (t.equals("cocoon")) {
                        foundCocoon = true;
                        curCocoonPosition = li.previousIndex() + 1;
                        continue;
                    }
                    if (foundCocoon && t.equals("apply")) {
                        foundApply = true;
                        continue;
                    }
                    foundCocoon = false;
                    foundApply = false;
                    curCocoonPosition = 0;
                    continue;
                }
                if (!foundApply || t.getType() != JSToken.CODE_LITERAL) continue;
                String script = t.toString();
                script = script.substring(1, script.length() - 1);
                scriptsApplied.add(script);
                this.cocoonPositions.add(new Integer(curCocoonPosition));
                foundCocoon = false;
                foundApply = false;
            }
            return scriptsApplied;
        }

        protected void commentScriptsApplied() {
            int diff = -1;
            int i = 0;
            while (i < this.cocoonPositions.size()) {
                int pos = (Integer)this.cocoonPositions.get(i);
                ListIterator<JSToken> li = this.listIterator(pos + diff);
                JSToken t = new JSToken(JSToken.COMMENT);
                t.append("/* -> not needed in result script: ");
                li.add(t);
                ++diff;
                while (li.hasNext()) {
                    JSToken tt = (JSToken)li.next();
                    t.append(tt.stream());
                    li.remove();
                    --diff;
                    if (tt.getType() == JSToken.SEMICOLON) break;
                }
                t.append('*').append('/');
                ++i;
            }
        }

        protected void replaceReturnStatements() {
            ListIterator<JSToken> li = this.listIterator();
            int countOpenBrackets = 0;
            boolean inFunction = false;
            boolean foundReturnStatement = false;
            while (li.hasNext()) {
                JSToken t = (JSToken)li.next();
                int type = t.getType();
                if (t instanceof InterceptorEvent) {
                    InterceptorEvent ie = (InterceptorEvent)t;
                    int ieType = ie.getType();
                    if (ieType == InterceptorEvent.FNC_START) {
                        inFunction = true;
                        foundReturnStatement = false;
                        continue;
                    }
                    if (ieType != InterceptorEvent.FNC_END) continue;
                    if (foundReturnStatement) {
                        li.add(new JSToken(JSToken.COMMENT, "/* moved return statement   */"));
                        li.add(new JSToken(JSToken.LF, "\n"));
                        li.add(new JSToken(JSToken.CODE, "return"));
                        li.add(new JSToken(JSToken.WHITESPACE, " "));
                        li.add(new JSToken(JSToken.CODE, RETURN_VARIABLE));
                        li.add(new JSToken(JSToken.SEMICOLON, ";"));
                        li.add(new JSToken(JSToken.LF, "\n"));
                    }
                    inFunction = false;
                    continue;
                }
                if (!inFunction) continue;
                if (type == JSToken.BRACKET2_LEFT) {
                    ++countOpenBrackets;
                    continue;
                }
                if (type == JSToken.BRACKET2_RIGHT) {
                    --countOpenBrackets;
                    continue;
                }
                if (countOpenBrackets != 0 || type != JSToken.CODE || !t.equals("return")) continue;
                li.remove();
                li.add(new JSToken(JSToken.CODE, "var"));
                li.add(new JSToken(JSToken.WHITESPACE, " "));
                li.add(new JSToken(JSToken.CODE, RETURN_VARIABLE));
                li.add(new JSToken(JSToken.WHITESPACE, " "));
                li.add(new JSToken(JSToken.EQUAL_SIGN, "="));
                foundReturnStatement = true;
            }
        }

        private String getInterceptorFunctionName(int functionPosition) {
            StringBuffer functionName = new StringBuffer();
            boolean partOfFunctionFound = false;
            ListIterator li = this.listIterator(functionPosition + 1);
            while (li.hasNext()) {
                JSToken t = (JSToken)li.next();
                int type = t.getType();
                if (type == JSToken.CODE || type == JSToken.ASTERISK) {
                    functionName.append(t.stream());
                    partOfFunctionFound = true;
                    continue;
                }
                if (partOfFunctionFound) break;
            }
            return functionName.toString();
        }

        protected InterceptionList readInterceptionTokens() {
            InterceptionList interceptors = new InterceptionList();
            List functionPositions = this.getFunctionPositions();
            int i = 0;
            while (i < functionPositions.size()) {
                int pos = (Integer)functionPositions.get(i);
                String interceptingFunctionName = this.getInterceptorFunctionName(pos);
                boolean inFunction = false;
                boolean inInterceptor = false;
                Interceptor curInterceptor = null;
                String interceptorType = "";
                int countOpenBrackets = 0;
                ListIterator li = this.listIterator(pos + 2);
                while (li.hasNext()) {
                    JSToken t = (JSToken)li.next();
                    int type = t.getType();
                    if (type == JSToken.BRACKET2_LEFT && !inFunction) {
                        inFunction = true;
                        continue;
                    }
                    if (!inFunction) continue;
                    if (!inInterceptor && type == JSToken.CODE) {
                        if (t.equals(Interceptor.STR_BEFORE)) {
                            interceptorType = Interceptor.STR_BEFORE;
                            continue;
                        }
                        if (t.equals(Interceptor.STR_AFTER)) {
                            interceptorType = Interceptor.STR_AFTER;
                            continue;
                        }
                        if (t.equals(Interceptor.STR_AROUND)) {
                            interceptorType = Interceptor.STR_AROUND;
                            continue;
                        }
                        if (t.equals(Interceptor.STR_STOP_EXEC)) {
                            interceptorType = Interceptor.STR_STOP_EXEC;
                            continue;
                        }
                        if (!t.equals(Interceptor.STR_CONT_EXEC)) continue;
                        interceptorType = Interceptor.STR_CONT_EXEC;
                        continue;
                    }
                    if (!inInterceptor && type == JSToken.BRACKET2_LEFT) {
                        inInterceptor = true;
                        curInterceptor = new Interceptor(interceptingFunctionName, interceptorType);
                        ++countOpenBrackets;
                        continue;
                    }
                    if (inInterceptor && type == JSToken.BRACKET2_RIGHT && countOpenBrackets == 0 || !inInterceptor) continue;
                    if (type == JSToken.BRACKET2_LEFT) {
                        ++countOpenBrackets;
                    } else if (type == JSToken.BRACKET2_RIGHT) {
                        --countOpenBrackets;
                    }
                    if (type == JSToken.BRACKET2_RIGHT && countOpenBrackets == 0) {
                        interceptors.add(curInterceptor.getClone());
                        inInterceptor = false;
                        interceptorType = "";
                        curInterceptor = null;
                        continue;
                    }
                    curInterceptor.addToken(t);
                }
                ++i;
            }
            return interceptors;
        }

        public Reader getScriptAsReader() {
            return new CharArrayReader(this.getScriptAsCharArray());
        }

        public char[] getScriptAsCharArray() {
            ListIterator li = this.listIterator();
            char[] charComplete = new char[]{};
            while (li.hasNext()) {
                JSToken t = (JSToken)li.next();
                char[] theChar = t.stream();
                char[] copy = new char[charComplete.length + theChar.length];
                System.arraycopy(charComplete, 0, copy, 0, charComplete.length);
                System.arraycopy(theChar, 0, copy, charComplete.length, theChar.length);
                charComplete = copy;
            }
            return charComplete;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            ListIterator li = this.listIterator();
            while (li.hasNext()) {
                JSToken t = (JSToken)li.next();
                sb.append(t.stream());
            }
            return sb.toString();
        }

        public String debugToString() {
            StringBuffer sb = new StringBuffer();
            ListIterator li = this.listIterator();
            while (li.hasNext()) {
                JSToken t = (JSToken)li.next();
                sb.append("\n------------------------------------\n");
                sb.append("type: ").append(t.getType()).append("\n");
                sb.append(t.stream());
            }
            return sb.toString();
        }
    }

    static class JSParser {
        public static int SPACES_FOR_TAB = 4;
        public static int AT_START = 0;
        public static int IN_COMMENT = 1;
        public static int IN_LINECOMMENT = 2;
        public static int IN_LF = 3;
        public static int IN_WHITESPACE = 4;
        public static int IN_CODE = 5;
        public static int IN_CODE_LIT = 6;
        public static int IN_DOUBLE_QUOTES = 7;
        public static int IN_SINGLE_QUOTES = 8;
        public static int IN_REGEXP = 9;

        JSParser() {
        }

        /*
         * Unable to fully structure code
         */
        public static JSTokenList parse(char[] c) {
            parsingState = JSParser.AT_START;
            tokenList = new JSTokenList();
            curToken = null;
            i = 0;
            while (i < c.length) {
                block60: {
                    block67: {
                        block66: {
                            block63: {
                                block65: {
                                    block64: {
                                        block62: {
                                            block61: {
                                                block59: {
                                                    thisChar = c[i];
                                                    nextChar = '\u0000';
                                                    if (i < c.length - 1) {
                                                        nextChar = c[i + 1];
                                                    }
                                                    if (parsingState != JSParser.IN_COMMENT) break block59;
                                                    if (thisChar == '*' && nextChar == '/') {
                                                        curToken.append('*').append('/');
                                                        tokenList.add(curToken.getClone());
                                                        parsingState = JSParser.AT_START;
                                                        ++i;
                                                    } else {
                                                        curToken.append(thisChar);
                                                    }
                                                    break block60;
                                                }
                                                if (parsingState != JSParser.IN_LINECOMMENT) break block61;
                                                if (thisChar == '\n') {
                                                    curToken.append(thisChar);
                                                    if (nextChar == '\r') {
                                                        ++i;
                                                    }
                                                    tokenList.add(curToken.getClone());
                                                    parsingState = JSParser.AT_START;
                                                } else {
                                                    curToken.append(thisChar);
                                                }
                                                ** GOTO lbl-1000
                                            }
                                            if (parsingState != JSParser.IN_CODE) break block62;
                                            if (!JSParser.isJSIdentifierPartCharacter(thisChar)) {
                                                tokenList.add(curToken.getClone());
                                                parsingState = JSParser.AT_START;
                                            } else {
                                                curToken.append(thisChar);
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        if (parsingState != JSParser.IN_WHITESPACE) break block63;
                                        if (thisChar == ' ' && thisChar == '\t') break block64;
                                        tokenList.add(curToken.getClone());
                                        parsingState = JSParser.AT_START;
                                        ** GOTO lbl-1000
                                    }
                                    if (thisChar != ' ') break block65;
                                    curToken.append(thisChar);
                                    ** GOTO lbl-1000
                                }
                                if (thisChar != '\t') ** GOTO lbl-1000
                                count = 1;
                                while (count <= JSParser.SPACES_FOR_TAB) {
                                    curToken.append(' ');
                                    ++count;
                                }
                                ** GOTO lbl-1000
                            }
                            if (parsingState != JSParser.IN_SINGLE_QUOTES) break block66;
                            curToken.append(thisChar);
                            if (thisChar != '\'') ** GOTO lbl-1000
                            tokenList.add(curToken.getClone());
                            parsingState = JSParser.AT_START;
                            break block60;
                        }
                        if (parsingState != JSParser.IN_DOUBLE_QUOTES) break block67;
                        curToken.append(thisChar);
                        if (thisChar != '\"') ** GOTO lbl-1000
                        tokenList.add(curToken.getClone());
                        parsingState = JSParser.AT_START;
                        break block60;
                    }
                    if (parsingState != JSParser.IN_REGEXP) ** GOTO lbl-1000
                    curToken.append(thisChar);
                    if (thisChar == '/') {
                        tokenList.add(curToken.getClone());
                        parsingState = JSParser.AT_START;
                    } else if (parsingState == JSParser.AT_START) {
                        if (thisChar == '/' && nextChar == '*') {
                            t = new JSToken(JSToken.COMMENT);
                            curToken = t.append('/').append('*');
                            parsingState = JSParser.IN_COMMENT;
                            ++i;
                        } else if (thisChar == '/' && nextChar == '/') {
                            t = new JSToken(JSToken.LINE_COMMENT);
                            curToken = t.append(thisChar).append(nextChar);
                            parsingState = JSParser.IN_LINECOMMENT;
                            ++i;
                        } else if (JSParser.isJSIdentifierStartCharacter(thisChar)) {
                            t = new JSToken(JSToken.CODE);
                            curToken = t.append(thisChar);
                            parsingState = JSParser.IN_CODE;
                        } else if (thisChar == ' ') {
                            t = new JSToken(JSToken.WHITESPACE);
                            curToken = t.append(thisChar);
                            parsingState = JSParser.IN_WHITESPACE;
                        } else if (thisChar == '\t') {
                            curToken = t = new JSToken(JSToken.WHITESPACE);
                            count = 1;
                            while (count <= JSParser.SPACES_FOR_TAB) {
                                curToken.append(' ');
                                ++count;
                            }
                            parsingState = JSParser.IN_WHITESPACE;
                        } else if (thisChar == '\"') {
                            t = new JSToken(JSToken.CODE_LITERAL);
                            curToken = t.append(thisChar);
                            parsingState = JSParser.IN_DOUBLE_QUOTES;
                        } else if (thisChar == '\'') {
                            t = new JSToken(JSToken.CODE_LITERAL);
                            curToken = t.append(thisChar);
                            parsingState = JSParser.IN_SINGLE_QUOTES;
                        } else if (thisChar == '\r') {
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == '\n') {
                            t = new JSToken(JSToken.LF);
                            curToken = t.append(thisChar);
                            if (nextChar == '\r') {
                                ++i;
                            }
                            tokenList.add(t.getClone());
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == '/') {
                            t = new JSToken(JSToken.REGEXP);
                            curToken = t.append(thisChar);
                            parsingState = JSParser.IN_REGEXP;
                        } else if (thisChar == '(') {
                            t = new JSToken(JSToken.BRACKET_LEFT);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == ')') {
                            t = new JSToken(JSToken.BRACKET_RIGHT);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == '[') {
                            t = new JSToken(JSToken.BRACKET1_LEFT);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == ']') {
                            t = new JSToken(JSToken.BRACKET1_RIGHT);
                            curToken = t.append(thisChar);
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == '{') {
                            t = new JSToken(JSToken.BRACKET2_LEFT);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == '}') {
                            t = new JSToken(JSToken.BRACKET2_RIGHT);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == '.') {
                            t = new JSToken(JSToken.POINT);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == ';') {
                            t = new JSToken(JSToken.SEMICOLON);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == '=') {
                            t = new JSToken(JSToken.EQUAL_SIGN);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == ',') {
                            t = new JSToken(JSToken.COMMA);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == ':') {
                            t = new JSToken(JSToken.COLON);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        } else if (thisChar == '*') {
                            t = new JSToken(JSToken.ASTERISK);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        } else {
                            t = new JSToken(JSToken.UNKNOWN);
                            tokenList.add(t.append(thisChar));
                            parsingState = JSParser.AT_START;
                        }
                    }
                }
                ++i;
            }
            return tokenList;
        }

        private static boolean isJSIdentifierPartCharacter(char c) {
            return Character.isJavaIdentifierPart(c) && c != '(' && c != ')' && c != '[' && c != ']' && c != '{' && c != '}';
        }

        private static boolean isJSIdentifierStartCharacter(char c) {
            return Character.isJavaIdentifierStart(c);
        }
    }
}

