/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.StringReader;
import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RequestAttributeGenerator
extends ServiceableGenerator {
    public static final String REQUEST_ATTRIBUTE_NAME = "attribute-name";
    public static final String REQUEST_ATTRIBUTE_NAME_DEFAULT = "org.apache.cocoon.xml-data";

    public void generate() throws SAXException, ProcessingException {
        String parameter = this.parameters.getParameter(REQUEST_ATTRIBUTE_NAME, REQUEST_ATTRIBUTE_NAME_DEFAULT);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Expecting xml data in request-attribute " + parameter);
        }
        String contentType = null;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        byte[] xml_data = (byte[])request.getAttribute(parameter);
        if (xml_data == null) {
            throw new ProcessingException("request-attribute " + parameter + " is null, no xml-data for processing");
        }
        SAXParser parser = null;
        try {
            try {
                String charset;
                String sXml = new String(xml_data);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("processing : " + sXml);
                }
                InputSource inputSource = new InputSource(new StringReader(sXml));
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("processing request attribute ");
                }
                if ((charset = this.getCharacterEncoding(response, contentType)) != null) {
                    inputSource.setEncoding(charset);
                }
                parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                parser.parse(inputSource, (ContentHandler)this.xmlConsumer);
            }
            catch (Exception e) {
                this.getLogger().error("Could not get parser", (Throwable)e);
                throw new ProcessingException("Exception in RequestAttributeGenerator.generate()", (Throwable)e);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.manager.release(parser);
            throw throwable;
        }
        this.manager.release((Object)parser);
    }

    protected String getCharacterEncoding(Response res, String contentType) {
        String charencoding = null;
        String charset = "charset=";
        if (contentType == null) {
            return null;
        }
        int idx = contentType.indexOf(charset);
        if (idx == -1) {
            return null;
        }
        try {
            charencoding = res.getCharacterEncoding();
            if (charencoding != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("charset from container: " + charencoding);
                }
                if ((charencoding = charencoding.trim()).length() > 2 && charencoding.startsWith("\"") && charencoding.endsWith("\"")) {
                    charencoding = charencoding.substring(1, charencoding.length() - 1);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("charset from container clean: " + charencoding);
                }
                return charencoding;
            }
            return this.extractCharset(contentType, idx);
        }
        catch (Throwable e) {
            return this.extractCharset(contentType, idx);
        }
    }

    protected String extractCharset(String contentType, int idx) {
        int idxEnd;
        String charencoding = null;
        String charset = "charset=";
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("charset from extractCharset");
        }
        if ((idxEnd = (charencoding = contentType.substring(idx + charset.length())).indexOf(";")) != -1) {
            charencoding = charencoding.substring(0, idxEnd);
        }
        if ((charencoding = charencoding.trim()).length() > 2 && charencoding.startsWith("\"") && charencoding.endsWith("\"")) {
            charencoding = charencoding.substring(1, charencoding.length() - 1);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("charset from extractCharset: " + charencoding);
        }
        return charencoding.trim();
    }
}

