/*
 * Decompiled with CFR 0.152.
 */
package com.ryangrier.ant;

import com.ryangrier.ant.ManifestFile;
import com.ryangrier.ant.TaskTools;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class VersionUpdate
extends Task {
    private static final String VERSION_UPDATE_VERSION = "1.3.0";
    private File srcdir;
    private String variablename = "version";
    private String antPropertyName = "VersionTool_Version";
    private String classname;
    private File classFile;
    private Vector manifestFiles = new Vector();
    public static final String[] versionTypes = new String[]{"Major", "Point", "Minor"};
    private static final int MAJOR_VERSION = 0;
    private static final int POINT_VERSION = 1;
    private static final int MINOR_VERSION = 2;
    private int versionupdatetype = 2;
    private String fileContents;
    private String propertyName = null;
    private boolean debug = false;

    public void execute() throws BuildException {
        if (null == this.srcdir) {
            throw new BuildException("The srcdir variable cannot be null.");
        }
        if (null == this.classname) {
            throw new BuildException("The classname variable cannot be null.");
        }
        this.classFile = TaskTools.getFilePathFromClassName(this.srcdir, this.classname);
        if (this.classFile.exists()) {
            try {
                this.fileContents = TaskTools.readFile(this.classFile);
                String currentVersion = TaskTools.findVariableNameValueInClassFile(this.fileContents, this.variablename);
                if (currentVersion.length() < 1) {
                    throw new BuildException("Cannot find the variable : " + this.variablename);
                }
                String newVersion = this.getNewVersion(currentVersion);
                this.fileContents = TaskTools.replaceOldVersion(this.fileContents, currentVersion, newVersion);
                if (this.debug) {
                    System.out.println("Updating " + this.classFile.getName() + " from v. " + currentVersion + " to v. " + newVersion);
                }
                TaskTools.writeFile(this.classFile, this.fileContents.getBytes());
                this.getProject().setNewProperty(this.antPropertyName, newVersion);
                if (null != this.propertyName) {
                    this.getProject().setNewProperty(this.propertyName, newVersion);
                }
                this.updateManifestFiles(newVersion);
            }
            catch (Exception ex) {
                throw new BuildException(ex.toString());
            }
        } else {
            throw new BuildException("The File: " + this.classFile.getPath() + " does not exist.");
        }
    }

    public void setSrcdir(File srcdir) {
        this.srcdir = srcdir;
    }

    public void addManifestFile(ManifestFile manifestFile) {
        this.manifestFiles.add(manifestFile);
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setVariablename(String variablename) {
        this.variablename = variablename;
    }

    public void setVersionupdatetype(String versionupdatetype) {
        this.versionupdatetype = versionupdatetype.equals(versionTypes[1]) ? 1 : (versionupdatetype.equals(versionTypes[0]) ? 0 : 2);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    private String getNewVersion(String currentVersion) {
        StringTokenizer st = new StringTokenizer(currentVersion, ".");
        StringBuffer sb = new StringBuffer();
        int tokens = st.countTokens();
        int i = 0;
        boolean zeroOut = false;
        while (st.hasMoreTokens()) {
            String smallChunkOfVersion = st.nextToken();
            if (this.versionupdatetype == i) {
                int version = Integer.parseInt(smallChunkOfVersion);
                sb.append(++version);
                zeroOut = true;
            } else if (zeroOut) {
                sb.append("0");
            } else {
                sb.append(smallChunkOfVersion);
            }
            ++i;
            if (!st.hasMoreTokens()) continue;
            sb.append(".");
        }
        while (tokens < 3) {
            sb.append(".0");
            ++tokens;
        }
        return sb.toString();
    }

    private void updateManifestFiles(String newVersion) throws Exception {
        Enumeration enumeration = this.manifestFiles.elements();
        while (enumeration.hasMoreElements()) {
            ManifestFile manifest = (ManifestFile)enumeration.nextElement();
            manifest.execute(newVersion);
        }
    }

    public static void main(String[] args) {
        System.out.println("VersionUpdate Version: 1.3.0");
    }
}

