/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.components;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.RequestLifecycleComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.webapps.session.ContextManager;
import org.apache.cocoon.webapps.session.FormManager;
import org.apache.cocoon.webapps.session.SessionManager;
import org.apache.cocoon.webapps.session.TransactionManager;
import org.xml.sax.SAXException;

public abstract class AbstractSessionComponent
extends AbstractLogEnabled
implements Component,
Composable,
Recomposable,
Recyclable,
RequestLifecycleComponent {
    private SessionManager sessionManager;
    private FormManager formManager;
    private ContextManager contextManager;
    private TransactionManager transactionManager;
    protected ComponentManager manager;
    protected Map objectModel;
    protected SourceResolver resolver;
    protected Request request;
    protected Response response;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void recompose(ComponentManager componentManager) throws ComponentException {
        this.recycle();
        this.manager = componentManager;
    }

    public void setup(SourceResolver resolver, Map objectModel) throws ProcessingException, SAXException, IOException {
        this.objectModel = objectModel;
        this.resolver = resolver;
        this.request = ObjectModelHelper.getRequest((Map)objectModel);
        this.response = ObjectModelHelper.getResponse((Map)objectModel);
    }

    protected SessionManager getSessionManager() throws ProcessingException {
        if (this.sessionManager == null) {
            try {
                this.sessionManager = (SessionManager)this.manager.lookup(SessionManager.ROLE);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Error during lookup of SessionManager component.", (Throwable)ce);
            }
        }
        return this.sessionManager;
    }

    protected ContextManager getContextManager() throws ProcessingException {
        if (this.contextManager == null) {
            try {
                this.contextManager = (ContextManager)this.manager.lookup(ContextManager.ROLE);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Error during lookup of ContextManager component.", (Throwable)ce);
            }
        }
        return this.contextManager;
    }

    protected TransactionManager getTransactionManager() throws ProcessingException {
        if (this.transactionManager == null) {
            try {
                this.transactionManager = (TransactionManager)this.manager.lookup(TransactionManager.ROLE);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Error during lookup of TransactionManager component.", (Throwable)ce);
            }
        }
        return this.transactionManager;
    }

    protected FormManager getFormManager() throws ProcessingException {
        if (this.formManager == null) {
            try {
                this.formManager = (FormManager)this.manager.lookup(FormManager.ROLE);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Error during lookup of FormManager component.", (Throwable)ce);
            }
        }
        return this.formManager;
    }

    public void recycle() {
        if (this.manager != null) {
            this.manager.release((Component)this.sessionManager);
            this.manager.release((Component)this.formManager);
            this.manager.release((Component)this.contextManager);
            this.manager.release((Component)this.transactionManager);
        }
        this.transactionManager = null;
        this.sessionManager = null;
        this.formManager = null;
        this.contextManager = null;
        this.objectModel = null;
        this.resolver = null;
        this.request = null;
        this.response = null;
    }
}

