/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.coplet.adapter.impl;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.portal.coplet.CopletData;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.coplet.adapter.CopletAdapter;
import org.apache.cocoon.portal.coplet.adapter.impl.LoaderThread;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractCopletAdapter
extends AbstractLogEnabled
implements CopletAdapter,
ThreadSafe,
Serviceable {
    protected ServiceManager manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    protected Object getConfiguration(CopletInstanceData coplet, String key) {
        CopletData copletData = coplet.getCopletData();
        Object data = copletData.getAttribute(key);
        if (data == null) {
            data = copletData.getCopletBaseData().getCopletConfig().get(key);
        }
        return data;
    }

    public abstract void streamContent(CopletInstanceData var1, ContentHandler var2) throws SAXException;

    public void toSAX(CopletInstanceData coplet, ContentHandler contentHandler) throws SAXException {
        Boolean bool = (Boolean)this.getConfiguration(coplet, "buffer");
        Integer timeout = (Integer)this.getConfiguration(coplet, "timeout");
        if (timeout != null) {
            bool = Boolean.TRUE;
        }
        if (bool != null && bool.booleanValue()) {
            Exception error;
            SaxBuffer buffer;
            boolean read;
            block12: {
                read = false;
                buffer = new SaxBuffer();
                error = null;
                try {
                    if (timeout != null) {
                        int milli = timeout * 1000;
                        LoaderThread loader = new LoaderThread(this, coplet, (ContentHandler)buffer);
                        Thread thread = new Thread(loader);
                        thread.start();
                        try {
                            thread.join(milli);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        if (loader.finished) {
                            read = true;
                        }
                        break block12;
                    }
                    this.streamContent(coplet, (ContentHandler)buffer);
                    read = true;
                }
                catch (Exception exception) {
                    error = exception;
                    this.getLogger().warn("Unable to get content of coplet: " + coplet.getId(), (Throwable)exception);
                }
            }
            if (read) {
                buffer.toSAX(contentHandler);
            } else if (!this.renderErrorContent(coplet, contentHandler, error)) {
                contentHandler.startDocument();
                XMLUtils.startElement((ContentHandler)contentHandler, (String)"p");
                XMLUtils.data((ContentHandler)contentHandler, (String)("The coplet " + coplet.getId() + " is currently not available."));
                XMLUtils.endElement((ContentHandler)contentHandler, (String)"p");
                contentHandler.endDocument();
            }
        } else {
            this.streamContent(coplet, contentHandler);
        }
    }

    public void init(CopletInstanceData coplet) {
    }

    public void destroy(CopletInstanceData coplet) {
    }

    public void login(CopletInstanceData coplet) {
        Iterator iter = coplet.getCopletData().getAttributes().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!entry.getKey().toString().startsWith("temporary:")) continue;
            coplet.setTemporaryAttribute(entry.getKey().toString().substring(10), entry.getValue());
        }
    }

    public void logout(CopletInstanceData coplet) {
    }

    protected boolean renderErrorContent(CopletInstanceData coplet, ContentHandler handler, Exception error) throws SAXException {
        return false;
    }
}

