/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.pluto;

import java.util.HashSet;
import java.util.Iterator;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.pluto.PortalContextProviderImpl;
import org.apache.cocoon.portal.pluto.PortletActionProviderImpl;
import org.apache.cocoon.portal.pluto.PortletURLProviderImpl;
import org.apache.cocoon.portal.pluto.ResourceURLProviderImpl;
import org.apache.cocoon.portal.pluto.om.PortletEntityImpl;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.PortletActionProvider;
import org.apache.pluto.services.information.PortletURLProvider;
import org.apache.pluto.services.information.ResourceURLProvider;

public class DynamicInformationProviderImpl
implements DynamicInformationProvider {
    protected final ServiceManager manager;
    protected final PortalContextProviderImpl provider;
    protected static HashSet responseMimeTypes = new HashSet();

    public DynamicInformationProviderImpl(ServiceManager manager, PortalContextProviderImpl provider) {
        this.manager = manager;
        this.provider = provider;
    }

    public PortletURLProvider getPortletURLProvider(PortletWindow portletWindow) {
        return new PortletURLProviderImpl(portletWindow, this.manager);
    }

    public ResourceURLProvider getResourceURLProvider(PortletWindow portletWindow) {
        return new ResourceURLProviderImpl(this.provider);
    }

    public PortletActionProvider getPortletActionProvider(PortletWindow portletWindow) {
        return new PortletActionProviderImpl(portletWindow);
    }

    public PortletMode getPortletMode(PortletWindow portletWindow) {
        CopletInstanceData cid = ((PortletEntityImpl)portletWindow.getPortletEntity()).getCopletInstanceData();
        PortletMode pm = (PortletMode)cid.getAttribute("portlet-mode");
        if (pm == null) {
            pm = PortletMode.VIEW;
        }
        return pm;
    }

    public PortletMode getPreviousPortletMode(PortletWindow portletWindow) {
        CopletInstanceData cid = ((PortletEntityImpl)portletWindow.getPortletEntity()).getCopletInstanceData();
        PortletMode pm = (PortletMode)cid.getAttribute("previous-portlet-mode");
        return pm;
    }

    public WindowState getWindowState(PortletWindow portletWindow) {
        CopletInstanceData cid = ((PortletEntityImpl)portletWindow.getPortletEntity()).getCopletInstanceData();
        WindowState ws = (WindowState)cid.getAttribute("window-state");
        if (ws == null) {
            ws = WindowState.NORMAL;
        }
        return ws;
    }

    public WindowState getPreviousWindowState(PortletWindow portletWindow) {
        CopletInstanceData cid = ((PortletEntityImpl)portletWindow.getPortletEntity()).getCopletInstanceData();
        WindowState ws = (WindowState)cid.getAttribute("previous-window-state");
        return ws;
    }

    public String getResponseContentType() {
        return "text/html";
    }

    public Iterator getResponseContentTypes() {
        return responseMimeTypes.iterator();
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        return this.provider.getSupportedPortletModes().contains(mode);
    }

    public boolean isWindowStateAllowed(WindowState state) {
        return this.provider.getSupportedWindowStates().contains(state);
    }

    static {
        responseMimeTypes.add("text/html");
    }
}

