/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferDb;
import org.hsqldb.util.TransferHelper;

class SqlServerTransferHelper
extends TransferHelper {
    private boolean firstTinyintRow;
    private boolean firstSmallintRow;

    SqlServerTransferHelper() {
    }

    SqlServerTransferHelper(TransferDb transferDb, Traceable traceable, String string) {
        super(transferDb, traceable, string);
    }

    String formatTableName(String string) {
        if (string == null) {
            return string;
        }
        if (string.equals("")) {
            return string;
        }
        if (string.indexOf(32) != -1) {
            return "[" + string + "]";
        }
        return this.formatIdentifier(string);
    }

    int convertFromType(int n) {
        if (n == 11) {
            this.tracer.trace("Converted DATETIME (type 11) to TIMESTAMP");
            n = 93;
        } else if (n == -9) {
            this.tracer.trace("Converted NVARCHAR (type -9) to VARCHAR");
            n = 12;
        } else if (n == -8) {
            this.tracer.trace("Converted NCHAR (type -8) to VARCHAR");
            n = 12;
        } else if (n == -10) {
            this.tracer.trace("Converted NTEXT (type -10) to VARCHAR");
            n = 12;
        } else if (n == -1) {
            this.tracer.trace("Converted LONGTEXT (type -1) to LONGVARCHAR");
            n = -1;
        }
        return n;
    }

    void beginTransfer() {
        this.firstSmallintRow = true;
        this.firstTinyintRow = true;
    }

    Object convertColumnValue(Object object, int n, int n2) {
        if (n2 == 5 && object instanceof Integer) {
            if (this.firstSmallintRow) {
                this.firstSmallintRow = false;
                this.tracer.trace("SMALLINT: Converted column " + n + " Integer to Short");
            }
            object = new Short((short)((Integer)object).intValue());
        } else if (n2 == -6 && object instanceof Integer) {
            if (this.firstTinyintRow) {
                this.firstTinyintRow = false;
                this.tracer.trace("TINYINT: Converted column " + n + " Integer to Byte");
            }
            object = new Byte((byte)((Integer)object).intValue());
        }
        return object;
    }
}

