/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching;

import java.io.IOException;
import java.io.OutputStream;

public final class CachingOutputStream
extends OutputStream {
    private OutputStream receiver;
    private byte[] buf;
    private int bufCount;

    public CachingOutputStream(OutputStream os) {
        this.receiver = os;
        this.buf = new byte[1024];
        this.bufCount = 0;
    }

    public byte[] getContent() {
        byte[] newbuf = new byte[this.bufCount];
        System.arraycopy(this.buf, 0, newbuf, 0, this.bufCount);
        return newbuf;
    }

    public void write(int b) throws IOException {
        this.receiver.write(b);
        int newcount = this.bufCount + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.bufCount);
            this.buf = newbuf;
        }
        this.buf[this.bufCount] = (byte)b;
        this.bufCount = newcount;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.receiver.write(b, off, len);
        if (len == 0) {
            return;
        }
        int newcount = this.bufCount + (len - off);
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.bufCount);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.bufCount, len);
        this.bufCount = newcount;
    }

    public void flush() throws IOException {
        this.receiver.flush();
    }

    public void close() throws IOException {
        this.receiver.close();
    }
}

