/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.cocoon.util.ByteRange;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public class ResourceReader
extends AbstractReader
implements CacheableProcessingComponent,
Parameterizable {
    private static final Map documents = new HashMap();
    protected Source inputSource;
    protected InputStream inputStream;
    protected boolean quickTest;
    protected boolean byteRanges;
    protected Response response;
    protected Request request;
    protected long expires;
    protected int bufferSize;
    protected long configuredExpires;
    protected boolean configuredQuickTest;
    protected int configuredBufferSize;
    protected boolean configuredByteRanges;

    public void parameterize(Parameters parameters) throws ParameterException {
        this.configuredExpires = parameters.getParameterAsLong("expires", -1L);
        this.configuredQuickTest = parameters.getParameterAsBoolean("quick-modified-test", false);
        this.configuredBufferSize = parameters.getParameterAsInteger("buffer-size", 8192);
        this.configuredByteRanges = parameters.getParameterAsBoolean("byte-ranges", true);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.request = ObjectModelHelper.getRequest(objectModel);
        this.response = ObjectModelHelper.getResponse(objectModel);
        this.expires = par.getParameterAsLong("expires", this.configuredExpires);
        this.bufferSize = par.getParameterAsInteger("buffer-size", this.configuredBufferSize);
        this.byteRanges = par.getParameterAsBoolean("byte-ranges", this.configuredByteRanges);
        this.quickTest = par.getParameterAsBoolean("quick-modified-test", this.configuredQuickTest);
        try {
            this.inputSource = resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw SourceUtil.handle("Error during resolving of '" + src + "'.", se);
        }
    }

    public void recycle() {
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        super.recycle();
    }

    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.inputSource.getValidity();
    }

    public long getLastModified() {
        if (this.quickTest) {
            return this.inputSource.getLastModified();
        }
        String systemId = (String)documents.get(this.request.getRequestURI());
        if (systemId == null || this.inputSource.getURI().equals(systemId)) {
            return this.inputSource.getLastModified();
        }
        documents.remove(this.request.getRequestURI());
        return 0L;
    }

    protected void processStream() throws IOException, ProcessingException {
        ByteRange byteRange;
        byte[] buffer = new byte[this.bufferSize];
        int length = -1;
        String ranges = this.request.getHeader("Ranges");
        if (ranges != null && this.byteRanges) {
            try {
                ranges = ranges.substring(ranges.indexOf(61) + 1);
                byteRange = new ByteRange(ranges);
            }
            catch (NumberFormatException e) {
                byteRange = null;
                if (this.response instanceof HttpResponse) {
                    ((HttpResponse)this.response).setStatus(416);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("malformed byte range header [" + String.valueOf(ranges) + "]");
                    }
                }
            }
        } else {
            byteRange = null;
        }
        long contentLength = this.inputSource.getContentLength();
        if (byteRange != null) {
            String entityRange;
            String entityLength;
            if (contentLength != -1L) {
                entityLength = "" + contentLength;
                entityRange = byteRange.intersection(new ByteRange(0L, contentLength)).toString();
            } else {
                entityLength = "*";
                entityRange = byteRange.toString();
            }
            this.response.setHeader("Content-Range", entityRange + "/" + entityLength);
            if (this.response instanceof HttpResponse) {
                ((HttpResponse)this.response).setStatus(206);
            }
            this.response.setHeader("Accept-Ranges", "bytes");
            int pos = 0;
            while ((length = this.inputStream.read(buffer)) > -1) {
                int posEnd = pos + length - 1;
                ByteRange intersection = byteRange.intersection(new ByteRange(pos, posEnd));
                if (intersection != null) {
                    this.out.write(buffer, (int)intersection.getStart() - pos, (int)intersection.length());
                }
                pos += length;
            }
        } else {
            if (contentLength != -1L) {
                this.response.setHeader("Content-Length", Long.toString(contentLength));
            }
            this.response.setHeader("Accept-Ranges", "none");
            while ((length = this.inputStream.read(buffer)) > -1) {
                this.out.write(buffer, 0, length);
            }
        }
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws IOException, ProcessingException {
        try {
            block9: {
                if (this.expires > 0L) {
                    this.response.setDateHeader("Expires", System.currentTimeMillis() + this.expires);
                } else {
                    this.response.addHeader("Vary", "Host");
                }
                long lastModified = this.getLastModified();
                if (lastModified > 0L) {
                    this.response.setDateHeader("Last-Modified", lastModified);
                }
                try {
                    this.inputStream = this.inputSource.getInputStream();
                }
                catch (SourceException se) {
                    throw SourceUtil.handle("Error during resolving of the input stream", se);
                }
                try {
                    this.processStream();
                    Object var5_4 = null;
                    if (this.inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (this.inputStream == null) throw throwable;
                    this.inputStream.close();
                    throw throwable;
                }
                this.inputStream.close();
            }
            if (this.quickTest) return;
            documents.put(this.request.getRequestURI(), this.inputSource.getURI());
            return;
        }
        catch (IOException e) {
            this.getLogger().debug("Received an IOException, assuming client severed connection on purpose");
            return;
        }
    }

    public String getMimeType() {
        Context ctx = ObjectModelHelper.getContext(this.objectModel);
        if (ctx != null) {
            if (ctx.getMimeType(this.source) != null) {
                return ctx.getMimeType(this.source);
            }
            return this.inputSource.getMimeType();
        }
        return this.inputSource.getMimeType();
    }
}

