/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers;

import org.apache.cocoon.components.serializers.XMLSerializer;
import org.apache.cocoon.components.serializers.encoding.XHTMLEncoder;
import org.apache.cocoon.components.serializers.util.DocType;
import org.xml.sax.SAXException;

public class XHTMLSerializer
extends XMLSerializer {
    public static final String XHTML1_NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final DocType XHTML1_DOCTYPE_STRICT = new DocType("html", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
    public static final DocType XHTML1_DOCTYPE_TRANSITIONAL = new DocType("html", "-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
    public static final DocType XHTML1_DOCTYPE_FRAMESET = new DocType("html", "-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
    private static final XHTMLEncoder XHTML_ENCODER = new XHTMLEncoder();

    public XHTMLSerializer() {
        super(XHTML_ENCODER);
    }

    protected XHTMLSerializer(XHTMLEncoder encoder) {
        super(encoder);
    }

    public String getMimeType() {
        if (this.charset == null) {
            return "text/html";
        }
        return "text/html; charset=" + this.charset.getName();
    }

    public void body(String uri, String local, String qual) throws SAXException {
        if (this.doctype == null) {
            this.doctype = XHTML1_DOCTYPE_TRANSITIONAL;
        }
        if (this.namespaces.getUri("").length() == 0) {
            this.namespaces.push("", XHTML1_NAMESPACE);
        }
        super.body(uri, local, qual);
    }

    public void startElementImpl(String uri, String local, String qual, String[][] namespaces, String[][] attributes) throws SAXException {
        if (uri.length() == 0) {
            uri = XHTML1_NAMESPACE;
        }
        super.startElementImpl(uri, local, qual, namespaces, attributes);
    }

    public void endElementImpl(String uri, String local, String qual) throws SAXException {
        if (uri.length() == 0) {
            uri = XHTML1_NAMESPACE;
        }
        if (XHTML1_NAMESPACE.equals(uri)) {
            if (local.equalsIgnoreCase("textarea") || local.equalsIgnoreCase("script") || local.equalsIgnoreCase("style")) {
                this.closeElement(false);
            } else if (local.equalsIgnoreCase("head")) {
                String loc = "meta";
                String qua = this.namespaces.qualify(XHTML1_NAMESPACE, loc, "meta");
                String[][] nsp = new String[0][0];
                String[][] att = new String[2][4];
                att[1][0] = "";
                att[0][0] = "";
                att[0][2] = "http-equiv";
                att[0][1] = "http-equiv";
                att[1][2] = "content";
                att[1][1] = "content";
                att[0][3] = "Content-Type";
                att[1][3] = this.getMimeType();
                this.closeElement(false);
                this.startElementImpl(XHTML1_NAMESPACE, loc, qua, nsp, att);
                this.endElementImpl(XHTML1_NAMESPACE, loc, qua);
            }
        }
        super.endElementImpl(uri, local, qual);
    }
}

