/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.utils.SdxObject;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.xml.XMLPipe;

/**
 * An SDX transformation in an SDX pipeline.
 *
 * <p>
 * A transformation is a generic operation that receives and throws SAX
 * events. It can be a SAX filter, an XSLT transformation, or other complex
 * mechanism.
 * <p>
 * The only difference with a Cocoon XMLPipe is that it can be parameterized, which
 * can be useful for XSLT transformations.
 */
public interface Transformation extends XMLPipe, SdxObject {

    /**String representation of the "transformation" attribute name "src". */
    String ATTRIBUTE_SRC = "src";

    /**String representation of the "transformation" attribute name "keep". */
    String ATTRIBUTE_KEEP = "keep";

    /**String representation of the "transformation" attribute name "th". */
    String ATTRIBUTE_TH = "th";

    /**String representation of the transformation package name (including trailing separator "."). */
    String PACKAGE_QUALNAME = "fr.gouv.culture.sdx.pipeline.";
    /**String representation of the transformation class name suffix. */
    String CLASS_NAME_SUFFIX = "Transformation";


    /** Sets some parameters for this transformation. */
    public void setParameters(Parameters p);

    /** The parameters for this transformation. */
    public Parameters getParameters();

    /**Recycles the contentHandler, lexicalHandler, and xmlConsumer for the transformation*/
    public void recycle();

    /**Indicates wheter the results of this transfomation should be retained*/
    public boolean shouldKeepResult();

}
