/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.LogTargetManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.log.LogTarget;

public class DefaultLogTargetManager
extends AbstractLogEnabled
implements LogTargetManager,
LogTargetFactoryManageable,
Configurable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$excalibur$logger$DefaultLogTargetManager == null ? (class$org$apache$avalon$excalibur$logger$DefaultLogTargetManager = DefaultLogTargetManager.class$("org.apache.avalon.excalibur.logger.DefaultLogTargetManager")) : class$org$apache$avalon$excalibur$logger$DefaultLogTargetManager));
    private final Map m_targets = new HashMap();
    private LogTargetFactoryManager m_factoryManager;
    static /* synthetic */ Class class$org$apache$avalon$excalibur$logger$DefaultLogTargetManager;

    public final LogTarget getLogTarget(String id) {
        return (LogTarget)this.m_targets.get(id);
    }

    public final void setLogTargetFactoryManager(LogTargetFactoryManager logTargetFactoryManager) {
        this.m_factoryManager = logTargetFactoryManager;
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        if (null == this.m_factoryManager) {
            String message = REZ.getString("target.error.null-target-factory");
            throw new ConfigurationException(message);
        }
        Configuration[] confs = configuration.getChildren();
        int i = 0;
        while (i < confs.length) {
            String targetName = confs[i].getName();
            LogTargetFactory logTargetFactory = this.m_factoryManager.getLogTargetFactory(targetName);
            if (logTargetFactory == null) {
                String message = REZ.getString("target.error.missing", (Object)targetName);
                throw new ConfigurationException(message);
            }
            LogTarget logTarget = logTargetFactory.createTarget(confs[i]);
            String targetId = confs[i].getAttribute("id");
            if (this.getLogger().isDebugEnabled()) {
                String message = REZ.getString("target.notice.add", (Object)targetId);
                this.getLogger().debug(message);
            }
            this.m_targets.put(targetId, logTarget);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

