/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.portal.components;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.webapps.authentication.AuthenticationManager;
import org.apache.cocoon.webapps.authentication.user.RequestState;
import org.apache.cocoon.webapps.portal.components.CopletThread;
import org.apache.cocoon.webapps.portal.components.PortalManager;
import org.apache.cocoon.webapps.session.ContextManager;
import org.apache.cocoon.webapps.session.MediaManager;
import org.apache.cocoon.webapps.session.SessionManager;
import org.apache.cocoon.webapps.session.TransactionManager;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.apache.cocoon.webapps.session.xml.XMLUtil;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMUtil;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class PortalManagerImpl
extends AbstractLogEnabled
implements Disposable,
Composable,
Recomposable,
Recyclable,
Contextualizable,
Component,
PortalManager {
    private Store profileStore;
    private AuthenticationManager authenticationManager;
    private MediaManager mediaManager;
    private XPathProcessor xpathProcessor;
    private SessionManager sessionManager;
    private ContextManager contextManager;
    private TransactionManager transactionManager;
    protected ComponentManager manager;
    protected SourceResolver resolver;
    protected Context componentContext;
    protected boolean initialized = false;

    public void recycle() {
        if (this.manager != null) {
            this.manager.release((Component)this.profileStore);
            this.manager.release((Component)this.authenticationManager);
            this.manager.release((Component)this.mediaManager);
            this.manager.release((Component)this.sessionManager);
            this.manager.release((Component)this.contextManager);
            this.manager.release((Component)this.transactionManager);
            this.profileStore = null;
            this.authenticationManager = null;
            this.mediaManager = null;
            this.transactionManager = null;
            this.sessionManager = null;
            this.contextManager = null;
        }
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestState getRequestState() {
        RequestState requestState;
        AuthenticationManager authManager = null;
        try {
            authManager = (AuthenticationManager)this.manager.lookup(AuthenticationManager.ROLE);
            requestState = authManager.getState();
            Object var5_4 = null;
        }
        catch (ComponentException ce) {
            RequestState requestState2;
            try {
                requestState2 = null;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.manager.release((Component)authManager);
                throw throwable;
            }
            this.manager.release((Component)authManager);
            return requestState2;
        }
        this.manager.release((Component)authManager);
        return requestState;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this.xpathProcessor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
    }

    public void recompose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.xpathProcessor);
            this.xpathProcessor = null;
            this.manager.release((Component)this.resolver);
            this.resolver = null;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.componentContext = context;
    }

    protected Store getProfileStore() throws ProcessingException {
        if (this.profileStore == null) {
            try {
                this.profileStore = (Store)this.manager.lookup(Store.ROLE);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Error during lookup of store component.", (Throwable)ce);
            }
        }
        return this.profileStore;
    }

    protected AuthenticationManager getAuthenticationManager() throws ProcessingException {
        if (this.authenticationManager == null) {
            try {
                this.authenticationManager = (AuthenticationManager)this.manager.lookup(AuthenticationManager.ROLE);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Error during lookup of AuthenticationManager.", (Throwable)ce);
            }
        }
        return this.authenticationManager;
    }

    protected MediaManager getMediaManager() throws ProcessingException {
        if (this.mediaManager == null) {
            try {
                this.mediaManager = (MediaManager)this.manager.lookup(MediaManager.ROLE);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Error during lookup of MediaManager.", (Throwable)ce);
            }
        }
        return this.mediaManager;
    }

    protected void setup() throws ProcessingException {
        if (!this.initialized) {
            Request request = ContextHelper.getRequest((Context)this.componentContext);
            if (request.getAttribute(PortalManager.ROLE) == null) {
                request.setAttribute(PortalManager.ROLE, (Object)Boolean.TRUE);
                this.getConfiguration();
                try {
                    this.changeProfile();
                }
                catch (SAXException se) {
                    throw new ProcessingException((Exception)se);
                }
                catch (IOException ioe) {
                    throw new ProcessingException((Exception)ioe);
                }
            }
            this.initialized = true;
        }
    }

    public void configurationTest() throws ProcessingException, IOException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN configurationTest");
        }
        this.setup();
        this.getConfiguration();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END configurationTest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionContext getContext(boolean create) throws ProcessingException, IOException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN getContext create=" + create);
        }
        this.setup();
        SessionContext context = null;
        Session session = this.getSessionManager().getSession(false);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                String appName = this.getRequestState().getApplicationName();
                String attrName = "org.apache.cocoon.webapps.portal.context.SessionContext";
                if (appName != null) {
                    attrName = attrName + ':' + appName;
                }
                if ((context = this.getContextManager().getContext(attrName)) == null && create) {
                    context = this.getAuthenticationManager().createApplicationContext(attrName, null, null);
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END getContext context=" + context);
        }
        return context;
    }

    public void streamConfiguration(XMLConsumer consumer, String requestURI, String profileID, String media, String contextID) throws IOException, SAXException, ProcessingException {
        this.setup();
        Response response = ContextHelper.getResponse((Context)this.componentContext);
        XMLUtils.startElement((ContentHandler)consumer, (String)"configuration");
        StringBuffer buffer = new StringBuffer(requestURI);
        buffer.append(requestURI.indexOf(63) == -1 ? (char)'?' : '&').append("portalprofile").append('=').append(profileID);
        String uri = response.encodeURL(buffer.toString());
        XMLUtils.startElement((ContentHandler)consumer, (String)"uri");
        XMLUtils.data((ContentHandler)consumer, (String)uri);
        XMLUtils.endElement((ContentHandler)consumer, (String)"uri");
        Map config = this.getConfiguration();
        String portalURI = response.encodeURL((String)config.get("S"));
        XMLUtils.startElement((ContentHandler)consumer, (String)"portal");
        XMLUtils.data((ContentHandler)consumer, (String)portalURI);
        XMLUtils.endElement((ContentHandler)consumer, (String)"portal");
        XMLUtils.startElement((ContentHandler)consumer, (String)"profile");
        XMLUtils.data((ContentHandler)consumer, (String)profileID);
        XMLUtils.endElement((ContentHandler)consumer, (String)"profile");
        if (media != null) {
            XMLUtils.startElement((ContentHandler)consumer, (String)"media");
            XMLUtils.data((ContentHandler)consumer, (String)media);
            XMLUtils.endElement((ContentHandler)consumer, (String)"media");
        }
        if (contextID != null) {
            XMLUtils.startElement((ContentHandler)consumer, (String)"context");
            XMLUtils.data((ContentHandler)consumer, (String)contextID);
            XMLUtils.endElement((ContentHandler)consumer, (String)"context");
        }
        XMLUtils.endElement((ContentHandler)consumer, (String)"configuration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showAdminConf(XMLConsumer consumer) throws SAXException, ProcessingException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN showAdminConf consumer=" + consumer);
        }
        this.setup();
        Request request = ContextHelper.getRequest((Context)this.componentContext);
        try {
            String role;
            Document rolesDF;
            String state;
            Node coplet;
            String profileID = "global";
            String copletID = request.getParameter("portalcoplet");
            SessionContext context = this.getContext(true);
            Map configuration = this.getConfiguration();
            DocumentFragment copletsFragment = (DocumentFragment)context.getAttribute("admincoplets");
            String command = request.getParameter("portaladmin_coplets");
            if (command != null && copletsFragment != null) {
                try {
                    this.getTransactionManager().startWritingTransaction(context);
                    if (command.equals("delete") && copletID != null) {
                        Node coplet2 = DOMUtil.getSingleNode((Node)copletsFragment, (String)("coplets-profile/coplets/coplet[@id='" + copletID + "']"), (XPathProcessor)this.xpathProcessor);
                        if (coplet2 != null) {
                            coplet2.getParentNode().removeChild(coplet2);
                        }
                    } else if (command.equals("change") && copletID != null) {
                        Node coplet3 = DOMUtil.getSingleNode((Node)copletsFragment, (String)("coplets-profile/coplets/coplet[@id='" + copletID + "']"), (XPathProcessor)this.xpathProcessor);
                        if (coplet3 != null) {
                            Element sNode;
                            Element resourceNode;
                            String resource;
                            String value = request.getParameter("portaladmin_title");
                            if (value != null) {
                                DOMUtil.setValueOfNode((Node)DOMUtil.getSingleNode((Node)coplet3, (String)"title", (XPathProcessor)this.xpathProcessor), (String)value);
                            }
                            if ((value = request.getParameter("portaladmin_mand")) != null) {
                                DOMUtil.setValueOfNode((Node)DOMUtil.getSingleNode((Node)coplet3, (String)"configuration/mandatory", (XPathProcessor)this.xpathProcessor), (String)value);
                            }
                            if ((value = request.getParameter("portaladmin_sizable")) != null) {
                                DOMUtil.setValueOfNode((Node)DOMUtil.getSingleNode((Node)coplet3, (String)"configuration/sizable", (XPathProcessor)this.xpathProcessor), (String)value);
                            }
                            if ((value = request.getParameter("portaladmin_active")) != null) {
                                DOMUtil.setValueOfNode((Node)DOMUtil.getSingleNode((Node)coplet3, (String)"configuration/active", (XPathProcessor)this.xpathProcessor), (String)value);
                            }
                            if ((value = request.getParameter("portaladmin_handsize")) != null) {
                                DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet3, (String)"configuration/handlesSizable", (XPathProcessor)this.xpathProcessor), (String)value);
                            }
                            if ((value = request.getParameter("portaladmin_handpar")) != null) {
                                DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet3, (String)"configuration/handlesParameters", (XPathProcessor)this.xpathProcessor), (String)value);
                            }
                            if ((value = request.getParameter("portaladmin_timeout")) != null) {
                                DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet3, (String)"configuration/timeout", (XPathProcessor)this.xpathProcessor), (String)value);
                            }
                            if ((value = request.getParameter("portaladmin_customizable")) != null) {
                                DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet3, (String)"configuration/customizable", (XPathProcessor)this.xpathProcessor), (String)value);
                            }
                            if ((value = request.getParameter("portaladmin_persistent")) != null) {
                                DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet3, (String)"configuration/persistent", (XPathProcessor)this.xpathProcessor), (String)value);
                            }
                            if ((resource = request.getParameter("portaladmin_resource")) != null) {
                                Element resourceNode2 = (Element)DOMUtil.getSingleNode((Node)coplet3, (String)"resource", (XPathProcessor)this.xpathProcessor);
                                resourceNode2.getParentNode().removeChild(resourceNode2);
                                resourceNode2 = coplet3.getOwnerDocument().createElementNS(null, "resource");
                                resourceNode2.setAttributeNS(null, "uri", resource);
                                coplet3.appendChild(resourceNode2);
                            }
                            resource = request.getParameter("portaladmin_cust");
                            boolean isCustom = DOMUtil.getValueAsBooleanOf((Node)coplet3, (String)"configuration/customizable", (boolean)false, (XPathProcessor)this.xpathProcessor);
                            if (resource != null && isCustom) {
                                resourceNode = (Element)DOMUtil.getSingleNode((Node)coplet3, (String)"customization", (XPathProcessor)this.xpathProcessor);
                                if (resourceNode != null) {
                                    resourceNode.getParentNode().removeChild(resourceNode);
                                }
                                resourceNode = coplet3.getOwnerDocument().createElementNS(null, "customization");
                                resourceNode.setAttributeNS(null, "uri", resource);
                                coplet3.appendChild(resourceNode);
                            }
                            if (!isCustom && (resourceNode = (Element)DOMUtil.getSingleNode((Node)coplet3, (String)"customization", (XPathProcessor)this.xpathProcessor)) != null) {
                                resourceNode.getParentNode().removeChild(resourceNode);
                            }
                            if ((value = request.getParameter("portaladmin_newxsl")) != null) {
                                Element tNode = (Element)DOMUtil.selectSingleNode((Node)coplet3, (String)"transformation", (XPathProcessor)this.xpathProcessor);
                                sNode = tNode.getOwnerDocument().createElementNS(null, "stylesheet");
                                tNode.appendChild(sNode);
                                sNode.appendChild(sNode.getOwnerDocument().createTextNode(value));
                            }
                            Enumeration keys = request.getParameterNames();
                            while (keys.hasMoreElements()) {
                                String key = (String)keys.nextElement();
                                if (key.startsWith("portaladmin_xsl_")) {
                                    value = key.substring(key.lastIndexOf(95) + 1);
                                    sNode = (Element)DOMUtil.getSingleNode((Node)coplet3, (String)("transformation/stylesheet[position()=" + value + "]"), (XPathProcessor)this.xpathProcessor);
                                    if (sNode == null) continue;
                                    String xslName = request.getParameter(key);
                                    if (xslName.equals("true")) {
                                        xslName = "**STYLESHEET**";
                                    }
                                    DOMUtil.setValueOfNode((Node)sNode, (String)xslName);
                                    continue;
                                }
                                if (!key.startsWith("portaladmin_delxsl_")) continue;
                                value = key.substring(key.lastIndexOf(95) + 1);
                                sNode = (Element)DOMUtil.getSingleNode((Node)coplet3, (String)("transformation/stylesheet[position()=" + value + "]"), (XPathProcessor)this.xpathProcessor);
                                if (sNode == null) continue;
                                sNode.setAttributeNS(null, "delete", "true");
                            }
                            NodeList delete = DOMUtil.selectNodeList((Node)coplet3, (String)"transformation/stylesheet[@delete]", (XPathProcessor)this.xpathProcessor);
                            if (delete != null) {
                                int i = 0;
                                while (i < delete.getLength()) {
                                    delete.item(i).getParentNode().removeChild(delete.item(i));
                                    ++i;
                                }
                            }
                        }
                    } else if (command.equals("new")) {
                        int index = 0;
                        boolean found = false;
                        while (!found) {
                            copletID = "S" + index;
                            coplet = (Element)DOMUtil.getSingleNode((Node)copletsFragment, (String)("coplets-profile/coplets/coplet[@id='" + copletID + "']"), (XPathProcessor)this.xpathProcessor);
                            if (coplet == null) {
                                found = true;
                                continue;
                            }
                            ++index;
                        }
                        coplet = copletsFragment.getOwnerDocument().createElementNS(null, "coplet");
                        coplet.setAttributeNS(null, "id", copletID);
                        Element subNode = coplet.getOwnerDocument().createElementNS(null, "resource");
                        coplet.appendChild(subNode);
                        subNode.setAttributeNS(null, "uri", "uri_in_sitemap");
                        String title = request.getParameter("portaladmin_title");
                        if (title == null || title.trim().length() == 0) {
                            title = "**NEW COPLET**";
                        }
                        DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet, (String)"configuration/mandatory", (XPathProcessor)this.xpathProcessor), (String)"false");
                        DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet, (String)"configuration/sizable", (XPathProcessor)this.xpathProcessor), (String)"true");
                        DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet, (String)"configuration/active", (XPathProcessor)this.xpathProcessor), (String)"false");
                        DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet, (String)"configuration/handlesParameters", (XPathProcessor)this.xpathProcessor), (String)"true");
                        DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet, (String)"configuration/handlesSizable", (XPathProcessor)this.xpathProcessor), (String)"false");
                        DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet, (String)"title", (XPathProcessor)this.xpathProcessor), (String)title);
                        DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet, (String)"status/visible", (XPathProcessor)this.xpathProcessor), (String)"true");
                        DOMUtil.setValueOfNode((Node)DOMUtil.selectSingleNode((Node)coplet, (String)"status/size", (XPathProcessor)this.xpathProcessor), (String)"max");
                        DOMUtil.getSingleNode((Node)copletsFragment, (String)"coplets-profile/coplets", (XPathProcessor)this.xpathProcessor).appendChild(coplet);
                    } else if (command.equals("save")) {
                        SourceParameters pars = new SourceParameters();
                        pars.setSingleParameterValue("profile", "coplet-base");
                        RequestState state2 = this.getRequestState();
                        pars.setSingleParameterValue("application", state2.getApplicationName());
                        pars.setSingleParameterValue("handler", state2.getHandlerName());
                        String saveResource = (String)configuration.get("E");
                        if (saveResource == null) {
                            throw new ProcessingException("portal: No save resource defined for type coplet-base.");
                        }
                        SourceUtil.writeDOM((String)saveResource, null, (SourceParameters)pars, (DocumentFragment)copletsFragment, (SourceResolver)this.resolver, (String)"xml");
                        this.cleanUpCache(null, null, configuration);
                    }
                    Object var19_33 = null;
                }
                catch (Throwable throwable) {
                    Object var19_34 = null;
                    this.getTransactionManager().stopWritingTransaction(context);
                    throw throwable;
                }
                this.getTransactionManager().stopWritingTransaction(context);
                {
                }
            }
            if (command != null && command.equals("cleancache")) {
                this.cleanUpCache(null, null, configuration);
            }
            if ((state = request.getParameter("portaladmin")) == null) {
                state = (String)context.getAttribute("adminstate", (Object)"main");
            }
            AttributesImpl attr = new AttributesImpl();
            consumer.startElement("", "portaladminconf", "portaladminconf", (Attributes)attr);
            context.setAttribute("adminstate", (Object)state);
            consumer.startElement("", "state", "state", (Attributes)attr);
            consumer.characters(state.toCharArray(), 0, state.length());
            consumer.endElement("", "state", "state");
            if (state.equals("main")) {
                rolesDF = this.getRoles();
                Node roles = null;
                if (rolesDF != null) {
                    roles = DOMUtil.getSingleNode((Node)rolesDF, (String)"roles", (XPathProcessor)this.xpathProcessor);
                }
                IncludeXMLConsumer.includeNode(roles, (ContentHandler)consumer, (LexicalHandler)consumer);
            }
            if (state.equals("mainrole")) {
                rolesDF = this.getRoles();
                Node roles = null;
                if (rolesDF != null) {
                    roles = DOMUtil.getSingleNode((Node)rolesDF, (String)"roles", (XPathProcessor)this.xpathProcessor);
                }
                IncludeXMLConsumer.includeNode(roles, (ContentHandler)consumer, (LexicalHandler)consumer);
                String role2 = request.getParameter("portalrole");
                if (role2 == null) {
                    role2 = (String)context.getAttribute("adminrole");
                }
                context.setAttribute("adminrole", (Object)role2);
                if (role2 != null) {
                    XMLUtils.startElement((ContentHandler)consumer, (String)"roleusers");
                    XMLUtils.startElement((ContentHandler)consumer, (String)"name");
                    XMLUtils.data((ContentHandler)consumer, (String)role2);
                    XMLUtils.endElement((ContentHandler)consumer, (String)"name");
                    Document userDF = this.getUsers(role2, null);
                    Node users = null;
                    if (userDF != null) {
                        users = DOMUtil.getSingleNode((Node)userDF, (String)"users", (XPathProcessor)this.xpathProcessor);
                    }
                    IncludeXMLConsumer.includeNode(users, (ContentHandler)consumer, (LexicalHandler)consumer);
                    XMLUtils.endElement((ContentHandler)consumer, (String)"roleusers");
                }
            }
            if (state.equals("global")) {
                profileID = this.getProfileID("global", null, null, true);
                Map profile = this.retrieveProfile(profileID);
                if (profile == null) {
                    this.createProfile(context, "global", null, null, true);
                    profile = this.retrieveProfile(profileID);
                }
                this.showPortal(consumer, true, context, profile, profileID);
            }
            if (state.equals("role")) {
                role = request.getParameter("portalrole");
                if (role == null) {
                    role = (String)context.getAttribute("adminrole");
                }
                context.setAttribute("adminrole", (Object)role);
                if (role != null) {
                    consumer.startElement("", "role", "role", (Attributes)attr);
                    consumer.characters(role.toCharArray(), 0, role.length());
                    consumer.endElement("", "role", "role");
                    profileID = this.getProfileID("role", role, null, true);
                    Map profile = this.retrieveProfile(profileID);
                    if (profile == null) {
                        this.createProfile(context, "role", role, null, true);
                        profile = this.retrieveProfile(profileID);
                    }
                    this.showPortal(consumer, true, context, profile, profileID);
                }
            }
            if (state.equals("user")) {
                role = request.getParameter("portalrole");
                String id = request.getParameter("portalid");
                if (role == null) {
                    role = (String)context.getAttribute("adminrole");
                }
                if (id == null) {
                    id = (String)context.getAttribute("adminid");
                }
                context.setAttribute("adminid", (Object)id);
                context.setAttribute("adminrole", (Object)role);
                if (role != null && id != null) {
                    consumer.startElement("", "role", "role", (Attributes)attr);
                    consumer.characters(role.toCharArray(), 0, role.length());
                    consumer.endElement("", "role", "role");
                    consumer.startElement("", "id", "id", (Attributes)attr);
                    consumer.characters(id.toCharArray(), 0, id.length());
                    consumer.endElement("", "id", "id");
                    profileID = this.getProfileID("user", role, id, true);
                    Map profile = this.retrieveProfile(profileID);
                    if (profile == null) {
                        this.createProfile(context, "user", role, id, true);
                        profile = this.retrieveProfile(profileID);
                    }
                    this.showPortal(consumer, true, context, profile, profileID);
                }
            }
            if (state.equals("coplet")) {
                if (copletsFragment != null && copletID != null) {
                    coplet = DOMUtil.getSingleNode((Node)copletsFragment, (String)("coplets-profile/coplets/coplet[@id='" + copletID + "']"), (XPathProcessor)this.xpathProcessor);
                    if (coplet != null) {
                        IncludeXMLConsumer.includeNode((Node)coplet, (ContentHandler)consumer, (LexicalHandler)consumer);
                    }
                } else {
                    state = "coplets";
                }
            }
            if (state.equals("coplets")) {
                consumer.startElement("", "coplets", "coplets", (Attributes)attr);
                if (copletsFragment == null) {
                    SourceParameters pars = new SourceParameters();
                    RequestState reqstate = this.getRequestState();
                    pars.setSingleParameterValue("application", reqstate.getApplicationName());
                    String res = (String)configuration.get("D");
                    if (res == null) {
                        throw new ProcessingException("No configuration for portal-coplet base profile found.");
                    }
                    copletsFragment = SourceUtil.readDOM((String)res, null, (SourceParameters)pars, (SourceResolver)this.resolver);
                    context.setAttribute("admincoplets", (Object)copletsFragment);
                }
                IncludeXMLConsumer.includeNode((Node)DOMUtil.selectSingleNode((Node)copletsFragment, (String)"coplets-profile", (XPathProcessor)this.xpathProcessor), (ContentHandler)consumer, (LexicalHandler)consumer);
                consumer.endElement("", "coplets", "coplets");
            }
            this.streamConfiguration(consumer, request.getRequestURI(), profileID, null, null);
            consumer.endElement("", "portaladminconf", "portaladminconf");
        }
        catch (TransformerException local) {
            throw new ProcessingException("TransformerException: " + local, (Throwable)local);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END showAdminConf");
        }
    }

    public Element getStatusProfile() throws SAXException, IOException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN getStatusProfile");
        }
        this.setup();
        SessionContext context = this.getContext(true);
        String profileID = null;
        Map storedProfile = null;
        Element statusProfile = null;
        if (context.getAttribute("role") != null) {
            profileID = this.getProfileID("user", (String)context.getAttribute("role"), (String)context.getAttribute("ID"), false);
            storedProfile = this.retrieveProfile(profileID);
        }
        if (storedProfile != null) {
            DocumentFragment profile = (DocumentFragment)storedProfile.get("profile");
            try {
                statusProfile = (Element)DOMUtil.getSingleNode((Node)profile, (String)"profile/status-profile", (XPathProcessor)this.xpathProcessor);
            }
            catch (TransformerException ignore) {
                // empty catch block
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END getStatusProfile statusProfile=" + (statusProfile == null ? "null" : XMLUtils.serializeNode((Node)statusProfile, (Properties)XMLUtils.createPropertiesForXML((boolean)false))));
        }
        return statusProfile;
    }

    public void showPortal(XMLConsumer consumer, boolean configMode, boolean adminProfile) throws SAXException, ProcessingException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN showPortal consumer=" + consumer + ", configMode=" + configMode + ", adminProfile=" + adminProfile);
        }
        this.setup();
        SessionContext context = this.getContext(true);
        String profileID = null;
        Map storedProfile = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("start portal generation");
        }
        if (context.getAttribute("role") != null) {
            profileID = this.getProfileID("user", (String)context.getAttribute("role"), (String)context.getAttribute("ID"), adminProfile);
            storedProfile = this.retrieveProfile(profileID);
        }
        if (storedProfile == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("start building profile");
            }
            this.createProfile(context, "user", null, null, adminProfile);
            profileID = this.getProfileID("user", (String)context.getAttribute("role"), (String)context.getAttribute("ID"), adminProfile);
            storedProfile = this.retrieveProfile(profileID);
            if (storedProfile == null) {
                throw new ProcessingException("portal: No portal profile found.");
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("end building profile");
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("start showing profile");
        }
        this.showPortal(consumer, configMode, context, storedProfile, profileID);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("end showing profile");
            this.getLogger().debug("end portal generation");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END showPortal");
        }
    }

    public static void streamLayoutProfile(XMLConsumer consumer, Map portalLayouts, Map copletLayouts, String mediaType) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        consumer.startElement("", "layout", "layout", (Attributes)attr);
        consumer.startElement("", "portal", "portal", (Attributes)attr);
        Element element = (Element)portalLayouts.get(mediaType);
        NodeList childs = element.getChildNodes();
        int ci = 0;
        while (ci < childs.getLength()) {
            IncludeXMLConsumer.includeNode((Node)childs.item(ci), (ContentHandler)consumer, (LexicalHandler)consumer);
            ++ci;
        }
        consumer.endElement("", "portal", "portal");
        consumer.startElement("", "coplets", "coplets", (Attributes)attr);
        element = (Element)copletLayouts.get(mediaType);
        childs = element.getChildNodes();
        int ci2 = 0;
        while (ci2 < childs.getLength()) {
            IncludeXMLConsumer.includeNode((Node)childs.item(ci2), (ContentHandler)consumer, (LexicalHandler)consumer);
            ++ci2;
        }
        consumer.endElement("", "coplets", "coplets");
        consumer.endElement("", "layout", "layout");
    }

    private void showPortal(XMLConsumer consumer, boolean configMode, SessionContext context, Map storedProfile, String profileID) throws SAXException, ProcessingException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN showPortal consumer=" + consumer + ", configMode=" + configMode + ", context=" + context + ", profile=" + storedProfile);
        }
        Request request = ContextHelper.getRequest((Context)this.componentContext);
        try {
            block46: {
                try {
                    Long longValue;
                    this.getTransactionManager().startReadingTransaction(context);
                    String mediaType = this.getMediaManager().getMediaType();
                    DocumentFragment profile = (DocumentFragment)storedProfile.get("profile");
                    Map portalLayouts = (Map)storedProfile.get("portalLayouts");
                    Map copleyLayouts = (Map)storedProfile.get("copletLayouts");
                    Node[] miscNodes = (Node[])storedProfile.get("misc");
                    Map defaultCoplets = (Map)storedProfile.get("defCoplets");
                    Map mediaCoplets = (Map)storedProfile.get("mediaCoplets");
                    if (profile == null || defaultCoplets == null || mediaCoplets == null || portalLayouts == null || copleyLayouts == null || miscNodes == null) {
                        throw new ProcessingException("portal: No portal profile found.");
                    }
                    Map config = this.getConfiguration();
                    if (config == null) {
                        throw new ProcessingException("No configuration for portal found.");
                    }
                    boolean processCopletsParallel = false;
                    long defaultCopletTimeout = 600000L;
                    Boolean boolValue = (Boolean)config.get("U");
                    if (boolValue != null) {
                        processCopletsParallel = boolValue;
                    }
                    if ((longValue = (Long)config.get("V")) != null) {
                        defaultCopletTimeout = longValue;
                    }
                    AttributesImpl attr = new AttributesImpl();
                    if (configMode) {
                        XMLUtils.startElement((ContentHandler)consumer, (String)"portalconf");
                    } else {
                        XMLUtils.startElement((ContentHandler)consumer, (String)"portal");
                    }
                    this.streamConfiguration(consumer, request.getRequestURI(), profileID, mediaType, null);
                    if (configMode) {
                        IncludeXMLConsumer.includeNode((Node)DOMUtil.getFirstNodeFromPath((Node)profile, (String[])new String[]{"profile", "layout-profile"}, (boolean)false), (ContentHandler)consumer, (LexicalHandler)consumer);
                        IncludeXMLConsumer.includeNode((Node)DOMUtil.getFirstNodeFromPath((Node)profile, (String[])new String[]{"profile", "coplets-profile"}, (boolean)false), (ContentHandler)consumer, (LexicalHandler)consumer);
                        IncludeXMLConsumer.includeNode((Node)DOMUtil.getFirstNodeFromPath((Node)profile, (String[])new String[]{"profile", "type-profile", "typedefs"}, (boolean)false), (ContentHandler)consumer, (LexicalHandler)consumer);
                        IncludeXMLConsumer.includeNode((Node)DOMUtil.getFirstNodeFromPath((Node)profile, (String[])new String[]{"profile", "portal-profile"}, (boolean)false), (ContentHandler)consumer, (LexicalHandler)consumer);
                        IncludeXMLConsumer.includeNode((Node)DOMUtil.getFirstNodeFromPath((Node)profile, (String[])new String[]{"profile", "personal-profile"}, (boolean)false), (ContentHandler)consumer, (LexicalHandler)consumer);
                        IncludeXMLConsumer.includeNode((Node)DOMUtil.getFirstNodeFromPath((Node)profile, (String[])new String[]{"profile", "status-profile"}, (boolean)false), (ContentHandler)consumer, (LexicalHandler)consumer);
                    } else {
                        PortalManagerImpl.streamLayoutProfile(consumer, portalLayouts, copleyLayouts, mediaType);
                    }
                    if (!configMode) {
                        Element element;
                        List[] copletContents;
                        List[] temp;
                        Element statusProfile = (Element)DOMUtil.getFirstNodeFromPath((Node)profile, (String[])new String[]{"profile", "status-profile"}, (boolean)false);
                        String copletNotAvailableMessage = "The coplet is currently not available.";
                        Node messages = miscNodes[6];
                        if (messages != null && (messages = DOMUtil.getFirstNodeFromPath((Node)messages, (String[])new String[]{"coplet_not_available"}, (boolean)false)) != null) {
                            copletNotAvailableMessage = DOMUtil.getValueOfNode((Node)messages, (String)copletNotAvailableMessage);
                        }
                        if ((temp = (List[])context.getAttribute("portalRep")) != null) {
                            copletContents = new List[temp.length];
                            int i = 0;
                            while (i < temp.length) {
                                copletContents[i] = temp[i] == null ? null : new ArrayList(temp[i]);
                                ++i;
                            }
                        } else {
                            copletContents = new List[7];
                            context.setAttribute("portalRep", (Object)copletContents);
                        }
                        if (copletContents[0] == null) {
                            copletContents[0] = new ArrayList(1);
                        } else {
                            copletContents[0].clear();
                        }
                        if (copletContents[1] == null) {
                            copletContents[1] = new ArrayList(1);
                        } else {
                            copletContents[1].clear();
                        }
                        String value = DOMUtil.getValueOfNode((Node)miscNodes[0]);
                        if (value != null && new Boolean(value).booleanValue() && (element = (Element)miscNodes[2]) != null) {
                            this.loadCoplets(element, defaultCoplets, mediaCoplets, copletContents[0], processCopletsParallel, defaultCopletTimeout, statusProfile);
                        }
                        if ((value = DOMUtil.getValueOfNode((Node)miscNodes[4])) != null && new Integer(value) > 0) {
                            int columns = new Integer(value);
                            if (columns > 5) {
                                throw new ProcessingException("portal: Maximum number of columns supported is: 5");
                            }
                            int colindex = 1;
                            while (colindex <= columns) {
                                if (copletContents[colindex + 1] == null) {
                                    copletContents[colindex + 1] = new ArrayList(10);
                                } else {
                                    copletContents[colindex + 1].clear();
                                }
                                Element columnElement = (Element)miscNodes[7 + colindex];
                                element = (Element)DOMUtil.getFirstNodeFromPath((Node)columnElement, (String[])new String[]{"coplets"}, (boolean)false);
                                if (element != null) {
                                    this.loadCoplets(element, defaultCoplets, mediaCoplets, copletContents[colindex + 1], processCopletsParallel, defaultCopletTimeout, statusProfile);
                                }
                                ++colindex;
                            }
                            int colindex2 = columns + 2;
                            while (colindex2 <= 6) {
                                if (copletContents[colindex2] != null) {
                                    copletContents[colindex2] = null;
                                }
                                ++colindex2;
                            }
                        } else {
                            int colindex = 1;
                            while (colindex <= 5) {
                                if (copletContents[colindex + 1] != null) {
                                    copletContents[colindex + 1] = null;
                                }
                                ++colindex;
                            }
                        }
                        value = DOMUtil.getValueOfNode((Node)miscNodes[1]);
                        if (value != null && new Boolean(value).booleanValue() && (element = (Element)miscNodes[3]) != null) {
                            this.loadCoplets(element, defaultCoplets, mediaCoplets, copletContents[1], processCopletsParallel, defaultCopletTimeout, statusProfile);
                        }
                        if (copletContents[0].size() > 0) {
                            consumer.startElement("", "header", "header", (Attributes)attr);
                            this.processCopletList(copletContents[0], consumer, copletNotAvailableMessage, defaultCopletTimeout);
                            consumer.endElement("", "header", "header");
                        }
                        if ((value = DOMUtil.getValueOfNode((Node)miscNodes[4])) != null && new Integer(value) > 0) {
                            attr.addAttribute("", "number", "number", "CDATA", value);
                            XMLUtils.startElement((ContentHandler)consumer, (String)"columns", (Attributes)attr);
                            attr.clear();
                            int columns = new Integer(value);
                            if (columns > 5) {
                                throw new ProcessingException("portal: Maximum number of columns supported is: 5");
                            }
                            String[] width = new String[columns];
                            int normalWidth = 100 / columns;
                            int colindex = 1;
                            while (colindex <= columns) {
                                Element columnElement = (Element)miscNodes[7 + colindex];
                                value = DOMUtil.getValueOf((Node)columnElement, (String)"width", (XPathProcessor)this.xpathProcessor);
                                width[colindex - 1] = value == null ? "" + normalWidth + "%" : value;
                                ++colindex;
                            }
                            int colindex3 = 1;
                            while (colindex3 <= columns) {
                                attr.addAttribute("", "position", "position", "CDATA", "" + colindex3);
                                attr.addAttribute("", "width", "width", "CDATA", width[colindex3 - 1]);
                                XMLUtils.startElement((ContentHandler)consumer, (String)"column", (Attributes)attr);
                                attr.clear();
                                this.processCopletList(copletContents[colindex3 + 1], consumer, copletNotAvailableMessage, defaultCopletTimeout);
                                XMLUtils.endElement((ContentHandler)consumer, (String)"column");
                                ++colindex3;
                            }
                            XMLUtils.endElement((ContentHandler)consumer, (String)"columns");
                        } else {
                            attr.addAttribute("", "number", "number", "CDATA", "0");
                            XMLUtils.startElement((ContentHandler)consumer, (String)"columns", (Attributes)attr);
                            XMLUtils.endElement((ContentHandler)consumer, (String)"columns");
                            attr.clear();
                        }
                        if (copletContents[1].size() > 0) {
                            XMLUtils.startElement((ContentHandler)consumer, (String)"footer");
                            this.processCopletList(copletContents[1], consumer, copletNotAvailableMessage, defaultCopletTimeout);
                            XMLUtils.endElement((ContentHandler)consumer, (String)"footer");
                        }
                        int i = 0;
                        while (i < copletContents.length) {
                            if (copletContents[i] != null) {
                                copletContents[i].clear();
                            }
                            ++i;
                        }
                        this.sendEvents(consumer, DOMUtil.getFirstNodeFromPath((Node)profile, (String[])new String[]{"profile", "personal-profile"}, (boolean)false));
                        this.sendEvents(consumer, statusProfile);
                    }
                    if (configMode) {
                        XMLUtils.endElement((ContentHandler)consumer, (String)"portalconf");
                        break block46;
                    }
                    XMLUtils.endElement((ContentHandler)consumer, (String)"portal");
                }
                catch (TransformerException local) {
                    throw new ProcessingException("TransformerException: " + local, (Throwable)local);
                }
            }
            Object var35_40 = null;
        }
        catch (Throwable throwable) {
            Object var35_41 = null;
            this.getTransactionManager().stopReadingTransaction(context);
            throw throwable;
        }
        this.getTransactionManager().stopReadingTransaction(context);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END showPortal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildProfile(String type, String role, String id, boolean adminProfile) throws ProcessingException, IOException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN buildProfile type=" + type + ", role=" + role + ", id=" + id + ", adminProfile=" + adminProfile);
        }
        try {
            if (type == null) {
                throw new ProcessingException("buildProfile: Type is required");
            }
            if (!type.equals("global") && !type.equals("basic")) {
                if (type.equals("role")) {
                    if (role == null) {
                        throw new ProcessingException("buildProfile: Role is required");
                    }
                } else if (type.equals("user")) {
                    if (role == null) {
                        throw new ProcessingException("buildProfile: Role is required");
                    }
                    if (id == null) {
                        throw new ProcessingException("buildProfile: ID is required");
                    }
                } else {
                    throw new ProcessingException("buildProfile: Type unknown: " + type);
                }
            }
            SessionContext context = this.getContext(true);
            try {
                this.getTransactionManager().startWritingTransaction(context);
                String profileID = this.getProfileID(type, role, id, adminProfile);
                Map<String, Map> theProfile = null;
                Map config = this.getConfiguration();
                if (config == null) {
                    throw new ProcessingException("No configuration for portal found.");
                }
                if (type.equals("user")) {
                    theProfile = this.getCachedProfile(profileID, config);
                }
                if (theProfile == null) {
                    Element profileRoot;
                    DocumentFragment profile;
                    boolean doBase = false;
                    boolean doGlobal = false;
                    boolean doRole = false;
                    boolean doID = false;
                    if (type.equals("user")) {
                        doID = true;
                        String previousID = this.getProfileID("role", role, null, adminProfile);
                        theProfile = this.getCachedProfile(previousID, config);
                        if (theProfile == null) {
                            doRole = true;
                            previousID = this.getProfileID("global", null, null, adminProfile);
                            theProfile = this.getCachedProfile(previousID, config);
                            if (theProfile == null) {
                                doGlobal = true;
                                previousID = this.getProfileID("basic", null, null, adminProfile);
                                theProfile = this.getCachedProfile(previousID, config);
                            }
                        }
                    } else if (type.equals("role")) {
                        theProfile = this.getCachedProfile(profileID, config);
                        if (theProfile == null) {
                            doRole = true;
                            String previousID = this.getProfileID("global", null, null, adminProfile);
                            theProfile = this.getCachedProfile(previousID, config);
                            if (theProfile == null) {
                                doGlobal = true;
                                previousID = this.getProfileID("basic", null, null, adminProfile);
                                theProfile = this.getCachedProfile(previousID, config);
                            }
                        }
                    } else if (type.equals("global")) {
                        theProfile = this.getCachedProfile(profileID, config);
                        if (theProfile == null) {
                            doGlobal = true;
                            String previousID = this.getProfileID("basic", null, null, adminProfile);
                            theProfile = this.getCachedProfile(previousID, config);
                        }
                    } else {
                        theProfile = this.getCachedProfile(profileID, config);
                    }
                    if (theProfile == null) {
                        theProfile = new HashMap(8, 2.0f);
                        doBase = true;
                    }
                    if (doBase) {
                        profile = this.buildBaseProfile(config, adminProfile);
                        profileRoot = (Element)profile.getFirstChild();
                        theProfile.put("profile", (Map)((Object)profile));
                        this.cacheProfile(this.getProfileID("basic", null, null, adminProfile), theProfile, config);
                    } else {
                        profile = (DocumentFragment)theProfile.get("profile");
                        profileRoot = (Element)profile.getFirstChild();
                    }
                    if (doGlobal) {
                        this.buildGlobalProfile(profileRoot, config, adminProfile);
                        this.cacheProfile(this.getProfileID("global", null, null, adminProfile), theProfile, config);
                    }
                    if (doRole) {
                        this.buildRoleProfile(profileRoot, config, role, adminProfile);
                        this.cacheProfile(this.getProfileID("role", role, null, adminProfile), theProfile, config);
                    }
                    if (doID) {
                        this.buildUserProfile(profileRoot, config, role, id, adminProfile);
                    }
                    if (type.equals("user")) {
                        this.buildUserStatusProfile(profileRoot, config, role, id);
                    }
                    if (!type.equals("basic")) {
                        this.buildRunProfile(theProfile, context, profile);
                        theProfile.put("portalLayouts", this.buildPortalLayouts(context, profile));
                        theProfile.put("copletLayouts", this.buildcopleyLayouts(context, profile));
                        this.buildTypeProfile(theProfile, context, profile);
                    }
                    if (doID) {
                        this.cacheProfile(profileID, theProfile, config);
                    }
                } else if (type.equals("user")) {
                    DocumentFragment profile = (DocumentFragment)theProfile.get("profile");
                    Element profileRoot = (Element)profile.getFirstChild();
                    this.buildUserStatusProfile(profileRoot, config, role, id);
                }
                this.storeProfile(profileID, theProfile);
                if (type.equals("user") && !adminProfile) {
                    context.setAttribute("role", (Object)role);
                    context.setAttribute("ID", (Object)id);
                }
                Object var17_21 = null;
            }
            catch (Throwable throwable) {
                Object var17_22 = null;
                this.getTransactionManager().stopWritingTransaction(context);
                throw throwable;
            }
            this.getTransactionManager().stopWritingTransaction(context);
            {
            }
        }
        catch (TransformerException local) {
            throw new ProcessingException("TransformerException: " + local, (Throwable)local);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END buildProfile");
        }
    }

    private DocumentFragment buildProfileDelta(String type, String role, String id, boolean adminProfile) throws SAXException, ProcessingException, IOException, TransformerException {
        NodeList typeElements;
        NodeList coplets;
        int value;
        String lastNumber;
        String rootElementName;
        String baseID;
        String baseRole;
        String baseType;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END buildProfileDeltaN type=" + type + ", role=" + role + ", id=" + id);
        }
        SessionContext context = this.getContext(true);
        Map originalProfile = this.retrieveProfile(this.getProfileID(type, role, id, adminProfile));
        if (originalProfile == null) {
            throw new ProcessingException("buildProfileDelta: no profile found for " + type + " - " + role + " - " + id + ".");
        }
        if (type.equals("user")) {
            baseType = "role";
            baseRole = role;
            baseID = null;
            rootElementName = "user-delta";
        } else if (type.equals("role")) {
            baseType = "global";
            baseRole = null;
            baseID = null;
            rootElementName = "role-delta";
        } else if (type.equals("global")) {
            baseType = "basic";
            baseRole = null;
            baseID = null;
            rootElementName = "global-delta";
        } else {
            throw new ProcessingException("buildProfileDelta: type '" + type + "' not allowed.");
        }
        this.createProfile(context, baseType, baseRole, baseID, adminProfile);
        Map baseProfile = this.retrieveProfile(this.getProfileID(baseType, baseRole, baseID, adminProfile));
        if (baseProfile == null) {
            throw new ProcessingException("buildProfileDelta: no baseProfile found.");
        }
        DocumentFragment originalFragment = (DocumentFragment)originalProfile.get("profile");
        DocumentFragment delta = originalFragment.getOwnerDocument().createDocumentFragment();
        delta.appendChild(delta.getOwnerDocument().createElementNS(null, rootElementName));
        Node profileDelta = DOMUtil.getFirstNodeFromPath((Node)originalFragment, (String[])new String[]{"profile", "portal-profile"}, (boolean)false).cloneNode(true);
        delta.getFirstChild().appendChild(profileDelta);
        this.diff(originalFragment, (DocumentFragment)baseProfile.get("profile"), "profile/layout-profile", (Element)delta.getFirstChild());
        this.diff(originalFragment, (DocumentFragment)baseProfile.get("profile"), "profile/coplets-profile", (Element)delta.getFirstChild());
        if (type.equals("global")) {
            profileDelta = DOMUtil.getFirstNodeFromPath((Node)originalFragment, (String[])new String[]{"profile", "personal-profile"}, (boolean)false).cloneNode(true);
            delta.getFirstChild().appendChild(profileDelta);
        } else {
            this.diff(originalFragment, (DocumentFragment)baseProfile.get("profile"), "profile/personal-profile", (Element)delta.getFirstChild());
        }
        Node[] miscNodes = (Node[])originalProfile.get("misc");
        Element lastCoplet = (Element)miscNodes[5];
        if (lastCoplet != null && (lastNumber = lastCoplet.getAttributeNS(null, "number")) != null && (value = new Integer(lastNumber).intValue()) > 1000000 && (coplets = DOMUtil.selectNodeList((Node)delta, (String)"profile/portal-profile/descendant::coplet[@id and @number]", (XPathProcessor)this.xpathProcessor)) != null) {
            boolean copletsChanged = false;
            int i = 0;
            while (i < coplets.getLength()) {
                Element copletNode = (Element)coplets.item(i);
                String oldNumber = copletNode.getAttributeNS(null, "number");
                String copletId = copletNode.getAttributeNS(null, "id");
                Element statusNode = (Element)DOMUtil.getSingleNode((Node)delta, (String)("status-profile/customization/coplet[@id='" + copletId + "' and @number='" + oldNumber + "']"), (XPathProcessor)this.xpathProcessor);
                copletNode.setAttributeNS(null, "number", "" + (i + 1));
                if (statusNode != null) {
                    statusNode.setAttributeNS(null, "number", "" + (i + 1));
                    copletsChanged = true;
                }
                ++i;
            }
            if (copletsChanged) {
                this.saveUserStatusProfile(originalProfile, this.getConfiguration(), role, id);
            }
        }
        if ((typeElements = DOMUtil.selectNodeList((Node)delta, (String)"descendant::*[@formpath and @formdescription and @formtype]", (XPathProcessor)this.xpathProcessor)) != null) {
            int i = 0;
            while (i < typeElements.getLength()) {
                ((Element)typeElements.item(i)).removeAttributeNS(null, "formpath");
                ((Element)typeElements.item(i)).removeAttributeNS(null, "formdescription");
                ((Element)typeElements.item(i)).removeAttributeNS(null, "formtype");
                ++i;
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END buildProfileDelta delta=" + delta);
        }
        return delta;
    }

    private void diff(DocumentFragment original, DocumentFragment base, String path, Element deltaElement) throws SAXException, TransformerException {
        Element originalRoot = (Element)DOMUtil.getSingleNode((Node)original, (String)path, (XPathProcessor)this.xpathProcessor);
        Element baseRoot = (Element)DOMUtil.getSingleNode((Node)base, (String)path, (XPathProcessor)this.xpathProcessor);
        if (originalRoot != null && baseRoot != null) {
            ArrayList<Element> nodeStack = new ArrayList<Element>();
            String name = baseRoot.getNodeName();
            name = name.substring(0, name.indexOf("-profile")) + "-delta";
            nodeStack.add(originalRoot.getOwnerDocument().createElementNS(null, name));
            this.diffNode(baseRoot, originalRoot, nodeStack, deltaElement);
        }
    }

    private void diffNode(Element baseNode, Element originalNode, List nodeStack, Element deltaElement) throws SAXException, TransformerException {
        Node currentOrigNode = null;
        Node currentBaseNode = null;
        NodeList originalChilds = originalNode.getChildNodes();
        int len = originalChilds.getLength();
        NodeList baseChilds = baseNode.getChildNodes();
        int l = baseChilds.getLength();
        int i = 0;
        while (i < len) {
            currentOrigNode = originalChilds.item(i);
            if (currentOrigNode.getNodeType() == 1) {
                int m = 0;
                boolean found = false;
                while (!found && m < l) {
                    currentBaseNode = baseChilds.item(m);
                    if (currentBaseNode.getNodeType() == 1 && currentBaseNode.getNodeName().equals(currentOrigNode.getNodeName())) {
                        found = this.compareAttributes(currentBaseNode, currentOrigNode);
                    }
                    if (found) continue;
                    ++m;
                }
                if (found) {
                    currentOrigNode.normalize();
                    if (currentOrigNode.hasChildNodes()) {
                        nodeStack.add(currentOrigNode);
                        this.diffNode((Element)currentBaseNode, (Element)currentOrigNode, nodeStack, deltaElement);
                        String baseString = DOMUtil.getValueOfNode((Node)currentBaseNode, (String)"").trim();
                        String originalString = DOMUtil.getValueOfNode((Node)currentOrigNode, (String)"").trim();
                        if (!baseString.equals(originalString)) {
                            Element contextElement = deltaElement;
                            int p = 0;
                            while (p < nodeStack.size()) {
                                Element currentElement = (Element)nodeStack.get(p);
                                NodeList possibleChilds = DOMUtil.getNodeListFromPath((Node)contextElement, (String[])new String[]{currentElement.getNodeName()});
                                boolean foundChild = false;
                                int cIndex = 0;
                                if (possibleChilds != null) {
                                    while (!foundChild && cIndex < possibleChilds.getLength()) {
                                        foundChild = this.compareAttributes(currentElement, possibleChilds.item(cIndex));
                                        if (foundChild) continue;
                                        ++cIndex;
                                    }
                                }
                                if (foundChild) {
                                    contextElement = (Element)possibleChilds.item(cIndex);
                                } else {
                                    currentElement = (Element)currentElement.cloneNode(false);
                                    contextElement.appendChild(currentElement);
                                    contextElement = currentElement;
                                }
                                ++p;
                            }
                            contextElement.appendChild(contextElement.getOwnerDocument().createTextNode(originalString));
                        }
                        nodeStack.remove(nodeStack.size() - 1);
                    }
                }
            }
            ++i;
        }
    }

    public String getProfileID(String type, String role, String id, boolean adminProfile) throws ProcessingException {
        this.setup();
        StringBuffer key = new StringBuffer(adminProfile ? "aprofile:" : "uprofile:");
        RequestState reqstate = this.getRequestState();
        key.append(reqstate.getHandlerName()).append('|').append(reqstate.getApplicationName()).append(':').append(type);
        if (type.equals("role") || type.equals("user")) {
            role = XMLUtil.encode((String)role);
            key.append('_').append(role.length()).append('_').append(role);
        }
        if (type.equals("user")) {
            id = XMLUtil.encode((String)id);
            key.append('_').append(id);
        }
        return key.toString();
    }

    private boolean getIsAdminProfile(String profileID) {
        return profileID.startsWith("a");
    }

    private String getRole(String profileID) {
        int pos = (profileID = XMLUtil.decode((String)profileID)).indexOf(95);
        if (pos == -1) {
            return null;
        }
        String lastPart = profileID.substring(pos + 1);
        if ((pos = lastPart.indexOf(95)) == -1) {
            return null;
        }
        int len = new Integer(lastPart.substring(0, pos));
        lastPart = lastPart.substring(pos + 1, pos + 1 + len);
        return lastPart;
    }

    private String getID(String profileID) {
        int pos = (profileID = XMLUtil.decode((String)profileID)).indexOf(95);
        if (pos == -1) {
            return null;
        }
        String lastPart = profileID.substring(pos + 1);
        if ((pos = lastPart.indexOf(95)) == -1) {
            return null;
        }
        if ((pos = (lastPart = lastPart.substring(pos + 1)).indexOf(95)) == -1) {
            return null;
        }
        return lastPart.substring(pos + 1);
    }

    private String getType(String profileID) {
        int endPos = (profileID = XMLUtil.decode((String)profileID)).indexOf(95);
        if (endPos == -1) {
            int startPos = profileID.lastIndexOf(58);
            return profileID.substring(startPos + 1);
        }
        int startPos = profileID.lastIndexOf(58, endPos);
        return profileID.substring(startPos + 1, endPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeProfile(String profileID, Map profile) throws ProcessingException {
        Session session;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN storeProfile id=" + profileID + ", profile=" + profile);
        }
        Session session2 = session = this.getSessionManager().getSession(true);
        synchronized (session2) {
            session.setAttribute(profileID, (Object)profile);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END storeProfile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map retrieveProfile(String profileID) throws ProcessingException {
        Map result;
        Session session;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN retrieveProfile id=" + profileID);
        }
        this.setup();
        Session session2 = session = this.getSessionManager().getSession(true);
        synchronized (session2) {
            result = (Map)session.getAttribute(profileID);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END retrieveProfile profile=" + (result != null ? "**PROFILE**" : "null"));
        }
        return result;
    }

    private void cacheProfile(String profileID, Map profile, Map configuration) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN cacheProfile id=" + profileID + ", profile=" + profile);
        }
        try {
            String storePrefix;
            if (configuration != null && !this.getIsAdminProfile(profileID) && (storePrefix = (String)configuration.get("T")) != null) {
                String key = profileID.substring(1);
                this.getProfileStore().store((Object)key, (Object)profile);
            }
        }
        catch (Exception local) {
            this.getLogger().warn("Caching Profile failed.", (Throwable)local);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END cacheProfile");
        }
    }

    private Map getCachedProfile(String profileID, Map configuration) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN getCachedProfile id=" + profileID);
        }
        Map result = null;
        try {
            String storePrefix;
            if (configuration != null && !this.getIsAdminProfile(profileID) && (storePrefix = (String)configuration.get("T")) != null) {
                String key = profileID.substring(1);
                Store store = this.getProfileStore();
                if (store.containsKey((Object)key)) {
                    result = (Map)store.get((Object)key);
                }
            }
        }
        catch (Exception local) {
            this.getLogger().warn("Getting cached Profile failed.", (Throwable)local);
            result = null;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END getCachedProfile profile=" + (result != null ? "**PROFILE**" : "null"));
        }
        return result;
    }

    private void cleanUpCache(String type, String role, Map configuration) throws ProcessingException {
        String storePrefix;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN cleanUpCache type=" + type + ", role=" + role + ", config=" + configuration);
        }
        if (configuration != null && type != null && !type.equals("user")) {
            String storePrefix2 = (String)configuration.get("T");
            if (storePrefix2 != null) {
                Store store = this.getProfileStore();
                Enumeration keys = store.keys();
                String deleteGlobal = null;
                String deleteRole = null;
                String deleteUser = null;
                if (type.equals("basic") || type.equals("global")) {
                    if (type.equals("basic")) {
                        deleteGlobal = this.getProfileID("global", null, null, false).substring(1);
                    }
                    deleteRole = this.getProfileID("global", null, null, false);
                    deleteRole = deleteRole.substring(1, deleteRole.lastIndexOf(58) + 1) + "role";
                    deleteUser = this.getProfileID("global", null, null, false);
                    deleteUser = deleteUser.substring(1, deleteUser.lastIndexOf(58) + 1) + "user";
                } else {
                    deleteGlobal = this.getProfileID("role", role, null, false).substring(1);
                    deleteUser = this.getProfileID("user", role, "a", false);
                    deleteUser = deleteUser.substring(1, deleteUser.length() - 1);
                }
                while (keys.hasMoreElements()) {
                    Object k = keys.nextElement();
                    if (!(k instanceof String)) continue;
                    String currentKey = (String)k;
                    if (deleteGlobal != null && currentKey.equals(deleteGlobal)) {
                        store.remove((Object)currentKey);
                        continue;
                    }
                    if (deleteRole != null && currentKey.startsWith(deleteRole)) {
                        store.remove((Object)currentKey);
                        continue;
                    }
                    if (deleteUser == null || !currentKey.startsWith(deleteUser)) continue;
                    store.remove((Object)currentKey);
                }
            }
        } else if (configuration != null && type == null && (storePrefix = (String)configuration.get("T")) != null) {
            Store store = this.getProfileStore();
            Enumeration keys = store.keys();
            String delete = this.getProfileID("global", null, null, false);
            delete = delete.substring(1, delete.lastIndexOf(58) + 1);
            while (keys.hasMoreElements()) {
                String currentKey;
                Object k = keys.nextElement();
                if (!(k instanceof String) || !(currentKey = (String)k).startsWith(delete)) continue;
                store.remove((Object)currentKey);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END cleanUpCache");
        }
    }

    private void buildRunProfile(Map profileMap, SessionContext context, DocumentFragment baseProfile) throws ProcessingException, TransformerException {
        NodeList copletElements;
        Element configElement;
        int i;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN buildRunProfile context=" + context + ", profile=" + baseProfile);
        }
        HashMap<String, Element> defaultCoplets = new HashMap<String, Element>(20, 5.0f);
        HashMap mediaCoplets = new HashMap(5, 2.0f);
        profileMap.put("defCoplets", defaultCoplets);
        profileMap.put("mediaCoplets", mediaCoplets);
        String[] types = this.getMediaManager().getMediaTypes();
        int i2 = 0;
        while (i2 < types.length) {
            mediaCoplets.put(types[i2], new HashMap(5, 3.0f));
            ++i2;
        }
        Node[] miscNodes = new Node[13];
        miscNodes[0] = DOMUtil.getFirstNodeFromPath((Node)baseProfile, (String[])new String[]{"profile", "layout-profile", "portal", "header", "exists"}, (boolean)false);
        miscNodes[1] = DOMUtil.getFirstNodeFromPath((Node)baseProfile, (String[])new String[]{"profile", "layout-profile", "portal", "footer", "exists"}, (boolean)false);
        miscNodes[2] = DOMUtil.getFirstNodeFromPath((Node)baseProfile, (String[])new String[]{"profile", "portal-profile", "content", "header"}, (boolean)false);
        miscNodes[3] = DOMUtil.getFirstNodeFromPath((Node)baseProfile, (String[])new String[]{"profile", "portal-profile", "content", "footer"}, (boolean)false);
        miscNodes[4] = DOMUtil.getFirstNodeFromPath((Node)baseProfile, (String[])new String[]{"profile", "layout-profile", "portal", "columns", "number"}, (boolean)false);
        miscNodes[6] = DOMUtil.getFirstNodeFromPath((Node)baseProfile, (String[])new String[]{"profile", "personal-profile", "messages"}, (boolean)false);
        int i3 = 1;
        while (i3 <= 5) {
            miscNodes[7 + i3] = DOMUtil.getSingleNode((Node)baseProfile, (String)("profile/portal-profile/content/column[@position='" + i3 + "']"), (XPathProcessor)this.xpathProcessor);
            ++i3;
        }
        profileMap.put("misc", miscNodes);
        NodeList coplets = DOMUtil.getNodeListFromPath((Node)baseProfile, (String[])new String[]{"profile", "coplets-profile", "coplets", "coplet"});
        if (coplets != null) {
            int l = coplets.getLength();
            i = 0;
            while (i < l) {
                configElement = (Element)coplets.item(i);
                if (DOMUtil.getValueAsBooleanOf((Node)configElement, (String)"configuration/active", (XPathProcessor)this.xpathProcessor)) {
                    String copletMedia;
                    String copletID = configElement.getAttributeNS(null, "id");
                    if (configElement.hasAttributeNS(null, "media")) {
                        copletMedia = configElement.getAttributeNS(null, "media");
                        Map mediaMap = (Map)mediaCoplets.get(copletMedia);
                        if (mediaMap != null) {
                            mediaMap.put(copletID, configElement);
                        }
                    } else {
                        copletMedia = null;
                        defaultCoplets.put(copletID, configElement);
                    }
                    if (DOMUtil.getValueAsBooleanOf((Node)configElement, (String)"configuration/mandatory", (XPathProcessor)this.xpathProcessor)) {
                        copletElements = copletMedia == null ? DOMUtil.selectNodeList((Node)baseProfile, (String)("profile/portal-profile/content/column/coplets/coplet[@id='" + copletID + "' and not(@media)]"), (XPathProcessor)this.xpathProcessor) : DOMUtil.selectNodeList((Node)baseProfile, (String)("profile/portal-profile/content/column/coplets/coplet[@id='" + copletID + "' and media='" + copletMedia + "']"), (XPathProcessor)this.xpathProcessor);
                        if (copletElements == null || copletElements.getLength() == 0) {
                            copletElements = copletMedia == null ? DOMUtil.selectNodeList((Node)baseProfile, (String)("profile/portal-profile/content/header/coplet[@id='" + copletID + "' and not(@media)]"), (XPathProcessor)this.xpathProcessor) : DOMUtil.selectNodeList((Node)baseProfile, (String)("profile/portal-profile/content/header/coplet[@id='" + copletID + "' and media='" + copletMedia + "']"), (XPathProcessor)this.xpathProcessor);
                        }
                        if (copletElements == null || copletElements.getLength() == 0) {
                            copletElements = copletMedia == null ? DOMUtil.selectNodeList((Node)baseProfile, (String)("profile/portal-profile/content/footer/coplet[@id='" + copletID + "' and not(@media)]"), (XPathProcessor)this.xpathProcessor) : DOMUtil.selectNodeList((Node)baseProfile, (String)("profile/portal-profile/content/footer/coplet[@id='" + copletID + "' and media='" + copletMedia + "']"), (XPathProcessor)this.xpathProcessor);
                        }
                        if (copletElements == null || copletElements.getLength() == 0) {
                            NodeList childs;
                            Node content = DOMUtil.getSingleNode((Node)baseProfile, (String)"profile/portal-profile/content/column[@position='1']/coplets", (XPathProcessor)this.xpathProcessor);
                            if (content == null) {
                                throw new ProcessingException("Element not found: portal-profile/content/column/coplets");
                            }
                            Element el = content.getOwnerDocument().createElementNS(null, "coplet");
                            el.setAttributeNS(null, "id", copletID);
                            if (copletMedia != null) {
                                el.setAttributeNS(null, "media", copletMedia);
                            }
                            int childsCount = (childs = DOMUtil.getNodeListFromPath((Node)content, (String[])new String[]{"coplet"})) == null ? 0 : childs.getLength();
                            el.setAttributeNS(null, "position", "" + (childsCount + 1));
                            content.appendChild(el);
                            content = el;
                            el = content.getOwnerDocument().createElementNS(null, "status");
                            content.appendChild(el);
                            content = el;
                            el = content.getOwnerDocument().createElementNS(null, "visible");
                            content.appendChild(el);
                            content = el;
                            Text t = content.getOwnerDocument().createTextNode("true");
                            content.appendChild(t);
                        } else {
                            boolean origVisible = DOMUtil.getValueAsBooleanOf((Node)configElement, (String)"status/visible", (XPathProcessor)this.xpathProcessor);
                            int sl = copletElements.getLength();
                            int si = 0;
                            boolean found = false;
                            while (si < sl && !found) {
                                found = DOMUtil.getValueAsBooleanOf((Node)copletElements.item(si), (String)"status/visible", (boolean)origVisible, (XPathProcessor)this.xpathProcessor);
                                ++si;
                            }
                            if (!found) {
                                Node visibleElem;
                                Node statusElem = DOMUtil.getFirstNodeFromPath((Node)copletElements.item(0), (String[])new String[]{"status"}, (boolean)false);
                                if (statusElem == null) {
                                    statusElem = copletElements.item(0).getOwnerDocument().createElementNS(null, "status");
                                    copletElements.item(0).appendChild(statusElem);
                                }
                                if ((visibleElem = DOMUtil.getFirstNodeFromPath((Node)statusElem, (String[])new String[]{"visible"}, (boolean)false)) == null) {
                                    visibleElem = statusElem.getOwnerDocument().createElementNS(null, "visible");
                                    statusElem.appendChild(visibleElem);
                                }
                                while (visibleElem.hasChildNodes()) {
                                    visibleElem.removeChild(visibleElem.getFirstChild());
                                }
                                visibleElem.appendChild(statusElem.getOwnerDocument().createTextNode("true"));
                            }
                        }
                    }
                }
                ++i;
            }
        }
        int number = 0;
        Element content = (Element)DOMUtil.getFirstNodeFromPath((Node)baseProfile, (String[])new String[]{"profile", "portal-profile", "content"}, (boolean)false);
        int highestCopletNumber = -1;
        i = 0;
        while (i < 7) {
            copletElements = i == 0 ? DOMUtil.getNodeListFromPath((Node)content, (String[])new String[]{"header", "coplet"}) : (i == 1 ? DOMUtil.getNodeListFromPath((Node)content, (String[])new String[]{"footer", "coplet"}) : DOMUtil.selectNodeList((Node)content, (String)("column[@position='" + (i - 1) + "']/coplets/coplet"), (XPathProcessor)this.xpathProcessor));
            if (copletElements != null && copletElements.getLength() > 0) {
                Element[] list = new Element[copletElements.getLength()];
                int index = 0;
                while (index < copletElements.getLength()) {
                    list[index] = (Element)copletElements.item(index);
                    ++index;
                }
                int index2 = 0;
                while (index2 < list.length) {
                    Element currentCoplet = list[index2];
                    String numberValue = currentCoplet.getAttributeNS(null, "number");
                    if (numberValue == null || numberValue.equals("")) {
                        currentCoplet.setAttributeNS(null, "number", "" + number);
                        miscNodes[5] = currentCoplet;
                        ++number;
                    } else {
                        int currentNumber = new Integer(numberValue);
                        if (currentNumber > highestCopletNumber) {
                            highestCopletNumber = currentNumber;
                            number = highestCopletNumber + 1;
                            miscNodes[5] = currentCoplet;
                        }
                    }
                    configElement = this.getCopletConfiguration(currentCoplet.getAttributeNS(null, "id"), defaultCoplets, mediaCoplets);
                    if (configElement != null) {
                        Node currentStatus;
                        int list_index;
                        int list_length;
                        Element statusCopletElement = (Element)DOMUtil.selectSingleNode((Node)configElement, (String)"status", (XPathProcessor)this.xpathProcessor);
                        NodeList statusConfigList = DOMUtil.selectNodeList((Node)statusCopletElement, (String)"*", (XPathProcessor)this.xpathProcessor);
                        NodeList statusCopletList = DOMUtil.selectNodeList((Node)currentCoplet, (String)"status/*", (XPathProcessor)this.xpathProcessor);
                        if (statusCopletList != null) {
                            list_length = statusCopletList.getLength();
                            list_index = list_length - 1;
                            while (list_index >= 0) {
                                currentStatus = statusCopletList.item(list_index);
                                if (currentStatus.getNodeType() == 1 && DOMUtil.getFirstNodeFromPath((Node)configElement, (String[])new String[]{"status", currentStatus.getNodeName()}, (boolean)false) == null) {
                                    currentStatus.getParentNode().removeChild(currentStatus);
                                }
                                --list_index;
                            }
                        }
                        if (statusConfigList != null) {
                            list_length = statusConfigList.getLength();
                            list_index = 0;
                            while (list_index < list_length) {
                                currentStatus = statusConfigList.item(list_index);
                                if (currentStatus.getNodeType() == 1 && DOMUtil.getFirstNodeFromPath((Node)statusCopletElement, (String[])new String[]{currentStatus.getNodeName()}, (boolean)false) == null) {
                                    statusCopletElement.appendChild(statusCopletElement.getOwnerDocument().importNode(currentStatus, true));
                                }
                                ++list_index;
                            }
                        }
                    } else {
                        String posAttr = currentCoplet.getAttributeNS(null, "position");
                        NodeList followUps = DOMUtil.selectNodeList((Node)currentCoplet.getParentNode(), (String)("coplet[@position > '" + posAttr + "']"), (XPathProcessor)this.xpathProcessor);
                        if (followUps != null) {
                            int iq = 0;
                            while (iq < followUps.getLength()) {
                                int value = new Integer(((Element)followUps.item(iq)).getAttributeNS(null, "position"));
                                ((Element)followUps.item(iq)).setAttributeNS(null, "position", "" + --value);
                                ++iq;
                            }
                        }
                        currentCoplet.getParentNode().removeChild(currentCoplet);
                    }
                    ++index2;
                }
            }
            ++i;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END buildRunProfile");
        }
    }

    private void buildTypeProfile(Map theProfile, SessionContext context, DocumentFragment baseProfile) throws TransformerException {
        NodeList columnNodes;
        int columns;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN buildTypeProfile context=" + context + ", profile=" + baseProfile);
        }
        ArrayList list = new ArrayList(25);
        ArrayList<String> confList = new ArrayList<String>(25);
        theProfile.put("typePaths", list);
        theProfile.put("typeConfPaths", confList);
        Element typeElement = (Element)DOMUtil.getFirstNodeFromPath((Node)baseProfile, (String[])new String[]{"profile", "type-profile", "elements"}, (boolean)false);
        if (typeElement != null) {
            if (typeElement.hasChildNodes()) {
                this.addTypePath(list, typeElement.getChildNodes(), "profile");
            }
            this.setTypeInfo(baseProfile, list, null);
            int l = list.size();
            int i = 0;
            while (i < l) {
                String current = (String)list.get(i);
                int pos = current.lastIndexOf(47);
                current = (current = current.substring(0, pos)).substring((pos = current.lastIndexOf(91)) + 1).equals("not(@*)]") ? current.substring(0, pos + 1) : current.substring(0, current.length() - 1) + " and ";
                current = current + "@formtype and @formpath and @formdescription]";
                confList.add(current);
                ++i;
            }
        }
        Element layoutColumnsNode = (Element)DOMUtil.getFirstNodeFromPath((Node)baseProfile, (String[])new String[]{"profile", "layout-profile", "portal", "columns", "number"}, (boolean)false);
        String layoutValue = DOMUtil.getValueOfNode((Node)layoutColumnsNode);
        int layoutColumns = 0;
        if (layoutValue != null && new Integer(layoutValue) > 0) {
            layoutColumns = new Integer(layoutValue);
        }
        if ((columns = (columnNodes = DOMUtil.selectNodeList((Node)baseProfile, (String)"profile/portal-profile/content/column[@position]", (XPathProcessor)this.xpathProcessor)).getLength()) != layoutColumns) {
            if (layoutColumnsNode.hasAttributeNS(null, "formtype")) {
                DOMUtil.setValueOfNode((Node)layoutColumnsNode, (String)("" + columns));
            } else {
                this.changeColumns(baseProfile, columns, layoutColumns, (Node[])theProfile.get("misc"));
                this.setTypeInfo(baseProfile, (List)theProfile.get("typePaths"), (List)theProfile.get("typeConfPaths"));
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END buildTypeProfile");
        }
    }

    private void setTypeInfo(DocumentFragment baseProfile, List paths, List confPaths) throws TransformerException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN setTypeInfo profile=" + baseProfile + ", paths=" + paths);
        }
        if (baseProfile != null && paths != null) {
            int path_count = paths.size();
            int i = 0;
            while (i < path_count) {
                Node currentNode;
                int m;
                int nodes_count;
                String description;
                String currentPath = (String)paths.get(i);
                int pos = currentPath.lastIndexOf(47);
                String value = currentPath.substring(pos + 1);
                currentPath = currentPath.substring(0, pos);
                pos = value.indexOf("|");
                if (pos != -1) {
                    description = value.substring(pos + 1);
                    value = value.substring(0, pos);
                } else {
                    description = "UNKNOWN";
                }
                boolean changed = false;
                NodeList nodes = DOMUtil.selectNodeList((Node)baseProfile, (String)currentPath, (XPathProcessor)this.xpathProcessor);
                if (nodes != null) {
                    nodes_count = nodes.getLength();
                    m = 0;
                    while (m < nodes_count) {
                        currentNode = nodes.item(m);
                        if (currentNode.getNodeType() == 1) {
                            ((Element)currentNode).setAttributeNS(null, "formtype", value);
                            ((Element)currentNode).setAttributeNS(null, "formpath", "portalconf." + i + '.' + m);
                            ((Element)currentNode).setAttributeNS(null, "formdescription", description);
                            changed = true;
                        }
                        ++m;
                    }
                }
                if (changed && confPaths != null && (nodes = DOMUtil.selectNodeList((Node)baseProfile, (String)(currentPath = (String)confPaths.get(i)), (XPathProcessor)this.xpathProcessor)) != null) {
                    nodes_count = nodes.getLength();
                    m = 0;
                    while (m < nodes_count) {
                        currentNode = nodes.item(m);
                        if (currentNode.getNodeType() == 1) {
                            ((Element)currentNode).setAttributeNS(null, "formpath", "portalconf." + i + '.' + m);
                        }
                        ++m;
                    }
                }
                ++i;
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END setTypeInfo");
        }
    }

    private void addTypePath(List list, NodeList childs, String path) {
        int l = childs.getLength();
        int i = 0;
        while (i < l) {
            if (childs.item(i).getNodeType() == 1) {
                Element current = (Element)childs.item(i);
                StringBuffer newPath = new StringBuffer(path);
                newPath.append('/').append(current.getNodeName());
                if (current.hasAttributes()) {
                    NamedNodeMap nnm = current.getAttributes();
                    boolean first = true;
                    StringBuffer expression = new StringBuffer();
                    int la = nnm.getLength();
                    newPath.append('[');
                    int ia = 0;
                    while (ia < la) {
                        if (!nnm.item(ia).getNodeName().equals("type") && !nnm.item(ia).getNodeName().equals("description")) {
                            if (!first) {
                                expression.append(" and ");
                            }
                            if (!nnm.item(ia).getNodeValue().equals("*")) {
                                expression.append('@').append(nnm.item(ia).getNodeName()).append("='").append(nnm.item(ia).getNodeValue()).append("'");
                            } else {
                                expression.append('@').append(nnm.item(ia).getNodeName());
                            }
                            first = false;
                        }
                        ++ia;
                    }
                    if (first) {
                        newPath.append("not(@*)");
                    } else {
                        newPath.append(expression);
                    }
                    newPath.append(']');
                } else {
                    newPath.append("[not(@*)]");
                }
                if (current.getAttributeNS(null, "type").length() > 0) {
                    list.add(newPath.toString() + '/' + current.getAttributeNS(null, "type") + '|' + current.getAttributeNS(null, "description"));
                } else if (current.hasChildNodes()) {
                    this.addTypePath(list, current.getChildNodes(), newPath.toString());
                }
            }
            ++i;
        }
    }

    private Map buildPortalLayouts(SessionContext context, DocumentFragment baseProfile) throws ProcessingException, TransformerException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN buildPortalLayouts context=" + context + ", profile=" + baseProfile);
        }
        HashMap<String, Element> layouts = new HashMap<String, Element>(5, 2.0f);
        Element defLayout = (Element)DOMUtil.getSingleNode((Node)baseProfile, (String)"profile/layout-profile/portal/layouts/layout[not(@*)]", (XPathProcessor)this.xpathProcessor);
        String[] types = this.getMediaManager().getMediaTypes();
        int i = 0;
        while (i < types.length) {
            Node currentLayout = DOMUtil.getSingleNode((Node)baseProfile, (String)("profile/layout-profile/portal/layouts/layout[media='" + types[i] + "']"), (XPathProcessor)this.xpathProcessor);
            layouts.put(types[i], (Element)(currentLayout == null ? defLayout : currentLayout));
            ++i;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END buildPortalLayouts layouts=" + layouts);
        }
        return layouts;
    }

    private Map buildcopleyLayouts(SessionContext context, DocumentFragment baseProfile) throws ProcessingException, TransformerException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN buildcopleyLayouts context=" + context + ", profile=" + baseProfile);
        }
        HashMap<String, Element> layouts = new HashMap<String, Element>(5, 2.0f);
        Element defLayout = (Element)DOMUtil.getSingleNode((Node)baseProfile, (String)"profile/layout-profile/coplets/layouts/layout[not(@*)]", (XPathProcessor)this.xpathProcessor);
        String[] types = this.getMediaManager().getMediaTypes();
        int i = 0;
        while (i < types.length) {
            Node currentLayout = DOMUtil.getSingleNode((Node)baseProfile, (String)("profile/layout-profile/coplets/layouts/layout[media='" + types[i] + "']"), (XPathProcessor)this.xpathProcessor);
            layouts.put(types[i], (Element)(currentLayout == null ? defLayout : currentLayout));
            ++i;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END buildcopleyLayouts layouts=" + layouts);
        }
        return layouts;
    }

    private void importProfileDelta(Element profileRoot, DocumentFragment delta, String deltaRootTagName, String deltaTag) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN importProfileDelta root=" + profileRoot + ", delta=" + delta + ", deltaRoot:" + deltaRootTagName + ", delta: " + deltaTag);
        }
        Node deltaRoot = null;
        deltaRoot = DOMUtil.getFirstNodeFromPath((Node)delta, (String[])new String[]{deltaRootTagName, deltaTag}, (boolean)false);
        if (deltaRoot != null) {
            String searchName = deltaRoot.getNodeName().substring(0, deltaRoot.getNodeName().lastIndexOf("-delta"));
            searchName = searchName + "-profile";
            if ((profileRoot = (Element)DOMUtil.getFirstNodeFromPath((Node)profileRoot, (String[])new String[]{searchName}, (boolean)false)) == null) {
                throw new ProcessingException("Importing Delta: Tag " + searchName + " not found in profile.");
            }
            this.importNode(profileRoot, (Element)deltaRoot);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END importProfileDelta");
        }
    }

    private void addProfilePart(Element profileRoot, DocumentFragment delta, String deltaRootTagName, String deltaTag) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN addProfilePart root=" + profileRoot + ", delta=" + delta + ", deltaRoot:" + deltaRootTagName + ", delta: " + deltaTag);
        }
        Node deltaRoot = null;
        Node oldNode = null;
        deltaRoot = deltaRootTagName != null ? DOMUtil.getFirstNodeFromPath((Node)delta, (String[])new String[]{deltaRootTagName, deltaTag}, (boolean)false) : DOMUtil.getFirstNodeFromPath((Node)delta, (String[])new String[]{deltaTag}, (boolean)false);
        if (deltaRoot != null) {
            oldNode = DOMUtil.getFirstNodeFromPath((Node)profileRoot, (String[])new String[]{deltaTag}, (boolean)false);
            if (oldNode == null) {
                profileRoot.appendChild(profileRoot.getOwnerDocument().importNode(deltaRoot, true));
            } else {
                profileRoot.replaceChild(profileRoot.getOwnerDocument().importNode(deltaRoot, true), oldNode);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END addProfilePart");
        }
    }

    private void importNode(Element profile, Element delta) {
        NodeList profileChilds = null;
        NodeList deltaChilds = delta.getChildNodes();
        Node currentDelta = null;
        Node currentProfile = null;
        int len = deltaChilds.getLength();
        int i = 0;
        while (i < len) {
            currentDelta = deltaChilds.item(i);
            if (currentDelta.getNodeType() == 1) {
                profileChilds = profile.getChildNodes();
                int l = profileChilds.getLength();
                int m = 0;
                boolean found = false;
                while (!found && m < l) {
                    currentProfile = profileChilds.item(m);
                    if (currentProfile.getNodeType() == 1 && currentProfile.getNodeName().equals(currentDelta.getNodeName())) {
                        found = this.compareAttributes(currentProfile, currentDelta);
                    }
                    if (found) continue;
                    ++m;
                }
                if (found && currentDelta.hasChildNodes()) {
                    currentDelta.normalize();
                    currentProfile.normalize();
                    this.importNode((Element)currentProfile, (Element)currentDelta);
                    NodeList childs = currentProfile.getChildNodes();
                    int max = childs.getLength();
                    int index = max - 1;
                    while (index >= 0) {
                        if (childs.item(index).getNodeType() == 3) {
                            currentProfile.removeChild(childs.item(index));
                        }
                        --index;
                    }
                    childs = currentDelta.getChildNodes();
                    max = childs.getLength();
                    index = 0;
                    while (index < max) {
                        if (childs.item(index).getNodeType() == 3) {
                            currentProfile.appendChild(currentProfile.getOwnerDocument().createTextNode(childs.item(index).getNodeValue()));
                        }
                        ++index;
                    }
                }
            }
            ++i;
        }
    }

    private boolean compareAttributes(Node first, Node second) {
        int i;
        int l;
        int attr2Len;
        NamedNodeMap attr1 = first.getAttributes();
        NamedNodeMap attr2 = second.getAttributes();
        if (attr1 == null && attr2 == null) {
            return true;
        }
        if (attr1 == null || attr2 == null) {
            return false;
        }
        int attr1Len = attr1 == null ? 0 : attr1.getLength();
        int n = attr2Len = attr2 == null ? 0 : attr2.getLength();
        if (attr1Len > 0) {
            if (attr1.getNamedItemNS(null, "formtype") != null) {
                --attr1Len;
            }
            if (attr1.getNamedItemNS(null, "formpath") != null) {
                --attr1Len;
            }
            if (attr1.getNamedItemNS(null, "formdescription") != null) {
                --attr1Len;
            }
            l = attr1.getLength();
            i = 0;
            while (i < l) {
                if (attr1.item(i).getNodeName().startsWith("xmlns:")) {
                    --attr1Len;
                }
                ++i;
            }
        }
        if (attr2Len > 0) {
            if (attr2.getNamedItemNS(null, "formtype") != null) {
                --attr2Len;
            }
            if (attr2.getNamedItemNS(null, "formpath") != null) {
                --attr2Len;
            }
            if (attr2.getNamedItemNS(null, "formdescription") != null) {
                --attr2Len;
            }
            l = attr2.getLength();
            i = 0;
            while (i < l) {
                if (attr2.item(i).getNodeName().startsWith("xmlns:")) {
                    --attr2Len;
                }
                ++i;
            }
        }
        if (attr1Len != attr2Len) {
            return false;
        }
        int i2 = 0;
        int l2 = attr1.getLength();
        int l22 = attr2.getLength();
        boolean ok = true;
        while (i2 < l2 && ok) {
            String value = attr1.item(i2).getNodeName();
            if (!(value.equals("formtype") || value.equals("formpath") || value.equals("formdescription") || value.startsWith("xmlns:"))) {
                ok = false;
                int m = 0;
                while (m < l22 && !ok) {
                    if (attr2.item(m).getNodeName().equals(value)) {
                        ok = attr1.item(i2).getNodeValue().equals(attr2.item(m).getNodeValue());
                    }
                    ++m;
                }
            }
            ++i2;
        }
        return ok;
    }

    private void processCopletList(List copletList, XMLConsumer consumer, String copletNotAvailableMessage, long defaultCopletTimeout) throws ProcessingException, SAXException, TransformerException {
        int i = 0;
        while (i < copletList.size()) {
            this.processCoplet((Object[])copletList.get(i), consumer, copletNotAvailableMessage, defaultCopletTimeout);
            ++i;
        }
    }

    private void loadCoplets(Element element, Map defaultCoplets, Map mediaCoplets, List copletList, boolean parallelCoplets, long defaultCopletTimeout, Element statusProfile) throws ProcessingException, TransformerException {
        if (element.hasChildNodes()) {
            NodeList childs = element.getChildNodes();
            Node current = null;
            int l = childs.getLength();
            int i = 0;
            while (i < l) {
                current = childs.item(i);
                if (current.getNodeType() == 1 && current.getNodeName().equals("coplet")) {
                    this.loadCoplet((Element)current, defaultCoplets, mediaCoplets, copletList, parallelCoplets, defaultCopletTimeout, statusProfile);
                }
                ++i;
            }
        }
    }

    private void loadCoplet(Element element, Map defaultCoplets, Map mediaCoplets, List copletList, boolean parallelCoplets, long defaultCopletTimeout, Element statusProfile) throws ProcessingException, TransformerException {
        String copletID = element.getAttributeNS(null, "id");
        Element copletConf = this.getCopletConfiguration(copletID, defaultCoplets, mediaCoplets);
        if (copletConf != null) {
            boolean visible = DOMUtil.getValueAsBooleanOf((Node)element, (String)"status/visible", (XPathProcessor)this.xpathProcessor);
            String media = this.getMediaManager().getMediaType();
            if (visible && copletConf.hasAttributeNS(null, "media")) {
                String copletMedia = copletConf.getAttributeNS(null, "media");
                visible = media.equals(copletMedia);
            }
            if (visible) {
                Object[] loadedCoplet = new Object[8];
                copletList.add(loadedCoplet);
                boolean isCustomizable = DOMUtil.getValueAsBooleanOf((Node)copletConf, (String)"configuration/customizable", (boolean)false, (XPathProcessor)this.xpathProcessor);
                if (isCustomizable) {
                    Node node;
                    boolean showCustomizePage = DOMUtil.getValueAsBooleanOf((Node)element, (String)"status/customize", (boolean)false, (XPathProcessor)this.xpathProcessor);
                    boolean hasConfig = false;
                    if (statusProfile != null) {
                        Element customInfo = (Element)DOMUtil.getSingleNode((Node)statusProfile, (String)("customization/coplet[@id='" + copletID + "' and @number='" + element.getAttributeNS(null, "number") + "']"), (XPathProcessor)this.xpathProcessor);
                        boolean bl = hasConfig = customInfo != null;
                    }
                    if (showCustomizePage || !hasConfig) {
                        node = DOMUtil.selectSingleNode((Node)element, (String)"status/customize", (XPathProcessor)this.xpathProcessor);
                        DOMUtil.setValueOfNode((Node)node, (String)"true");
                    } else {
                        node = DOMUtil.selectSingleNode((Node)element, (String)"status/customize", (XPathProcessor)this.xpathProcessor);
                        DOMUtil.setValueOfNode((Node)node, (String)"false");
                    }
                } else {
                    Node node = DOMUtil.selectSingleNode((Node)element, (String)"status/customize", (XPathProcessor)this.xpathProcessor);
                    DOMUtil.setValueOfNode((Node)node, (String)"false");
                }
                SourceParameters p = DOMUtil.createParameters((Node)DOMUtil.getFirstNodeFromPath((Node)element, (String[])new String[]{"status"}, (boolean)false), null);
                p.setSingleParameterValue("id", copletID);
                p.setSingleParameterValue("number", element.getAttributeNS(null, "number"));
                p.setSingleParameterValue("media", media);
                String isPersistent = DOMUtil.getValueOf((Node)copletConf, (String)"configuration/persistent", (String)"false", (XPathProcessor)this.xpathProcessor);
                p.setSingleParameterValue("persistent", isPersistent);
                loadedCoplet[0] = null;
                loadedCoplet[1] = copletConf;
                loadedCoplet[2] = p;
                loadedCoplet[3] = element;
                loadedCoplet[4] = new Long(System.currentTimeMillis());
                loadedCoplet[5] = new Long(DOMUtil.getValueOf((Node)copletConf, (String)"configuration/timeout", (String)"-1", (XPathProcessor)this.xpathProcessor));
                loadedCoplet[7] = statusProfile;
                CopletThread copletThread = new CopletThread();
                Thread theThread = new Thread(copletThread);
                loadedCoplet[6] = copletThread;
                copletThread.init(copletID, ContextHelper.getObjectModel((Context)this.componentContext), this.getLogger(), loadedCoplet, this.manager, this.resolver, this.xpathProcessor);
                theThread.start();
                Thread.yield();
                if (!parallelCoplets && (copletThread = (CopletThread)loadedCoplet[6]) != null) {
                    long startTime = System.currentTimeMillis() - (Long)loadedCoplet[4];
                    long timeout = (Long)loadedCoplet[5];
                    long waitTime = timeout == -1L ? defaultCopletTimeout : timeout - startTime;
                    while (copletThread != null && waitTime > 2L) {
                        try {
                            Thread.sleep(15L);
                            waitTime -= 15L;
                        }
                        catch (InterruptedException local) {
                            // empty catch block
                        }
                        copletThread = (CopletThread)loadedCoplet[6];
                    }
                    loadedCoplet[6] = null;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCoplet(Object[] loadedCoplet, XMLConsumer consumer, String notAvailableMessage, long defaultCopletTimeout) throws ProcessingException, SAXException, TransformerException {
        block17: {
            block16: {
                Element copletConf;
                block18: {
                    byte[] content;
                    int i;
                    int l;
                    copletConf = (Element)loadedCoplet[1];
                    Element element = (Element)loadedCoplet[3];
                    String copletID = element.getAttributeNS(null, "id");
                    if (copletConf == null) break block17;
                    AttributesImpl attr = new AttributesImpl();
                    attr.addAttribute("", "id", "id", "CDATA", copletID);
                    attr.addAttribute("", "number", "number", "CDATA", element.getAttributeNS(null, "number"));
                    attr.addAttribute("", "position", "position", "CDATA", element.getAttributeNS(null, "position"));
                    consumer.startElement("", "coplet", "coplet", (Attributes)attr);
                    attr.clear();
                    NodeList children = copletConf.getChildNodes();
                    if (children != null && children.getLength() > 0) {
                        l = children.getLength();
                        i = 0;
                        while (i < l) {
                            if (!children.item(i).getNodeName().equals("status") && children.item(i).getNodeType() == 1) {
                                IncludeXMLConsumer.includeNode((Node)children.item(i), (ContentHandler)consumer, (LexicalHandler)consumer);
                            }
                            ++i;
                        }
                    }
                    consumer.startElement("", "status", "status", (Attributes)attr);
                    children = DOMUtil.selectNodeList((Node)element, (String)"status/*", (XPathProcessor)this.xpathProcessor);
                    if (children != null && children.getLength() > 0) {
                        l = children.getLength();
                        i = 0;
                        while (i < l) {
                            if (children.item(i).getNodeType() == 1) {
                                IncludeXMLConsumer.includeNode((Node)children.item(i), (ContentHandler)consumer, (LexicalHandler)consumer);
                            }
                            ++i;
                        }
                    }
                    consumer.endElement("", "status", "status");
                    consumer.startElement("", "content", "content", (Attributes)attr);
                    CopletThread thread = (CopletThread)loadedCoplet[6];
                    if (thread != null) {
                        long startTime = System.currentTimeMillis() - (Long)loadedCoplet[4];
                        long timeout = (Long)loadedCoplet[5];
                        long waitTime = timeout == -1L ? defaultCopletTimeout : timeout - startTime;
                        while (thread != null && waitTime > 2L) {
                            try {
                                Thread.sleep(15L);
                                waitTime -= 15L;
                            }
                            catch (InterruptedException local) {
                                // empty catch block
                            }
                            thread = (CopletThread)loadedCoplet[6];
                        }
                    }
                    if ((content = (byte[])loadedCoplet[0]) == null) break block18;
                    if (content.length > 0) {
                        XMLDeserializer interpreter = null;
                        try {
                            try {
                                interpreter = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                                interpreter.setConsumer((XMLConsumer)new IncludeXMLConsumer((ContentHandler)consumer, (LexicalHandler)consumer));
                                interpreter.deserialize((Object)content);
                            }
                            catch (ComponentException e) {
                                throw new ProcessingException("Component for XMLDeserializer not found." + (Object)((Object)e), (Throwable)e);
                            }
                            Object var20_20 = null;
                            if (interpreter == null) break block16;
                        }
                        catch (Throwable throwable) {
                            Object var20_21 = null;
                            if (interpreter != null) {
                                this.manager.release((Component)interpreter);
                            }
                            throw throwable;
                        }
                        this.manager.release((Component)interpreter);
                    }
                    break block16;
                }
                notAvailableMessage = DOMUtil.getValueOf((Node)copletConf, (String)"configuration/messages/coplet_not_available", (String)notAvailableMessage, (XPathProcessor)this.xpathProcessor);
                consumer.characters(notAvailableMessage.toCharArray(), 0, notAvailableMessage.length());
            }
            consumer.endElement("", "content", "content");
            consumer.endElement("", "coplet", "coplet");
        }
    }

    public String getMediaType() throws ProcessingException {
        this.setup();
        return this.getMediaManager().getMediaType();
    }

    private Element getCopletConfiguration(String copletID, Map defaultCoplets, Map mediaCoplets) throws ProcessingException {
        String media = this.getMediaManager().getMediaType();
        Map coplets = (Map)mediaCoplets.get(media);
        Element coplet = null;
        if (coplets != null) {
            coplet = (Element)coplets.get(copletID);
        }
        if (coplet == null) {
            coplet = (Element)defaultCoplets.get(copletID);
        }
        return coplet;
    }

    private Element getCopletElement(String copletID, String copletNr, Node[] miscNodes) throws TransformerException {
        Element node = null;
        int colindex = 8;
        while (node == null && colindex < 13) {
            if (miscNodes[colindex] != null) {
                node = (Element)DOMUtil.getSingleNode((Node)miscNodes[colindex], (String)("coplets/coplet[@id='" + copletID + "' and @number='" + copletNr + "']"), (XPathProcessor)this.xpathProcessor);
                ++colindex;
                continue;
            }
            colindex = 13;
        }
        if (node == null && miscNodes[2] != null) {
            node = (Element)DOMUtil.getSingleNode((Node)miscNodes[2], (String)("coplet[@id='" + copletID + "' and @number='" + copletNr + "']"), (XPathProcessor)this.xpathProcessor);
        }
        if (node == null && miscNodes[3] != null) {
            node = (Element)DOMUtil.getSingleNode((Node)miscNodes[3], (String)("coplet[@id='" + copletID + "' and @number='" + copletNr + "']"), (XPathProcessor)this.xpathProcessor);
        }
        return node;
    }

    private boolean modifyCoplet(String requestString, SessionContext context, Map theProfile, DocumentFragment profile) throws ProcessingException, TransformerException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN modifyCoplet request=" + requestString);
        }
        boolean result = false;
        int pos = requestString.indexOf(95);
        int pos2 = requestString.indexOf(95, pos + 1);
        if (pos != -1 && pos2 != -1) {
            Element coplet = null;
            String argument = null;
            String copletID = requestString.substring(pos + 1, pos2);
            String copletNr = requestString.substring(pos2 + 1);
            pos = copletNr.indexOf(95);
            if (pos != -1) {
                argument = copletNr.substring(pos + 1);
                copletNr = copletNr.substring(0, pos);
            }
            if (requestString.startsWith("new") && this.isCopletAvailable(context, copletID, (Map)theProfile.get("defCoplets"), (Map)theProfile.get("mediaCoplets"))) {
                Node oldCoplet;
                Node copletsNode;
                Node[] miscNodes = (Node[])theProfile.get("misc");
                Node lastCoplet = miscNodes[5];
                String lastNumber = null;
                if (lastCoplet != null && (lastNumber = ((Element)lastCoplet).getAttributeNS(null, "number")) != null) {
                    int value = new Integer(lastNumber);
                    lastNumber = "" + ++value;
                }
                if (lastNumber == null) {
                    lastNumber = "0";
                }
                if (copletNr.equals("header")) {
                    copletsNode = miscNodes[2];
                    if (copletsNode == null) {
                        miscNodes[2] = copletsNode = DOMUtil.selectSingleNode((Node)profile, (String)"profile/portal-profile/content/header", (XPathProcessor)this.xpathProcessor);
                    } else {
                        oldCoplet = DOMUtil.getFirstNodeFromPath((Node)copletsNode, (String[])new String[]{"coplet"}, (boolean)false);
                        if (oldCoplet != null) {
                            copletsNode.removeChild(oldCoplet);
                        }
                    }
                } else if (copletNr.equals("footer")) {
                    copletsNode = miscNodes[3];
                    if (copletsNode == null) {
                        miscNodes[3] = copletsNode = DOMUtil.selectSingleNode((Node)profile, (String)"profile/portal-profile/content/footer", (XPathProcessor)this.xpathProcessor);
                    } else {
                        oldCoplet = DOMUtil.getFirstNodeFromPath((Node)copletsNode, (String[])new String[]{"coplet"}, (boolean)false);
                        if (oldCoplet != null) {
                            copletsNode.removeChild(oldCoplet);
                        }
                    }
                } else {
                    Node columnNode = miscNodes[7 + new Integer(copletNr)];
                    copletsNode = DOMUtil.getFirstNodeFromPath((Node)columnNode, (String[])new String[]{"coplets"}, (boolean)false);
                }
                Document doc = copletsNode.getOwnerDocument();
                Element copletNode = doc.createElementNS(null, "coplet");
                copletsNode.appendChild(copletNode);
                copletNode.setAttributeNS(null, "id", copletID);
                copletNode.setAttributeNS(null, "number", lastNumber);
                NodeList childs = DOMUtil.getNodeListFromPath((Node)copletsNode, (String[])new String[]{"coplet"});
                int childsCount = childs == null ? 0 : childs.getLength();
                copletNode.setAttributeNS(null, "position", "" + childsCount);
                miscNodes[5] = copletNode;
                Element configElement = this.getCopletConfiguration(copletID, (Map)theProfile.get("defCoplets"), (Map)theProfile.get("mediaCoplets"));
                Element configStatus = (Element)DOMUtil.getFirstNodeFromPath((Node)configElement, (String[])new String[]{"status"}, (boolean)false);
                copletNode.appendChild(configStatus.cloneNode(true));
                Element status = (Element)copletNode.getElementsByTagName("status").item(0);
                NodeList parameters = status.getChildNodes();
                if (parameters != null) {
                    int i = 0;
                    while (i < parameters.getLength()) {
                        Node current = parameters.item(i);
                        if (current.getNodeType() == 1) {
                            Element statusNode = (Element)current;
                            if (statusNode.hasAttributeNS(null, "formpath")) {
                                statusNode.removeAttributeNS(null, "formpath");
                            }
                            if (statusNode.hasAttributeNS(null, "formtype")) {
                                statusNode.removeAttributeNS(null, "formtype");
                            }
                            if (statusNode.hasAttributeNS(null, "formdescription")) {
                                statusNode.removeAttributeNS(null, "formdescription");
                            }
                        }
                        ++i;
                    }
                }
                result = true;
            } else {
                coplet = this.getCopletElement(copletID, copletNr, (Node[])theProfile.get("misc"));
                if (coplet != null) {
                    Element newCoplet;
                    if (requestString.startsWith("close") || requestString.startsWith("hide")) {
                        Node node = DOMUtil.selectSingleNode((Node)coplet, (String)"status/visible", (XPathProcessor)this.xpathProcessor);
                        DOMUtil.setValueOfNode((Node)node, (String)"false");
                    } else if (requestString.startsWith("open") || requestString.startsWith("show")) {
                        Node node = DOMUtil.selectSingleNode((Node)coplet, (String)"status/visible", (XPathProcessor)this.xpathProcessor);
                        DOMUtil.setValueOfNode((Node)node, (String)"true");
                    } else if (requestString.startsWith("minimize")) {
                        Node node = DOMUtil.selectSingleNode((Node)coplet, (String)"status/size", (XPathProcessor)this.xpathProcessor);
                        DOMUtil.setValueOfNode((Node)node, (String)"min");
                    } else if (requestString.startsWith("maximize")) {
                        Node node = DOMUtil.selectSingleNode((Node)coplet, (String)"status/size", (XPathProcessor)this.xpathProcessor);
                        DOMUtil.setValueOfNode((Node)node, (String)"max");
                    } else if (requestString.startsWith("customize")) {
                        Node node = DOMUtil.selectSingleNode((Node)coplet, (String)"status/customize", (XPathProcessor)this.xpathProcessor);
                        DOMUtil.setValueOfNode((Node)node, (String)"true");
                    } else if (requestString.startsWith("update")) {
                        Node node = DOMUtil.selectSingleNode((Node)coplet, (String)"status/customize", (XPathProcessor)this.xpathProcessor);
                        DOMUtil.setValueOfNode((Node)node, (String)"false");
                    } else if (requestString.startsWith("delete")) {
                        Node statusNode = DOMUtil.getSingleNode((Node)profile, (String)("profile/status-profile/customization/coplet[@id='" + copletID + "' and @number='" + copletNr + "']"), (XPathProcessor)this.xpathProcessor);
                        if (statusNode != null) {
                            statusNode.getParentNode().removeChild(statusNode);
                            Element configElement = this.getCopletConfiguration(copletID, (Map)theProfile.get("defCoplets"), (Map)theProfile.get("mediaCoplets"));
                            boolean isPersistent = DOMUtil.getValueAsBooleanOf((Node)configElement, (String)"configuration/persistent", (boolean)false, (XPathProcessor)this.xpathProcessor);
                            if (isPersistent) {
                                theProfile.put("saveStatus", "true");
                            }
                        }
                        String posAttr = coplet.getAttributeNS(null, "position");
                        NodeList followUps = DOMUtil.selectNodeList((Node)coplet.getParentNode(), (String)("coplet[@position > '" + posAttr + "']"), (XPathProcessor)this.xpathProcessor);
                        coplet.getParentNode().removeChild(coplet);
                        coplet = null;
                        if (followUps != null) {
                            int i = 0;
                            while (i < followUps.getLength()) {
                                int value = new Integer(((Element)followUps.item(i)).getAttributeNS(null, "position"));
                                ((Element)followUps.item(i)).setAttributeNS(null, "position", "" + --value);
                                ++i;
                            }
                        }
                    } else if (requestString.startsWith("move")) {
                        Element copletsElement;
                        if (argument != null && (copletsElement = (Element)DOMUtil.getSingleNode((Node)profile, (String)("profile/portal-profile/content/column[@position='" + argument + "']/coplets"), (XPathProcessor)this.xpathProcessor)) != null && !coplet.getParentNode().equals(copletsElement)) {
                            String posAttr = coplet.getAttributeNS(null, "position");
                            NodeList followUps = DOMUtil.selectNodeList((Node)coplet.getParentNode(), (String)("coplet[@position > '" + posAttr + "']"), (XPathProcessor)this.xpathProcessor);
                            coplet.getParentNode().removeChild(coplet);
                            NodeList childs = DOMUtil.getNodeListFromPath((Node)copletsElement, (String[])new String[]{"coplet"});
                            int childsCount = childs == null ? 0 : childs.getLength();
                            coplet.setAttributeNS(null, "position", "" + (childsCount + 1));
                            copletsElement.appendChild(coplet);
                            if (followUps != null) {
                                int i = 0;
                                while (i < followUps.getLength()) {
                                    int value = new Integer(((Element)followUps.item(i)).getAttributeNS(null, "position"));
                                    ((Element)followUps.item(i)).setAttributeNS(null, "position", "" + --value);
                                    ++i;
                                }
                            }
                        }
                    } else if (requestString.startsWith("row") && argument != null && (newCoplet = (Element)DOMUtil.getSingleNode((Node)coplet.getParentNode(), (String)("coplet[@position='" + argument + "']"), (XPathProcessor)this.xpathProcessor)) != null) {
                        String position = coplet.getAttributeNS(null, "position");
                        coplet.removeAttributeNS(null, "position");
                        coplet.setAttributeNS(null, "position", argument);
                        newCoplet.removeAttributeNS(null, "position");
                        newCoplet.setAttributeNS(null, "position", position);
                    }
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END modifyCoplet calculate=" + result);
        }
        return result;
    }

    private boolean isCopletAvailable(SessionContext context, String copletID, Map defaultCoplets, Map mediaCoplets) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN isCopletAvailable coplet=" + copletID);
        }
        boolean result = false;
        if (context != null && !(result = defaultCoplets.containsKey(copletID))) {
            Iterator iter = mediaCoplets.values().iterator();
            while (!result && iter.hasNext()) {
                result = ((Map)iter.next()).containsKey(copletID);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END isCopletAvailable result=" + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAuthentication(Redirector redirector, String copletID) throws SAXException, IOException, ProcessingException {
        Map config;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN checkAuthentication coplet=" + copletID);
        }
        this.setup();
        boolean result = false;
        SessionContext context = this.getContext(false);
        if (context != null && (String)context.getAttribute("role") != null) {
            try {
                this.getTransactionManager().startReadingTransaction(context);
                Map theProfile = this.retrieveProfile(this.getProfileID("user", (String)context.getAttribute("role"), (String)context.getAttribute("ID"), false));
                if (theProfile != null) {
                    result = copletID == null || copletID.trim().length() == 0 ? true : this.isCopletAvailable(context, copletID, (Map)theProfile.get("defCoplets"), (Map)theProfile.get("mediaCoplets"));
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.getTransactionManager().stopReadingTransaction(context);
                throw throwable;
            }
            this.getTransactionManager().stopReadingTransaction(context);
            {
            }
        }
        if (!result && (config = this.getConfiguration()) != null) {
            String redirectURI = (String)config.get("B");
            if (redirectURI == null) {
                redirectURI = (String)config.get("S");
            }
            if (redirectURI != null) {
                redirector.globalRedirect(false, redirectURI);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END checkAuthentication result=" + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getConfiguration() throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN getConfiguration");
        }
        HashMap<String, Object> result = null;
        RequestState reqstate = this.getRequestState();
        String appName = reqstate.getApplicationName();
        String handlerName = reqstate.getHandlerName();
        Session session = this.getSessionManager().getSession(false);
        if (session != null && appName != null && handlerName != null) {
            Session session2 = session;
            synchronized (session2) {
                result = (HashMap<String, Object>)session.getAttribute("portalConf" + handlerName + ':' + appName);
                if (result == null) {
                    try {
                        Configuration conf = reqstate.getModuleConfiguration("portal");
                        if (conf == null) {
                            throw new ProcessingException("portal: Configuration for application '" + appName + "' not found.");
                        }
                        result = new HashMap<String, Object>(10, 2.0f);
                        Configuration config = conf.getChild("auth-redirect", false);
                        if (config != null) {
                            result.put("B", config.getValue());
                        }
                        if ((config = conf.getChild("portal-uri", false)) == null) {
                            throw new ProcessingException("portal: portal-uri required for application '" + appName + "'");
                        }
                        result.put("S", config.getValue());
                        config = conf.getChild("profile-cache", false);
                        if (config != null && config.getValueAsBoolean()) {
                            result.put("T", appName);
                        }
                        if ((config = conf.getChild("process-coplets-parallel", false)) != null) {
                            result.put("U", new Boolean(config.getValueAsBoolean(false)));
                        } else {
                            result.put("U", Boolean.FALSE);
                        }
                        config = conf.getChild("default-coplet-timeout", false);
                        if (config != null) {
                            result.put("V", new Long(config.getValueAsLong(600000L)));
                        } else {
                            result.put("V", new Long(600000L));
                        }
                        config = conf.getChild("profile", false);
                        if (config == null) {
                            throw new ProcessingException("portal: profile configuration required for application '" + appName + "'");
                        }
                        Configuration child = config.getChild("buildprofile", false);
                        if (child != null) {
                            result.put("A", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("layout-base", false)) == null) {
                            throw new ProcessingException("portal: layout-base required for application '" + appName + "'");
                        }
                        result.put("C", child.getAttribute("uri"));
                        child = config.getChild("coplet-base", false);
                        if (child == null) {
                            throw new ProcessingException("portal: coplet-base required for application '" + appName + "'");
                        }
                        result.put("D", child.getAttribute("uri"));
                        child = config.getChild("type-base", false);
                        if (child != null) {
                            result.put("F", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("coplet-base-save", false)) != null) {
                            result.put("E", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("global-delta-load", false)) == null) {
                            throw new ProcessingException("portal: global-delta-load required for application '" + appName + "'");
                        }
                        result.put("G", child.getAttribute("uri"));
                        child = config.getChild("global-delta-save", false);
                        if (child != null) {
                            result.put("H", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("global-type-delta", false)) != null) {
                            result.put("I", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("role-delta-load", false)) != null) {
                            result.put("J", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("role-delta-save", false)) != null) {
                            result.put("K", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("role-type-delta", false)) != null) {
                            result.put("L", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("user-delta-load", false)) != null) {
                            result.put("M", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("user-delta-save", false)) != null) {
                            result.put("N", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("user-type-delta", false)) != null) {
                            result.put("O", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("user-status-load", false)) != null) {
                            result.put("P", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("user-status-save", false)) != null) {
                            result.put("Q", child.getAttribute("uri"));
                        }
                        if ((child = config.getChild("admin-type-base", false)) != null) {
                            result.put("R", child.getAttribute("uri"));
                        }
                        session.setAttribute("portalConf" + handlerName + ':' + appName, result);
                    }
                    catch (ConfigurationException conf) {
                        throw new ProcessingException("ConfigurationException: " + (Object)((Object)conf), (Throwable)conf);
                    }
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END getConfiguration conf=" + result);
        }
        return result;
    }

    private void createProfile(SessionContext context, String type, String role, String id, boolean adminProfile) throws SAXException, IOException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN createProfile context=" + context + ", type=" + type + ", role=" + role + ", id=" + id);
        }
        RequestState reqstate = this.getRequestState();
        SourceParameters pars = reqstate.getHandler().getContext().getContextInfoAsParameters();
        pars.setSingleParameterValue("type", type);
        pars.setSingleParameterValue("admin", adminProfile ? "true" : "false");
        if (!type.equals("user") || role != null) {
            pars.setSingleParameterValue("ID", id);
            pars.setSingleParameterValue("role", role);
        } else {
            id = pars.getParameter("ID", null);
            role = pars.getParameter("role", null);
        }
        Map map = this.getConfiguration();
        if (map == null) {
            throw new ProcessingException("portal Configuration not found.");
        }
        String resource = (String)map.get("A");
        if (resource != null) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Building portal profile: " + resource);
            }
            SourceUtil.readDOM((String)resource, null, (SourceParameters)pars, (SourceResolver)this.resolver);
        } else {
            this.buildProfile(type, role, id, adminProfile);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END createProfile");
        }
    }

    private DocumentFragment buildBaseProfile(Map config, boolean adminProfile) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN buildBaseProfile config=" + config + ", adminProfile=" + adminProfile);
        }
        SourceParameters pars = new SourceParameters();
        RequestState reqstate = this.getRequestState();
        pars.setSingleParameterValue("application", reqstate.getApplicationName());
        pars.setSingleParameterValue("handler", reqstate.getHandlerName());
        pars.setSingleParameterValue("profile", "coplet-base");
        String res = (String)config.get("D");
        if (res == null) {
            throw new ProcessingException("No configuration for portal-coplet base profile found.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Loading coplet base profile");
        }
        DocumentFragment copletsFragment = SourceUtil.readDOM((String)res, null, (SourceParameters)pars, (SourceResolver)this.resolver);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("coplet base profile loaded");
        }
        if ((res = (String)config.get("C")) == null) {
            throw new ProcessingException("No configuration for portal-layout base profile found.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("loading layout base profile");
        }
        pars.setSingleParameterValue("profile", "layout-base");
        DocumentFragment layoutFragment = SourceUtil.readDOM((String)res, null, (SourceParameters)pars, (SourceResolver)this.resolver);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("layout base profile loaded");
        }
        Document profileDoc = DOMUtil.createDocument();
        DocumentFragment profile = profileDoc.createDocumentFragment();
        Element profileRoot = profileDoc.createElementNS(null, "profile");
        profile.appendChild(profileRoot);
        profileRoot.appendChild(profileDoc.importNode(DOMUtil.selectSingleNode((Node)layoutFragment, (String)"layout-profile", (XPathProcessor)this.xpathProcessor), true));
        profileRoot.appendChild(profileDoc.importNode(DOMUtil.selectSingleNode((Node)copletsFragment, (String)"coplets-profile", (XPathProcessor)this.xpathProcessor), true));
        if (adminProfile) {
            res = (String)config.get("R");
            pars.setSingleParameterValue("profile", "admin-type-base");
        } else {
            res = (String)config.get("F");
            pars.setSingleParameterValue("profile", "type-base");
        }
        if (res != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("loading type base profile");
            }
            DocumentFragment typeFragment = SourceUtil.readDOM((String)res, null, (SourceParameters)pars, (SourceResolver)this.resolver);
            profileRoot.appendChild(profileDoc.importNode(DOMUtil.selectSingleNode((Node)typeFragment, (String)"type-profile", (XPathProcessor)this.xpathProcessor), true));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("type base profile loaded");
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END buildBaseProfile profile=" + profile);
        }
        return profile;
    }

    private void buildGlobalProfile(Element profileRoot, Map config, boolean adminProfile) throws ProcessingException {
        String res;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN buildGlobalProfile profileRoot=" + profileRoot + ", config=" + config + ", adminProfile=" + adminProfile);
        }
        if ((res = (String)config.get("G")) == null) {
            throw new ProcessingException("No configuration for portal-role delta profile found.");
        }
        SourceParameters pars = new SourceParameters();
        RequestState reqstate = this.getRequestState();
        pars.setSingleParameterValue("application", reqstate.getApplicationName());
        pars.setSingleParameterValue("handler", reqstate.getHandlerName());
        pars.setSingleParameterValue("profile", "global-delta");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("loading global profile");
        }
        DocumentFragment globalFragment = SourceUtil.readDOM((String)res, null, (SourceParameters)pars, (SourceResolver)this.resolver);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("global profile loaded");
        }
        this.importProfileDelta(profileRoot, globalFragment, "global-delta", "layout-delta");
        this.importProfileDelta(profileRoot, globalFragment, "global-delta", "coplets-delta");
        this.addProfilePart(profileRoot, globalFragment, "global-delta", "portal-profile");
        this.addProfilePart(profileRoot, globalFragment, "global-delta", "personal-profile");
        res = (String)config.get("I");
        if (!adminProfile && res != null) {
            pars.setSingleParameterValue("profile", "global-type-delta");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("loading global type profile");
            }
            globalFragment = SourceUtil.readDOM((String)res, null, (SourceParameters)pars, (SourceResolver)this.resolver);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("global type profile loaded");
            }
            this.addProfilePart(profileRoot, globalFragment, "global-delta", "type-profile");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END buildGlobalProfile");
        }
    }

    private void buildRoleProfile(Element profileRoot, Map config, String role, boolean adminProfile) throws ProcessingException {
        DocumentFragment roleFragment;
        RequestState reqstate = this.getRequestState();
        SourceParameters pars = new SourceParameters();
        pars.setSingleParameterValue("role", role);
        pars.setSingleParameterValue("application", reqstate.getApplicationName());
        pars.setSingleParameterValue("handler", reqstate.getHandlerName());
        pars.setSingleParameterValue("profile", "role-delta");
        String res = (String)config.get("J");
        if (res != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("loading role profile");
            }
            roleFragment = SourceUtil.readDOM((String)res, null, (SourceParameters)pars, (SourceResolver)this.resolver);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("role profile loaded");
            }
            this.importProfileDelta(profileRoot, roleFragment, "role-delta", "layout-delta");
            this.importProfileDelta(profileRoot, roleFragment, "role-delta", "coplets-delta");
            this.addProfilePart(profileRoot, roleFragment, "role-delta", "portal-profile");
            this.importProfileDelta(profileRoot, roleFragment, "role-delta", "personal-delta");
        }
        res = (String)config.get("L");
        if (!adminProfile && res != null) {
            pars.setSingleParameterValue("profile", "role-type-delta");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("loading role type profile");
            }
            roleFragment = SourceUtil.readDOM((String)res, null, (SourceParameters)pars, (SourceResolver)this.resolver);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("role type profile loaded");
            }
            this.addProfilePart(profileRoot, roleFragment, "role-delta", "type-profile");
        }
    }

    private void buildUserProfile(Element profileRoot, Map config, String role, String id, boolean adminProfile) throws ProcessingException {
        DocumentFragment userFragment;
        RequestState reqstate = this.getRequestState();
        SourceParameters pars = new SourceParameters();
        pars.setSingleParameterValue("ID", id);
        pars.setSingleParameterValue("role", role);
        pars.setSingleParameterValue("application", reqstate.getApplicationName());
        pars.setSingleParameterValue("handler", reqstate.getHandlerName());
        pars.setSingleParameterValue("profile", "user-delta");
        String res = (String)config.get("M");
        if (res != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("loading user profile");
            }
            userFragment = SourceUtil.readDOM((String)res, null, (SourceParameters)pars, (SourceResolver)this.resolver);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("user profile loaded");
            }
            this.importProfileDelta(profileRoot, userFragment, "user-delta", "layout-delta");
            this.importProfileDelta(profileRoot, userFragment, "user-delta", "coplets-delta");
            this.addProfilePart(profileRoot, userFragment, "user-delta", "portal-profile");
            this.importProfileDelta(profileRoot, userFragment, "user-delta", "personal-delta");
        }
        res = (String)config.get("O");
        if (!adminProfile && res != null) {
            pars.setSingleParameterValue("profile", "user-type-delta");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("loading user type profile");
            }
            userFragment = SourceUtil.readDOM((String)res, null, (SourceParameters)pars, (SourceResolver)this.resolver);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("user type profile loaded");
            }
            this.addProfilePart(profileRoot, userFragment, "user-delta", "type-profile");
        }
    }

    private void buildUserStatusProfile(Element profileRoot, Map config, String role, String id) throws ProcessingException {
        String res = (String)config.get("P");
        Node statusProfile = DOMUtil.getFirstNodeFromPath((Node)profileRoot, (String[])new String[]{"status-profile"}, (boolean)false);
        if (statusProfile != null) {
            profileRoot.removeChild(statusProfile);
        }
        if (res != null) {
            RequestState reqstate = this.getRequestState();
            SourceParameters pars = new SourceParameters();
            pars.setSingleParameterValue("ID", id);
            pars.setSingleParameterValue("role", role);
            pars.setSingleParameterValue("application", reqstate.getApplicationName());
            pars.setSingleParameterValue("handler", reqstate.getHandlerName());
            pars.setSingleParameterValue("profile", "user-status");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("loading user status profile");
            }
            DocumentFragment userFragment = SourceUtil.readDOM((String)res, null, (SourceParameters)pars, (SourceResolver)this.resolver);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("user status profile loaded");
            }
            this.addProfilePart(profileRoot, userFragment, null, "status-profile");
        }
        if (DOMUtil.getFirstNodeFromPath((Node)profileRoot, (String[])new String[]{"status-profile"}, (boolean)false) == null) {
            statusProfile = profileRoot.getOwnerDocument().createElementNS(null, "status-profile");
            profileRoot.appendChild(statusProfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUserStatusProfile(Map profile, Map config, String role, String id) throws ProcessingException {
        String res = (String)config.get("Q");
        Element statusProfile = (Element)DOMUtil.getFirstNodeFromPath((Node)((DocumentFragment)profile.get("profile")), (String[])new String[]{"profile", "status-profile"}, (boolean)false);
        if (res != null && statusProfile != null) {
            DocumentFragment userFragment = statusProfile.getOwnerDocument().createDocumentFragment();
            Element saveStatus = (Element)statusProfile.cloneNode(true);
            userFragment.appendChild(saveStatus);
            NodeList list = DOMUtil.getNodeListFromPath((Node)saveStatus, (String[])new String[]{"customization", "coplet"});
            Map copletConfigs = (Map)profile.get("defCoplets");
            Map mediaCopletConfigs = (Map)profile.get("mediaCoplets");
            int i = 0;
            while (i < list.getLength()) {
                Element coplet = (Element)list.item(i);
                String copletID = coplet.getAttributeNS(null, "id");
                Element copletConfig = this.getCopletConfiguration(copletID, copletConfigs, mediaCopletConfigs);
                boolean isPersistent = DOMUtil.getValueAsBooleanOf((Node)copletConfig, (String)"configuration/persistent", (boolean)false, (XPathProcessor)this.xpathProcessor);
                if (!isPersistent) {
                    coplet.getParentNode().removeChild(coplet);
                }
                ++i;
            }
            try {
                RequestState reqstate = this.getRequestState();
                SourceParameters pars = new SourceParameters();
                pars.setSingleParameterValue("ID", id);
                pars.setSingleParameterValue("role", role);
                pars.setSingleParameterValue("application", reqstate.getApplicationName());
                pars.setSingleParameterValue("handler", reqstate.getHandlerName());
                pars.setSingleParameterValue("profile", "user-status");
                SourceUtil.writeDOM((String)res, null, (SourceParameters)pars, (DocumentFragment)userFragment, (SourceResolver)this.resolver, (String)"xml");
                Object var20_19 = null;
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                userFragment.removeChild(saveStatus);
                throw throwable;
            }
            userFragment.removeChild(saveStatus);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeProfile() throws ProcessingException, SAXException, IOException {
        block31: {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("BEGIN changeProfile");
            }
            Request request = ContextHelper.getRequest((Context)this.componentContext);
            SessionContext context = this.getContext(false);
            if (context != null) {
                try {
                    Map theProfile = null;
                    String profileID = request.getParameter("portalprofile");
                    if (profileID != null) {
                        theProfile = this.retrieveProfile(profileID);
                    }
                    if (theProfile == null) break block31;
                    SessionContext sessionContext = context;
                    synchronized (sessionContext) {
                        Object statusChanged;
                        String current;
                        DocumentFragment profile = (DocumentFragment)theProfile.get("profile");
                        Node[] miscNodes = (Node[])theProfile.get("misc");
                        Element columns = (Element)miscNodes[4];
                        Enumeration enumeration = request.getParameterNames();
                        boolean saveProfile = false;
                        while (enumeration.hasMoreElements()) {
                            Node node;
                            NodeList nodes;
                            current = (String)enumeration.nextElement();
                            if (!current.startsWith("portalconf")) continue;
                            int pos1 = current.indexOf(46);
                            int pos2 = current.indexOf(46, pos1 + 1);
                            if (pos1 == -1 || pos2 == -1) continue;
                            int pathIndex = new Integer(current.substring(pos1 + 1, pos2));
                            int place = new Integer(current.substring(pos2 + 1));
                            List typePaths = (List)theProfile.get("typeConfPaths");
                            String path = (String)typePaths.get(pathIndex);
                            if (path == null || (nodes = DOMUtil.selectNodeList((Node)profile, (String)path, (XPathProcessor)this.xpathProcessor)) == null || (node = nodes.item(place)) == null || node.equals(columns)) continue;
                            DOMUtil.setValueOfNode((Node)node, (String)request.getParameter(current));
                        }
                        boolean calculate = false;
                        enumeration = request.getParameterNames();
                        while (enumeration.hasMoreElements()) {
                            String[] cmds;
                            current = (String)enumeration.nextElement();
                            if (current.startsWith("portalconf")) {
                                Node node;
                                NodeList nodes;
                                int pos1 = current.indexOf(46);
                                int pos2 = current.indexOf(46, pos1 + 1);
                                if (pos1 == -1 || pos2 == -1) continue;
                                int pathIndex = new Integer(current.substring(pos1 + 1, pos2));
                                int place = new Integer(current.substring(pos2 + 1));
                                List typePaths = (List)theProfile.get("typeConfPaths");
                                String path = (String)typePaths.get(pathIndex);
                                if (path == null || (nodes = DOMUtil.selectNodeList((Node)profile, (String)path, (XPathProcessor)this.xpathProcessor)) == null || (node = nodes.item(place)) == null || !node.equals(columns)) continue;
                                int columnNumber = new Integer(request.getParameter(current));
                                int oldNumber = new Integer(DOMUtil.getValueOfNode((Node)columns));
                                if (columnNumber <= 0 || columnNumber == oldNumber || columnNumber > 5) continue;
                                this.changeColumns(profile, oldNumber, columnNumber, miscNodes);
                                calculate = true;
                                DOMUtil.setValueOfNode((Node)node, (String)request.getParameter(current));
                                continue;
                            }
                            if (!current.equals("portalcmd") || (cmds = request.getParameterValues(current)) == null || cmds.length <= 0) continue;
                            int i = 0;
                            while (i < cmds.length) {
                                if (cmds[i].equals("save")) {
                                    saveProfile = true;
                                } else if (this.modifyCoplet(cmds[i], context, theProfile, profile)) {
                                    calculate = true;
                                }
                                ++i;
                            }
                        }
                        if (calculate) {
                            this.setTypeInfo(profile, (List)theProfile.get("typePaths"), (List)theProfile.get("typeConfPaths"));
                        }
                        if ((statusChanged = theProfile.get("saveStatus")) != null) {
                            theProfile.remove("saveStatus");
                            this.saveUserStatusProfile(theProfile, this.getConfiguration(), this.getRole(profileID), this.getID(profileID));
                        }
                        if (saveProfile) {
                            String profileType;
                            String saveResource;
                            Map conf = this.getConfiguration();
                            String role = this.getRole(profileID);
                            String id = this.getID(profileID);
                            String type = this.getType(profileID);
                            if (type.equals("global")) {
                                saveResource = (String)conf.get("H");
                                profileType = "global-delta";
                            } else if (type.equals("role")) {
                                saveResource = (String)conf.get("K");
                                profileType = "role-delta";
                            } else if (type.equals("user")) {
                                saveResource = (String)conf.get("N");
                                profileType = "user-delta";
                            } else {
                                throw new ProcessingException("portal: No save resource defined for type '" + type + "'.");
                            }
                            NodeList statusNodes = DOMUtil.selectNodeList((Node)profile, (String)"profile/portal-profile/content/descendant::status/customize", (XPathProcessor)this.xpathProcessor);
                            if (statusNodes != null) {
                                int l = 0;
                                while (l < statusNodes.getLength()) {
                                    String value = DOMUtil.getValueOfNode((Node)statusNodes.item(l));
                                    if (value.equals("true")) {
                                        DOMUtil.setValueOfNode((Node)statusNodes.item(l), (String)"false");
                                    }
                                    ++l;
                                }
                            }
                            RequestState reqstate = this.getRequestState();
                            DocumentFragment delta = this.buildProfileDelta(type, role, id, this.getIsAdminProfile(profileID));
                            SourceParameters pars = new SourceParameters();
                            pars.setSingleParameterValue("type", profileType);
                            if (id != null) {
                                pars.setSingleParameterValue("ID", id);
                            }
                            if (role != null) {
                                pars.setSingleParameterValue("role", role);
                            }
                            pars.setSingleParameterValue("application", reqstate.getApplicationName());
                            pars.setSingleParameterValue("handler", reqstate.getHandlerName());
                            SourceUtil.writeDOM((String)saveResource, null, (SourceParameters)pars, (DocumentFragment)delta, (SourceResolver)this.resolver, (String)"xml");
                            if (delta.getParentNode() != null) {
                                delta.getParentNode().removeChild(delta);
                            }
                            delta = null;
                            this.cacheProfile(profileID, theProfile, conf);
                            this.cleanUpCache(type, role, conf);
                        }
                    }
                }
                catch (TransformerException local) {
                    throw new ProcessingException("TransformerException: " + local, (Throwable)local);
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END changeProfile");
        }
    }

    private void changeColumns(DocumentFragment profile, int oldNumber, int columnNumber, Node[] miscNodes) throws TransformerException {
        block6: {
            block5: {
                if (columnNumber >= oldNumber) break block5;
                Node firstColumn = DOMUtil.getSingleNode((Node)profile, (String)"profile/portal-profile/content/column[@position='1']/coplets", (XPathProcessor)this.xpathProcessor);
                NodeList firstColumnCoplets = DOMUtil.getNodeListFromPath((Node)firstColumn, (String[])new String[]{"coplet"});
                int copletsCount = firstColumnCoplets == null ? 0 : firstColumnCoplets.getLength();
                int i = columnNumber + 1;
                while (i <= oldNumber) {
                    Node columnNode = miscNodes[7 + i];
                    if (columnNode != null) {
                        NodeList coplets = DOMUtil.getNodeListFromPath((Node)columnNode, (String[])new String[]{"coplets", "coplet"});
                        if (coplets != null && coplets.getLength() > 0) {
                            int m = 0;
                            while (m < coplets.getLength()) {
                                Node coplet = coplets.item(m);
                                coplet.getParentNode().removeChild(coplet);
                                ((Element)coplet).setAttributeNS(null, "position", "" + ++copletsCount);
                                firstColumn.appendChild(coplet);
                                ++m;
                            }
                        }
                        columnNode.getParentNode().removeChild(columnNode);
                        miscNodes[7 + i] = null;
                    }
                    ++i;
                }
                break block6;
            }
            if (columnNumber > 5) break block6;
            Node contentNode = DOMUtil.getFirstNodeFromPath((Node)profile, (String[])new String[]{"profile", "portal-profile", "content"}, (boolean)false);
            Document doc = contentNode.getOwnerDocument();
            int i = oldNumber + 1;
            while (i <= columnNumber) {
                Element newColumn = doc.createElementNS(null, "column");
                newColumn.setAttributeNS(null, "position", "" + i);
                miscNodes[7 + i] = newColumn;
                contentNode.appendChild(newColumn);
                Element el = doc.createElementNS(null, "width");
                el.appendChild(doc.createTextNode("5%"));
                newColumn.appendChild(el);
                el = doc.createElementNS(null, "coplets");
                newColumn.appendChild(el);
                ++i;
            }
        }
    }

    protected void sendEvents(XMLConsumer consumer, Node node) throws SAXException {
        IncludeXMLConsumer.includeNode((Node)node, (ContentHandler)consumer, (LexicalHandler)consumer);
    }

    private Document getUsers(String role, String ID) throws IOException, ProcessingException, SAXException {
        Configuration child;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN getUsers role=" + role + ", ID=" + ID);
        }
        RequestState reqstate = this.getRequestState();
        Document frag = null;
        Configuration conf = reqstate.getModuleConfiguration("single-role-user-management");
        if (conf != null && (child = conf.getChild("load-users", false)) != null) {
            String loadUsersResource = child.getAttribute("uri", null);
            SourceParameters loadUsersResourceParameters = SourceParameters.create((Configuration)child);
            if (loadUsersResource != null) {
                SourceParameters parameters;
                SourceParameters sourceParameters = parameters = loadUsersResourceParameters == null ? new SourceParameters() : loadUsersResourceParameters;
                if (reqstate.getApplicationName() != null) {
                    parameters.setSingleParameterValue("application", reqstate.getApplicationName());
                }
                if (ID != null) {
                    parameters.setSingleParameterValue("type", "user");
                    parameters.setSingleParameterValue("ID", ID);
                } else {
                    parameters.setSingleParameterValue("type", "users");
                }
                if (role != null) {
                    parameters.setSingleParameterValue("role", role);
                }
                frag = this.loadResource(loadUsersResource, parameters);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END getUsers fragment=" + (frag == null ? "null" : XMLUtils.serializeNode(frag, (Properties)XMLUtils.createPropertiesForXML((boolean)false))));
        }
        return frag;
    }

    private Document getRoles() throws IOException, ProcessingException, SAXException {
        Configuration child;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN getRoles");
        }
        Document frag = null;
        RequestState reqstate = this.getRequestState();
        Configuration conf = reqstate.getModuleConfiguration("single-role-user-management");
        if (conf != null && (child = conf.getChild("load-roles", false)) != null) {
            String loadRolesResource = child.getAttribute("uri", null);
            SourceParameters loadRolesResourceParameters = SourceParameters.create((Configuration)child);
            if (loadRolesResource != null) {
                SourceParameters parameters;
                SourceParameters sourceParameters = parameters = loadRolesResourceParameters == null ? new SourceParameters() : loadRolesResourceParameters;
                if (reqstate.getApplicationName() != null) {
                    parameters.setSingleParameterValue("application", reqstate.getApplicationName());
                }
                parameters.setSingleParameterValue("type", "roles");
                frag = this.loadResource(loadRolesResource, parameters);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END getRoles fragment=" + frag);
        }
        return frag;
    }

    private Document loadResource(String resource, SourceParameters parameters) throws IOException, ProcessingException, SAXException {
        Document document;
        Source source = null;
        try {
            source = SourceUtil.getSource((String)resource, null, (SourceParameters)parameters, (SourceResolver)this.resolver);
            document = SourceUtil.toDOM((Source)source);
            Object var6_6 = null;
        }
        catch (SourceException se) {
            try {
                throw SourceUtil.handle((SourceException)se);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.resolver.release(source);
                throw throwable;
            }
        }
        this.resolver.release(source);
        return document;
    }

    protected SessionManager getSessionManager() throws ProcessingException {
        if (this.sessionManager == null) {
            try {
                this.sessionManager = (SessionManager)this.manager.lookup(SessionManager.ROLE);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Error during lookup of SessionManager component.", (Throwable)ce);
            }
        }
        return this.sessionManager;
    }

    protected ContextManager getContextManager() throws ProcessingException {
        if (this.contextManager == null) {
            try {
                this.contextManager = (ContextManager)this.manager.lookup(ContextManager.ROLE);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Error during lookup of ContextManager component.", (Throwable)ce);
            }
        }
        return this.contextManager;
    }

    protected TransactionManager getTransactionManager() throws ProcessingException {
        if (this.transactionManager == null) {
            try {
                this.transactionManager = (TransactionManager)this.manager.lookup(TransactionManager.ROLE);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Error during lookup of TransactionManager component.", (Throwable)ce);
            }
        }
        return this.transactionManager;
    }
}

