/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.cron;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.cron.ConfigurableCronJob;
import org.apache.cocoon.components.cron.CronJob;
import org.apache.cocoon.components.cron.JobScheduler;
import org.apache.cocoon.components.cron.JobSchedulerEntry;
import org.apache.cocoon.components.cron.QuartzJobSchedulerEntry;
import org.apache.cocoon.environment.Context;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.spi.JobStore;

public class QuartzJobScheduler
extends AbstractLogEnabled
implements JobScheduler,
Component,
ThreadSafe,
Serviceable,
Configurable,
Startable,
Disposable,
Contextualizable,
Initializable {
    private Context environmentContext;
    private static final String POLICY_RUN = "RUN";
    private static final String POLICY_WAIT = "WAIT";
    private static final String POLICY_ABORT = "ABORT";
    private static final String POLICY_DISCARD = "DISCARD";
    private static final String POLICY_DISCARD_OLDEST = "DISCARDOLDEST";
    static final String DATA_MAP_ROLE = "QuartzJobScheduler.ROLE";
    static final String DATA_MAP_OBJECT = "QuartzJobScheduler.Object";
    static final String DATA_MAP_NAME = "QuartzJobScheduler.JobName";
    static final String DATA_MAP_MANAGER = "QuartzJobScheduler.ServiceManager";
    static final String DATA_MAP_ENV_CONTEXT = "QuartzJobScheduler.EnvironmentContext";
    static final String DATA_MAP_LOGGER = "QuartzJobScheduler.Logger";
    static final String DATA_MAP_RUN_CONCURRENT = "QuartzJobScheduler.RunConcurrently";
    static final String DATA_MAP_PARAMETERS = "QuartzJobScheduler.Parameters";
    static final String DATA_MAP_OBJECTMAP = "QuartzJobScheduler.Map";
    static final String DATA_MAP_JOB_EXECUTION_CONTEXT = "QuartzJobScheduler.JobExecutionContext";
    static final String DEFAULT_QUARTZ_JOB_GROUP = "Cocoon";
    static final String DEFAULT_QUARTZ_SCHEDULER_NAME = "Cocoon";
    private PooledExecutor executor;
    private Scheduler scheduler;
    private ServiceManager manager;
    private Configuration config;
    private boolean m_shutdownGraceful;
    static /* synthetic */ Class class$org$apache$cocoon$components$cron$CronJob;
    static /* synthetic */ Class class$java$lang$Runnable;
    static /* synthetic */ Class class$org$quartz$Job;
    static /* synthetic */ Class class$org$apache$cocoon$components$cron$QuartzJobExecutor;

    public String[] getJobNames() {
        try {
            Object[] names = this.scheduler.getJobNames("Cocoon");
            Arrays.sort(names);
            return names;
        }
        catch (SchedulerException se) {
            this.getLogger().error("could not gather job names", (Throwable)se);
            return new String[0];
        }
    }

    public JobSchedulerEntry getJobSchedulerEntry(String jobname) {
        try {
            return new QuartzJobSchedulerEntry(jobname, this.scheduler);
        }
        catch (Exception e) {
            this.getLogger().error("cannot create QuartzJobSchedulerEntry", (Throwable)e);
            return null;
        }
    }

    public void addJob(String name, Object job, String cronSpec, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)DATA_MAP_OBJECT, job);
        this.addJob(name, jobDataMap, cronSpec, canRunConcurrently, params, objects);
    }

    public void addJob(String name, String jobrole, String cronSpec, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(DATA_MAP_ROLE, jobrole);
        this.addJob(name, jobDataMap, cronSpec, canRunConcurrently, params, objects);
    }

    public void addJob(String name, Object job, String cronSpec, boolean canRunConcurrently) throws CascadingException {
        if (!(job instanceof CronJob || job instanceof Runnable || job instanceof Job)) {
            throw new CascadingException("Job object is neither an instance of " + (class$org$apache$cocoon$components$cron$CronJob == null ? (class$org$apache$cocoon$components$cron$CronJob = QuartzJobScheduler.class$("org.apache.cocoon.components.cron.CronJob")) : class$org$apache$cocoon$components$cron$CronJob).getName() + "," + (class$java$lang$Runnable == null ? (class$java$lang$Runnable = QuartzJobScheduler.class$("java.lang.Runnable")) : class$java$lang$Runnable).getName() + " nor " + (class$org$quartz$Job == null ? (class$org$quartz$Job = QuartzJobScheduler.class$("org.quartz.Job")) : class$org$quartz$Job).getName());
        }
        this.addJob(name, job, cronSpec, canRunConcurrently, null, null);
    }

    public void addJob(String name, String jobrole, String cronSpec, boolean canRunConcurrently) throws CascadingException {
        this.addJob(name, jobrole, cronSpec, canRunConcurrently, null, null);
    }

    public void addPeriodicJob(String name, String jobrole, long period, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(DATA_MAP_ROLE, jobrole);
        long ms = period * 1000L;
        SimpleTrigger timeEntry = new SimpleTrigger(name, "Cocoon", new Date(System.currentTimeMillis() + ms), null, SimpleTrigger.REPEAT_INDEFINITELY, ms);
        this.addJob(name, jobDataMap, (Trigger)timeEntry, canRunConcurrently, params, objects);
    }

    public void addPeriodicJob(String name, Object job, long period, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        if (!(job instanceof CronJob || job instanceof Runnable || job instanceof Job)) {
            throw new CascadingException("Job object is neither an instance of " + (class$org$apache$cocoon$components$cron$CronJob == null ? (class$org$apache$cocoon$components$cron$CronJob = QuartzJobScheduler.class$("org.apache.cocoon.components.cron.CronJob")) : class$org$apache$cocoon$components$cron$CronJob).getName() + "," + (class$java$lang$Runnable == null ? (class$java$lang$Runnable = QuartzJobScheduler.class$("java.lang.Runnable")) : class$java$lang$Runnable).getName() + " nor " + (class$org$quartz$Job == null ? (class$org$quartz$Job = QuartzJobScheduler.class$("org.quartz.Job")) : class$org$quartz$Job).getName());
        }
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)DATA_MAP_OBJECT, job);
        long ms = period * 1000L;
        SimpleTrigger timeEntry = new SimpleTrigger(name, "Cocoon", new Date(System.currentTimeMillis() + ms), null, SimpleTrigger.REPEAT_INDEFINITELY, ms);
        this.addJob(name, jobDataMap, (Trigger)timeEntry, canRunConcurrently, params, objects);
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.config = config;
    }

    public void dispose() {
        try {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("shutting down scheduler " + (this.m_shutdownGraceful ? "graceful (waiting for running jobs to complete)" : "immediately (killing running jobs)"));
            }
            this.scheduler.shutdown(this.m_shutdownGraceful);
            this.scheduler = null;
        }
        catch (SchedulerException se) {
            this.getLogger().error("failure during scheduler shutdown", (Throwable)se);
        }
        this.executor = null;
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this.environmentContext = (Context)context.get((Object)"environment-context");
    }

    public void initialize() throws Exception {
        try {
            String runID = new Date().toString().replace(' ', '_');
            ThreadPool pool = this.createThreadPool(this.config.getChild("thread-pool"));
            DirectSchedulerFactory.getInstance().createScheduler("Cocoon", runID, (org.quartz.spi.ThreadPool)pool, (JobStore)new RAMJobStore());
            this.scheduler = DirectSchedulerFactory.getInstance().getScheduler("Cocoon");
        }
        catch (SchedulerException se) {
            throw new ConfigurationException("cannot create a quartz scheduler", (Throwable)se);
        }
        Configuration[] triggers = this.config.getChild("triggers").getChildren("trigger");
        this.createTriggers(triggers);
        this.config = null;
        if (this.getLogger().isDebugEnabled() && triggers.length == 0) {
            this.getLogger().debug("no triggers configured at startup");
        }
    }

    public boolean fireJob(Object job) {
        return this.fireJob(job.getClass().getName(), job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean fireJob(String jobrole) {
        boolean bl;
        Object job = null;
        try {
            job = this.manager.lookup(jobrole);
            bl = this.fireJob(jobrole, job);
            Object var5_5 = null;
        }
        catch (ServiceException se) {
            try {
                this.getLogger().error("cannot fire job " + jobrole, (Throwable)se);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.manager.release(job);
                throw throwable;
            }
            this.manager.release(job);
            return false;
        }
        this.manager.release(job);
        return bl;
    }

    public boolean fireJob(Object job, Parameters params, Map objects) throws CascadingException {
        if (job instanceof ConfigurableCronJob) {
            ((ConfigurableCronJob)job).setup(params, objects);
        }
        return this.fireJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean fireJob(String jobrole, Parameters params, Map objects) throws CascadingException {
        boolean bl;
        Object job = null;
        try {
            job = this.manager.lookup(jobrole);
            if (job instanceof ConfigurableCronJob) {
                ((ConfigurableCronJob)job).setup(params, objects);
            }
            bl = this.fireJob(jobrole, job);
            Object var7_7 = null;
        }
        catch (ServiceException se) {
            try {
                this.getLogger().error("cannot fire job " + jobrole, (Throwable)se);
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.manager.release(job);
                throw throwable;
            }
            this.manager.release(job);
            return false;
        }
        this.manager.release(job);
        return bl;
    }

    public void fireJobAt(Date date, String name, Object job) throws CascadingException {
        this.fireJobAt(date, name, job, null, null);
    }

    public void fireJobAt(Date date, String name, String jobrole) throws CascadingException {
        this.fireJobAt(date, name, jobrole, null, null);
    }

    public void fireJobAt(Date date, String name, Object job, Parameters params, Map objects) throws CascadingException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)DATA_MAP_OBJECT, job);
        this.addJob(name, jobDataMap, date, true, params, objects);
    }

    public void fireJobAt(Date date, String name, String jobrole, Parameters params, Map objects) throws CascadingException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(DATA_MAP_ROLE, jobrole);
        this.addJob(name, jobDataMap, date, true, params, objects);
    }

    public void removeJob(String name) throws NoSuchElementException {
        try {
            if (this.scheduler.deleteJob(name, "Cocoon")) {
                this.getLogger().info("job " + name + " removed by request");
            } else {
                this.getLogger().error("couldn't remove requested job " + name);
            }
        }
        catch (SchedulerException se) {
            this.getLogger().error("cannot remove job " + name, (Throwable)se);
            throw new NoSuchElementException(se.getMessage());
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void start() throws Exception {
        this.scheduler.start();
    }

    public void stop() throws Exception {
        this.scheduler.pause();
    }

    private void addJob(String name, JobDataMap jobDataMap, Date date, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        SimpleTrigger trigger = new SimpleTrigger(name, "Cocoon", date);
        this.addJob(name, jobDataMap, (Trigger)trigger, canRunConcurrently, params, objects);
    }

    private void addJob(String name, JobDataMap jobDataMap, String cronSpec, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        CronTrigger cronJobEntry = new CronTrigger(name, "Cocoon");
        try {
            cronJobEntry.setCronExpression(cronSpec);
        }
        catch (ParseException pe) {
            throw new CascadingException(pe.getMessage(), (Throwable)pe);
        }
        this.addJob(name, jobDataMap, (Trigger)cronJobEntry, canRunConcurrently, params, objects);
    }

    private void addJob(String name, JobDataMap jobDataMap, Trigger trigger, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        try {
            JobDetail jobdetail = this.scheduler.getJobDetail(name, "Cocoon");
            if (jobdetail != null) {
                this.removeJob(name);
            }
        }
        catch (SchedulerException se) {
            // empty catch block
        }
        jobDataMap.put(DATA_MAP_NAME, name);
        jobDataMap.put((Object)DATA_MAP_LOGGER, (Object)this.getLogger());
        jobDataMap.put((Object)DATA_MAP_MANAGER, (Object)this.manager);
        jobDataMap.put((Object)DATA_MAP_RUN_CONCURRENT, (Object)new Boolean(canRunConcurrently));
        jobDataMap.put((Object)DATA_MAP_ENV_CONTEXT, (Object)this.environmentContext);
        if (null != params) {
            jobDataMap.put((Object)DATA_MAP_PARAMETERS, (Object)params);
        }
        if (null != objects) {
            jobDataMap.put((Object)DATA_MAP_OBJECTMAP, (Object)objects);
        }
        JobDetail detail = new JobDetail(name, "Cocoon", class$org$apache$cocoon$components$cron$QuartzJobExecutor == null ? (class$org$apache$cocoon$components$cron$QuartzJobExecutor = QuartzJobScheduler.class$("org.apache.cocoon.components.cron.QuartzJobExecutor")) : class$org$apache$cocoon$components$cron$QuartzJobExecutor);
        detail.setJobDataMap(jobDataMap);
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Adding CronJob '" + trigger.getFullName() + "'");
        }
        try {
            this.scheduler.scheduleJob(detail, trigger);
        }
        catch (SchedulerException se) {
            throw new CascadingException(se.getMessage(), (Throwable)se);
        }
        if (this.getLogger().isDebugEnabled()) {
            if (trigger instanceof CronTrigger) {
                this.getLogger().debug("Time schedule summary:\n" + ((CronTrigger)trigger).getExpressionSummary());
            } else {
                this.getLogger().debug("Next scheduled time: " + trigger.getNextFireTime());
            }
        }
    }

    private ThreadPool createThreadPool(Configuration poolConfig) {
        boolean useQueueing = poolConfig.getChild("use-queueing").getValueAsBoolean(false);
        int queueSize = poolConfig.getChild("queue-size").getValueAsInteger(-1);
        this.executor = useQueueing ? (queueSize > 0 ? new PooledExecutor((Channel)new BoundedBuffer(queueSize)) : new PooledExecutor((Channel)new LinkedQueue())) : new PooledExecutor();
        int maxPoolSize = poolConfig.getChild("max-pool-size").getValueAsInteger(-1);
        if (maxPoolSize > 0) {
            this.executor.setMaximumPoolSize(maxPoolSize);
        } else {
            this.executor.setMaximumPoolSize(Integer.MAX_VALUE);
        }
        int minPoolSize = poolConfig.getChild("min-pool-size").getValueAsInteger(-1);
        if (minPoolSize > 0) {
            this.executor.setMinimumPoolSize(minPoolSize);
        } else {
            this.executor.setMinimumPoolSize(1);
        }
        int keepAliveTimeMs = poolConfig.getChild("keep-alive-time-ms").getValueAsInteger(-1);
        if (keepAliveTimeMs > 0) {
            this.executor.setKeepAliveTime((long)keepAliveTimeMs);
        } else {
            this.executor.setKeepAliveTime(60000L);
        }
        String blockPolicy = poolConfig.getChild("block-policy").getValue(null);
        if (blockPolicy != null) {
            if (blockPolicy.equalsIgnoreCase(POLICY_ABORT)) {
                this.executor.abortWhenBlocked();
            } else if (blockPolicy.equalsIgnoreCase(POLICY_DISCARD)) {
                this.executor.discardWhenBlocked();
            } else if (blockPolicy.equalsIgnoreCase(POLICY_DISCARD_OLDEST)) {
                this.executor.discardOldestWhenBlocked();
            } else if (blockPolicy.equalsIgnoreCase(POLICY_RUN)) {
                this.executor.runWhenBlocked();
            } else if (blockPolicy.equalsIgnoreCase(POLICY_WAIT)) {
                this.executor.waitWhenBlocked();
            } else {
                this.getLogger().warn("Unknown block-policy configuration '" + blockPolicy + "'. Should be one of '" + POLICY_ABORT + "','" + POLICY_DISCARD + "','" + POLICY_DISCARD_OLDEST + "','" + POLICY_RUN + "','" + POLICY_WAIT + "'. Will use '" + POLICY_RUN + "'");
            }
        }
        this.m_shutdownGraceful = poolConfig.getChild("shutdown-graceful").getValueAsBoolean(true);
        int shutdownWaitTimeMs = poolConfig.getChild("shutdown-wait-time-ms").getValueAsInteger(-1);
        ThreadPool pool = new ThreadPool(this.executor, shutdownWaitTimeMs);
        pool.enableLogging(this.getLogger());
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("using a PooledExecutor as ThreadPool with queueing=" + useQueueing + (useQueueing ? ",queue-size=" + (queueSize > 0 ? "" + queueSize : "default") : "") + ",max-pool-size=" + this.executor.getMaximumPoolSize() + ",min-pool-size=" + this.executor.getMinimumPoolSize() + ",keep-alive-time-ms=" + this.executor.getKeepAliveTime() + ",block-policy='" + blockPolicy + "',shutdown-wait-time-ms=" + (shutdownWaitTimeMs > 0 ? "" + shutdownWaitTimeMs : "default"));
        }
        return pool;
    }

    private void createTriggers(Configuration[] tiggers) throws ConfigurationException {
        int i = 0;
        while (i < tiggers.length) {
            String cron = tiggers[i].getChild("cron").getValue(null);
            if (null == cron) {
                String seconds = tiggers[i].getChild("seconds").getValue("0");
                String minutes = tiggers[i].getChild("minutes").getValue("*");
                String hours = tiggers[i].getChild("hours").getValue("*");
                String days = tiggers[i].getChild("days").getValue("*");
                String months = tiggers[i].getChild("months").getValue("*");
                String weekdays = tiggers[i].getChild("weekdays").getValue("?");
                String years = tiggers[i].getChild("years").getValue("*");
                cron = seconds + " " + minutes + " " + hours + " " + days + " " + months + " " + weekdays + " " + years;
            }
            try {
                this.addJob(tiggers[i].getAttribute("name"), tiggers[i].getAttribute("target"), cron, tiggers[i].getAttributeAsBoolean("concurrent-runs", true));
            }
            catch (CascadingException ce) {
                throw new ConfigurationException("failed adding trigger to scheduler", (Throwable)ce);
            }
            ++i;
        }
    }

    private boolean fireJob(final String name, final Object job) {
        try {
            if (job instanceof CronJob) {
                this.executor.execute(new Runnable(){

                    public void run() {
                        ((CronJob)job).execute(name);
                    }
                });
            } else if (job instanceof Runnable) {
                this.executor.execute((Runnable)job);
            } else {
                this.getLogger().error("job named '" + name + "' is of invalid class: " + job.getClass().getName());
                return false;
            }
            return true;
        }
        catch (InterruptedException ie) {
            this.getLogger().error("job " + name + " interrupted", (Throwable)ie);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ThreadPool
    extends AbstractLogEnabled
    implements org.quartz.spi.ThreadPool {
        private PooledExecutor executor;
        private int m_shutdownWaitTimeMs;

        public ThreadPool(PooledExecutor executor, int shutownWaitTimeMs) {
            this.executor = executor;
            this.m_shutdownWaitTimeMs = shutownWaitTimeMs;
        }

        public int getPoolSize() {
            return this.executor.getMaximumPoolSize();
        }

        public void initialize() {
        }

        public boolean runInThread(Runnable job) {
            try {
                this.executor.execute(job);
            }
            catch (InterruptedException ie) {
                this.getLogger().error("Cronjob failed", (Throwable)ie);
            }
            return true;
        }

        public void shutdown(boolean waitForJobsToComplete) {
            if (waitForJobsToComplete) {
                this.executor.shutdownAfterProcessingCurrentlyQueuedTasks();
            } else {
                this.executor.shutdownNow();
            }
            try {
                if (this.m_shutdownWaitTimeMs > 0 && !this.executor.awaitTerminationAfterShutdown((long)this.m_shutdownWaitTimeMs)) {
                    this.getLogger().warn("scheduled cron jobs are not terminating within " + this.m_shutdownWaitTimeMs + "ms, Will shut them down by interruption");
                    this.executor.interruptAll();
                    this.executor.shutdownNow();
                }
                this.executor.awaitTerminationAfterShutdown();
            }
            catch (InterruptedException ie) {
                this.getLogger().error("cannot shutdown Executor", (Throwable)ie);
            }
        }
    }
}

