/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.sql.Connection;
import org.apache.avalon.excalibur.datasource.JdbcConnectionFactory;
import org.apache.avalon.excalibur.datasource.NoAvailableConnectionException;
import org.apache.avalon.excalibur.datasource.PoolSettable;
import org.apache.avalon.excalibur.pool.DefaultPoolController;
import org.apache.avalon.excalibur.pool.HardResourceLimitingPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.PoolController;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;

public class JdbcConnectionPool
extends HardResourceLimitingPool
implements Runnable,
Disposable,
Initializable {
    private Exception m_cause = null;
    private Thread m_initThread;
    private final boolean m_autoCommit;
    private boolean m_noConnections;
    private long m_wait = -1L;
    private Object m_spinLock = new Object();

    public JdbcConnectionPool(JdbcConnectionFactory factory, DefaultPoolController controller, int min, int max, boolean autoCommit) throws Exception {
        super((ObjectFactory)factory, (PoolController)controller, max);
        this.m_min = min;
        this.m_initialized = false;
        this.m_autoCommit = autoCommit;
    }

    public void setTimeout(long timeout) {
        if (this.m_initialized) {
            throw new IllegalStateException("You cannot change the timeout after the pool is initialized");
        }
        this.m_wait = timeout;
    }

    public void initialize() {
        this.m_initThread = new Thread(this);
        this.m_initThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Poolable newPoolable() throws Exception {
        PoolSettable conn = null;
        if (this.m_wait < 1L) {
            conn = (PoolSettable)super.newPoolable();
        } else {
            long curMillis = System.currentTimeMillis();
            long endTime = curMillis + this.m_wait;
            while (null == conn && curMillis < endTime) {
                Object var11_6;
                Object var9_5;
                try {
                    this.unlock();
                    curMillis = System.currentTimeMillis();
                    Object object = this.m_spinLock;
                    synchronized (object) {
                        this.m_spinLock.wait(endTime - curMillis);
                    }
                    var9_5 = null;
                }
                catch (Throwable throwable) {
                    var9_5 = null;
                    this.lock();
                    throw throwable;
                }
                this.lock();
                try {
                    conn = (PoolSettable)super.newPoolable();
                    var11_6 = null;
                }
                catch (Throwable throwable) {
                    var11_6 = null;
                    throw throwable;
                }
            }
        }
        if (null == conn) {
            throw new NoAvailableConnectionException("All available connections are in use");
        }
        conn.setPool((Pool)this);
        return conn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Poolable get() throws Exception {
        PoolSettable obj;
        if (!this.m_initialized) {
            if (this.m_noConnections) {
                if (this.m_cause != null) {
                    throw this.m_cause;
                }
                throw new IllegalStateException("There are no connections in the pool, check your settings.");
            }
            if (this.m_initThread == null) {
                throw new IllegalStateException("You cannot get a Connection before the pool is initialized.");
            }
            this.m_initThread.join();
        }
        if ((obj = (PoolSettable)super.get()).isClosed()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("JdbcConnection was closed, creating one to take its place");
            }
            try {
                try {
                    this.lock();
                    if (this.m_active.contains(obj)) {
                        this.m_active.remove(obj);
                    }
                    this.removePoolable((Poolable)obj);
                    obj = (PoolSettable)this.newPoolable();
                    this.m_active.add(obj);
                }
                catch (Exception e) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Could not get an open connection", (Throwable)e);
                    }
                    throw e;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
        }
        if (((Connection)((Object)obj)).getAutoCommit() != this.m_autoCommit) {
            ((Connection)((Object)obj)).setAutoCommit(this.m_autoCommit);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Poolable obj) {
        super.put(obj);
        Object object = this.m_spinLock;
        synchronized (object) {
            this.m_spinLock.notifyAll();
        }
    }

    public void run() {
        block5: {
            try {
                this.grow(this.m_min);
                if (this.size() > 0) {
                    this.m_initialized = true;
                } else {
                    this.m_noConnections = true;
                    if (this.getLogger().isFatalErrorEnabled()) {
                        this.getLogger().fatalError("Excalibur could not create any connections.  Examine your settings to make sure they are correct.  Make sure you can connect with the same settings on your machine.");
                    }
                }
            }
            catch (Exception e) {
                this.m_cause = e;
                if (!this.getLogger().isWarnEnabled()) break block5;
                this.getLogger().warn("Caught an exception during initialization", (Throwable)e);
            }
        }
    }
}

