/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.transformation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.webapps.session.transformation.AbstractSessionTransformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.SourceParameters;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SessionPreTransformer
extends AbstractSessionTransformer {
    public static final String CREATECONTEXT_ELEMENT = "createcontext";
    public static final String CREATECONTEXT_NAME_ATTRIBUTE = "name";
    public static final String CREATECONTEXT_SAVE_ATTRIBUTE = "save";
    public static final String CREATECONTEXT_LOAD_ATTRIBUTE = "load";
    public static final String GETXML_ELEMENT = "getxml";
    public static final String GETXML_CONTEXT_ATTRIBUTE = "context";
    public static final String GETXML_PATH_ATTRIBUTE = "path";
    public static final String LOADCONTEXT_ELEMENT = "loadxml";
    public static final String LOADCONTEXT_CONTEXT_ATTRIBUTE = "context";
    public static final String LOADCONTEXT_PATH_ATTRIBUTE = "path";
    public static final String CONTEXT_URL_ELEMENT = "contexturl";
    protected int processingGetXML;

    public SessionPreTransformer() {
        this.namespaceURI = "http://apache.org/cocoon/session/1.0";
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.processingGetXML = 0;
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        super.endElement(uri, name, raw);
        if (uri != null && this.namespaceURI != null && uri.equals(this.namespaceURI) && this.processingGetXML > 0 && name.equals(GETXML_ELEMENT)) {
            --this.processingGetXML;
            --this.ignoreEventsCount;
            --this.ignoreHooksCount;
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (uri != null && this.namespaceURI != null && uri.equals(this.namespaceURI) && this.processingGetXML > 0 && name.equals(GETXML_ELEMENT)) {
            ++this.processingGetXML;
            ++this.ignoreEventsCount;
            ++this.ignoreHooksCount;
        }
        super.startElement(uri, name, raw, attr);
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN startTransformingElement uri=" + uri + ", name=" + name + ", raw=" + raw + ", attr=" + attr);
        }
        if (name.equals(CREATECONTEXT_ELEMENT)) {
            this.getContextManager().createContext(attr.getValue(CREATECONTEXT_NAME_ATTRIBUTE), attr.getValue(CREATECONTEXT_LOAD_ATTRIBUTE), attr.getValue(CREATECONTEXT_SAVE_ATTRIBUTE));
        } else if (name.equals(GETXML_ELEMENT)) {
            String path = attr.getValue("path");
            String contextName = attr.getValue("context");
            if (this.getSessionManager().streamContextFragment(contextName, path, (XMLConsumer)this)) {
                ++this.ignoreEventsCount;
                ++this.ignoreHooksCount;
                ++this.processingGetXML;
            }
        } else if (name.equals(LOADCONTEXT_ELEMENT)) {
            this.startParametersRecording();
            this.stack.push(attr.getValue("context"));
            if (attr.getValue("path") != null) {
                this.stack.push(attr.getValue("path"));
            } else {
                this.stack.push("/");
            }
        } else if (name.equals(CONTEXT_URL_ELEMENT)) {
            ++this.ignoreEventsCount;
        } else {
            super.startTransformingElement(uri, name, raw, attr);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END startTransformingElement");
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws ProcessingException, IOException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN endTransformingElement uri=" + uri + ", name=" + name + ", raw=" + raw);
        }
        if (!name.equals(CREATECONTEXT_ELEMENT) && !name.equals(GETXML_ELEMENT)) {
            if (name.equals(LOADCONTEXT_ELEMENT)) {
                String path = (String)this.stack.pop();
                String contextName = (String)this.stack.pop();
                SourceParameters pars = this.endParametersRecording(null);
                pars.setSingleParameterValue("contextname", contextName);
                pars.setSingleParameterValue("path", path);
                this.getContextManager().getContext(contextName).loadXML(path, pars);
            } else if (name.equals(CONTEXT_URL_ELEMENT)) {
                --this.ignoreEventsCount;
                String contextUrl = this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort() + this.request.getContextPath();
                this.sendTextEvent(contextUrl);
            } else {
                super.endTransformingElement(uri, name, raw);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END endTransformingElement");
        }
    }
}

