/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.flow.ContinuationsDisposer;

public class WebContinuation
extends AbstractLogEnabled
implements Comparable {
    protected Object continuation;
    protected WebContinuation parentContinuation;
    protected List children = new ArrayList();
    protected String id;
    protected Object userObject;
    protected long lastAccessTime;
    protected int timeToLive;
    protected ContinuationsDisposer disposer;

    WebContinuation(String id, Object continuation, WebContinuation parentContinuation, int timeToLive, ContinuationsDisposer disposer) {
        this.id = id;
        this.continuation = continuation;
        this.parentContinuation = parentContinuation;
        this.updateLastAccessTime();
        this.timeToLive = timeToLive;
        this.disposer = disposer;
        if (parentContinuation != null) {
            this.parentContinuation.children.add(this);
        }
    }

    public Object getContinuation() {
        this.updateLastAccessTime();
        return this.continuation;
    }

    public WebContinuation getContinuation(int level) {
        if (level <= 0) {
            this.updateLastAccessTime();
            return this;
        }
        if (this.parentContinuation == null) {
            return this;
        }
        return this.parentContinuation.getContinuation(level - 1);
    }

    public WebContinuation getParentContinuation() {
        return this.parentContinuation;
    }

    public List getChildren() {
        return this.children;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setUserObject(Object obj) {
        this.userObject = obj;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    ContinuationsDisposer getDisposer() {
        return this.disposer;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object another) {
        if (another instanceof WebContinuation) {
            return this.id.equals(((WebContinuation)another).id);
        }
        return false;
    }

    public int compareTo(Object other) {
        WebContinuation wk = (WebContinuation)other;
        return (int)(this.lastAccessTime + (long)this.timeToLive - (wk.lastAccessTime + (long)wk.timeToLive));
    }

    public void display() {
        this.getLogger().debug("\nWK: Tree" + this.display(0));
    }

    protected String display(int depth) {
        StringBuffer tree = new StringBuffer("\n");
        int i = 0;
        while (i < depth) {
            tree.append("  ");
            ++i;
        }
        tree.append("WK: WebContinuation ").append(this.id).append(" ExpireTime [");
        if (this.lastAccessTime + (long)this.timeToLive < System.currentTimeMillis()) {
            tree.append("Expired");
        } else {
            tree.append(this.lastAccessTime + (long)this.timeToLive);
        }
        tree.append("]");
        int size = this.children.size();
        ++depth;
        int i2 = 0;
        while (i2 < size) {
            tree.append(((WebContinuation)this.children.get(i2)).display(depth));
            ++i2;
        }
        return tree.toString();
    }

    protected void updateLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean hasExpired() {
        long expireTime;
        long currentTime = System.currentTimeMillis();
        return currentTime > (expireTime = this.getLastAccessTime() + (long)this.timeToLive);
    }

    public void dispose() {
        if (this.disposer != null) {
            this.disposer.disposeContinuation(this);
        }
        this.continuation = null;
    }

    public boolean disposed() {
        return this.continuation == null;
    }
}

