/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.LinkedProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.AggregateNode;
import org.apache.cocoon.components.treeprocessor.sitemap.SitemapLanguage;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;

public class AggregateNodeBuilder
extends AbstractProcessingNodeBuilder
implements LinkedProcessingNodeBuilder {
    private Collection views;
    private AggregateNode node;

    public ProcessingNode buildNode(Configuration config) throws Exception {
        this.node = new AggregateNode(VariableResolverFactory.getResolver(config.getAttribute("element"), this.manager), VariableResolverFactory.getResolver(config.getAttribute("ns", ""), this.manager), VariableResolverFactory.getResolver(config.getAttribute("prefix", ""), this.manager));
        this.treeBuilder.setupNode(this.node, config);
        this.views = ((SitemapLanguage)this.treeBuilder).getViewsForStatement("", "", config);
        if (this.views == null) {
            this.views = new HashSet();
        }
        SitemapLanguage sitemap = (SitemapLanguage)this.treeBuilder;
        ArrayList<AggregateNode.Part> allParts = new ArrayList<AggregateNode.Part>();
        HashMap<String, ArrayList<AggregateNode.Part>> viewParts = new HashMap<String, ArrayList<AggregateNode.Part>>();
        Configuration[] childConfigs = config.getChildren();
        int i = 0;
        while (i < childConfigs.length) {
            Configuration childConfig = childConfigs[i];
            if (!"part".equals(childConfig.getName())) {
                String msg = "Unknown element '" + childConfig.getName() + " in aggregate ' at " + childConfig.getLocation();
                throw new ConfigurationException(msg);
            }
            this.checkNamespace(childConfig);
            AggregateNode.Part currentPart = new AggregateNode.Part(VariableResolverFactory.getResolver(childConfig.getAttribute("src"), this.manager), VariableResolverFactory.getResolver(childConfig.getAttribute("element", ""), this.manager), VariableResolverFactory.getResolver(childConfig.getAttribute("ns", ""), this.manager), VariableResolverFactory.getResolver(childConfig.getAttribute("prefix", ""), this.manager), VariableResolverFactory.getResolver(childConfig.getAttribute("strip-root", "false"), this.manager));
            allParts.add(currentPart);
            Collection viewsForPart = sitemap.getViewsForStatement("", "", childConfig);
            if (viewsForPart != null) {
                this.views.addAll(viewsForPart);
                Iterator iter = viewsForPart.iterator();
                while (iter.hasNext()) {
                    String currentView = (String)iter.next();
                    ArrayList<AggregateNode.Part> currentViewParts = (ArrayList<AggregateNode.Part>)viewParts.get(currentView);
                    if (currentViewParts == null) {
                        currentViewParts = new ArrayList<AggregateNode.Part>();
                        viewParts.put(currentView, currentViewParts);
                    }
                    currentViewParts.add(currentPart);
                }
            }
            ++i;
        }
        if (allParts.size() == 0) {
            String msg = "There must be at least one part in map:aggregate at " + config.getLocation();
            throw new ConfigurationException(msg);
        }
        AggregateNode.Part[] allPartsArray = allParts.toArray(new AggregateNode.Part[allParts.size()]);
        Iterator iter = viewParts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Collection coll = (Collection)entry.getValue();
            entry.setValue(coll.toArray(new AggregateNode.Part[coll.size()]));
        }
        this.node.setParts(allPartsArray, viewParts);
        return this.node;
    }

    public void linkNode() throws Exception {
        SitemapLanguage sitemap = (SitemapLanguage)this.treeBuilder;
        this.node.setViewNodes(sitemap.getViewNodes(this.views));
    }
}

