/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.environment.AbstractEnvironment;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.wrapper.RequestWrapper;
import org.apache.cocoon.util.BufferedOutputStream;

public class EnvironmentWrapper
extends AbstractEnvironment
implements Environment {
    protected Environment environment;
    protected Map objectModel;
    protected String redirectURL;
    protected Request request;
    protected String lastContext;
    protected String lastPrefix;
    protected String lastURI;
    protected OutputStream outputStream;
    protected String contentType;
    protected boolean internalRedirect = false;

    public EnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger) throws MalformedURLException {
        this(env, requestURI, queryString, logger, false);
    }

    public EnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger, boolean rawMode) throws MalformedURLException {
        this(env, requestURI, queryString, logger, null, rawMode);
    }

    public EnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger, ComponentManager manager, boolean rawMode) throws MalformedURLException {
        this(env, requestURI, queryString, logger, null, rawMode, env.getView());
    }

    public EnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger, ComponentManager manager, boolean rawMode, String view) throws MalformedURLException {
        super(env.getURI(), view, env.getContext(), env.getAction());
        this.init(env, requestURI, queryString, logger, manager, rawMode, view);
    }

    private void init(Environment env, String requestURI, String queryString, Logger logger, ComponentManager manager, boolean rawMode, String view) throws MalformedURLException {
        this.rootContext = env.getRootContext();
        this.enableLogging(logger);
        this.environment = env;
        this.view = view;
        this.prefix = new StringBuffer(env.getURIPrefix());
        Map oldObjectModel = env.getObjectModel();
        if (oldObjectModel instanceof HashMap) {
            this.objectModel = (Map)((HashMap)oldObjectModel).clone();
        } else {
            this.objectModel = new HashMap(oldObjectModel.size() * 2);
            Iterator entries = oldObjectModel.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                this.objectModel.put(entry.getKey(), entry.getValue());
            }
        }
        this.request = new RequestWrapper(ObjectModelHelper.getRequest(oldObjectModel), requestURI, queryString, this, rawMode);
        this.objectModel.put("request", this.request);
    }

    public EnvironmentWrapper(Environment env, ComponentManager manager, String uri, Logger logger) throws MalformedURLException {
        super(env.getURI(), env.getView(), env.getContext(), env.getAction());
        String tmp;
        int index;
        String prefix;
        boolean rawMode = false;
        int position = uri.indexOf(58) + 1;
        if (position != 0) {
            if (uri.startsWith("raw:", position)) {
                position += 4;
                rawMode = true;
            }
        } else {
            throw new MalformedURLException("No protocol found for sitemap source in " + uri);
        }
        if (uri.startsWith("//", position)) {
            position += 2;
            prefix = "";
        } else if (uri.startsWith("/", position)) {
            ++position;
            prefix = null;
        } else {
            throw new MalformedURLException("Malformed cocoon URI: " + uri);
        }
        String queryString = null;
        int queryStringPos = uri.indexOf(63, position);
        if (queryStringPos != -1) {
            queryString = uri.substring(queryStringPos + 1);
            uri = uri.substring(position, queryStringPos);
        } else if (position > 0) {
            uri = uri.substring(position);
        }
        String view = null;
        view = queryString != null ? ((index = queryString.indexOf("cocoon-view")) != -1 && (index == 0 || queryString.charAt(index - 1) == '&') && queryString.length() > index + "cocoon-view".length() && queryString.charAt(index + "cocoon-view".length()) == '=' ? ((index = (tmp = queryString.substring(index + "cocoon-view".length() + 1)).indexOf(38)) != -1 ? tmp.substring(0, index) : tmp) : env.getView()) : env.getView();
        String requestURI = prefix == null ? env.getURIPrefix() + uri : uri;
        this.init(env, requestURI, queryString, logger, manager, rawMode, view);
        this.setURI(prefix, uri);
    }

    public void redirect(boolean sessionmode, String newURL) throws IOException {
        this.redirectURL = newURL;
        if (sessionmode) {
            this.request.getSession(true);
        }
    }

    public void globalRedirect(boolean sessionmode, String newURL) throws IOException {
        if (this.environment instanceof EnvironmentWrapper) {
            ((EnvironmentWrapper)this.environment).globalRedirect(sessionmode, newURL);
        } else {
            this.environment.redirect(sessionmode, newURL);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outputStream == null ? this.environment.getOutputStream() : this.outputStream;
    }

    public OutputStream getOutputStream(int bufferSize) throws IOException {
        return this.outputStream == null ? this.environment.getOutputStream(bufferSize) : this.outputStream;
    }

    public void setOutputStream(OutputStream stream) {
        this.outputStream = stream;
    }

    public boolean tryResetResponse() throws IOException {
        if (this.getOutputStream() != null && this.getOutputStream() instanceof BufferedOutputStream) {
            ((BufferedOutputStream)this.getOutputStream()).clearBuffer();
            return true;
        }
        return super.tryResetResponse();
    }

    public void commitResponse() throws IOException {
        if (this.getOutputStream() != null && this.getOutputStream() instanceof BufferedOutputStream) {
            ((BufferedOutputStream)this.getOutputStream()).realFlush();
        } else {
            super.commitResponse();
        }
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void reset() {
        this.redirectURL = null;
    }

    public void setStatus(int statusCode) {
    }

    public void setContentLength(int length) {
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map getObjectModel() {
        return this.objectModel;
    }

    public void setURI(String prefix, String uris) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting uri (prefix=" + prefix + ", uris=" + uris + ")");
        }
        if (!this.initializedComponents) {
            this.initComponents();
        }
        if (prefix != null) {
            this.setContext(this.getRootContext());
            this.setURIPrefix(prefix);
        }
        this.uris = uris;
        this.lastURI = uris;
        this.lastContext = this.context;
        this.lastPrefix = this.prefix.toString();
    }

    public void changeContext(String prefix, String context) throws IOException {
        super.changeContext(prefix, context);
        this.lastContext = this.context;
        this.lastPrefix = this.prefix.toString();
        this.lastURI = this.uris;
    }

    public void changeToLastContext() {
        this.setContext(this.lastContext);
        this.setURIPrefix(this.lastPrefix);
        this.uris = this.lastURI;
    }

    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        if (value == null) {
            value = this.environment.getAttribute(name);
        }
        return value;
    }

    public void removeAttribute(String name) {
        super.removeAttribute(name);
        this.environment.removeAttribute(name);
    }

    public boolean isExternal() {
        return false;
    }

    public void setInternalRedirect(boolean flag) {
        this.internalRedirect = flag;
        if (flag) {
            ((RequestWrapper)this.request).setRequestURI(this.prefix.toString(), this.uris);
        }
    }

    public boolean isInternalRedirect() {
        return this.internalRedirect;
    }
}

