/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.extended;

import java.io.Serializable;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.extended.BeginOfText;
import net.sourceforge.chaperon.model.extended.Definition;
import net.sourceforge.chaperon.model.extended.EndOfText;
import net.sourceforge.chaperon.model.extended.Pattern;
import net.sourceforge.chaperon.model.extended.PatternIterator;
import net.sourceforge.chaperon.model.extended.PatternSet;

public class ExtendedGrammar
implements Serializable,
Cloneable {
    private String startSymbol = null;
    private Definition[] definitions = new Definition[0];
    private String location = null;
    private BeginOfText BOT = new BeginOfText();
    private EndOfText EOT = new EndOfText();

    public void addDefinition(Definition definition) {
        if (definition == null) {
            throw new NullPointerException();
        }
        PatternIterator i = definition.getAllPattern().getPattern();
        while (i.hasNext()) {
            Pattern pattern = i.next();
            pattern.setDefinition(definition);
        }
        Definition[] newDefinitions = new Definition[this.definitions.length + 1];
        System.arraycopy(this.definitions, 0, newDefinitions, 0, this.definitions.length);
        newDefinitions[this.definitions.length] = definition;
        this.definitions = newDefinitions;
    }

    public Definition getDefinition(int index) {
        return this.definitions[index];
    }

    public Definition getDefinition(String symbol) {
        int i = 0;
        while (i < this.definitions.length) {
            if (this.definitions[i].getSymbol().equals(symbol)) {
                return this.definitions[i];
            }
            ++i;
        }
        return null;
    }

    public Definition[] getDefinitions() {
        return this.definitions;
    }

    public int getDefinitionCount() {
        return this.definitions.length;
    }

    public PatternSet getAllPattern() {
        PatternSet set = new PatternSet();
        int i = 0;
        while (i < this.definitions.length) {
            set.addPattern(this.definitions[i].getAllPattern());
            ++i;
        }
        set.addPattern(this.BOT);
        set.addPattern(this.EOT);
        return set;
    }

    public void update() {
        int i = 0;
        while (i < this.definitions.length) {
            this.definitions[i].update();
            ++i;
        }
        this.updateAscendingSuccessors();
        this.updateDescendingSuccessors();
    }

    public void updateAscendingSuccessors() {
        boolean modified;
        PatternIterator successors = this.getFirstSet(this.getStartSymbol()).getPattern();
        while (successors.hasNext()) {
            Pattern succesor = successors.next();
            this.BOT.addAscendingSuccessor(succesor);
        }
        do {
            modified = false;
            PatternIterator successors2 = this.getAllPattern().getPattern();
            while (successors2.hasNext()) {
                Pattern successor = successors2.next();
                if (successor.getSymbol() == null) continue;
                PatternSet firstSet = this.getFirstSet(successor.getSymbol());
                PatternIterator ancestors = successor.getAncestors();
                while (ancestors.hasNext()) {
                    Pattern ancestor = ancestors.next();
                    PatternIterator i = firstSet.getPattern();
                    while (i.hasNext()) {
                        Pattern firstPattern = i.next();
                        modified |= ancestor.addAscendingSuccessor(firstPattern);
                    }
                }
                PatternIterator ancestors2 = successor.getAscendingAncestors();
                while (ancestors2.hasNext()) {
                    Pattern ancestor = ancestors2.next();
                    PatternIterator i = firstSet.getPattern();
                    while (i.hasNext()) {
                        Pattern firstPattern = i.next();
                        modified |= ancestor.addAscendingSuccessor(firstPattern);
                    }
                }
            }
        } while (modified);
    }

    public boolean isNullable(String symbol) {
        int i = 0;
        while (i < this.definitions.length) {
            if (this.definitions[i].getSymbol().equals(symbol)) {
                return this.definitions[i].isNullable();
            }
            ++i;
        }
        return true;
    }

    public PatternSet getFirstSet(String symbol) {
        PatternSet firstSet = new PatternSet();
        int i = 0;
        while (i < this.definitions.length) {
            if (this.definitions[i].getSymbol().equals(symbol)) {
                PatternIterator firstPattern = this.definitions[i].getFirstPattern();
                while (firstPattern.hasNext()) {
                    firstSet.addPattern(firstPattern.next());
                }
            }
            ++i;
        }
        return firstSet;
    }

    public PatternSet getFirstSet() {
        return this.getFirstSet(this.getStartSymbol());
    }

    public PatternSet getLastSet(String symbol) {
        PatternSet lastSet = new PatternSet();
        int i = 0;
        while (i < this.definitions.length) {
            if (this.definitions[i].getSymbol().equals(symbol)) {
                PatternIterator lastPattern = this.definitions[i].getLastPattern();
                while (lastPattern.hasNext()) {
                    lastSet.addPattern(lastPattern.next());
                }
            }
            ++i;
        }
        return lastSet;
    }

    public PatternSet getLastSet() {
        return this.getLastSet(this.getStartSymbol());
    }

    public void updateDescendingSuccessors() {
        boolean modified;
        PatternIterator ancestors = this.getLastSet(this.getStartSymbol()).getPattern();
        while (ancestors.hasNext()) {
            Pattern ancestor = ancestors.next();
            ancestor.addDescendingSuccessor(this.EOT);
        }
        do {
            modified = false;
            PatternIterator ancestors2 = this.getAllPattern().getPattern();
            while (ancestors2.hasNext()) {
                Pattern ancestor = ancestors2.next();
                if (ancestor.getSymbol() != null) {
                    PatternIterator pattern = this.getLastSet(ancestor.getSymbol()).getPattern();
                    while (pattern.hasNext()) {
                        Pattern lastPattern = pattern.next();
                        PatternIterator successors = ancestor.getSuccessors();
                        while (successors.hasNext()) {
                            Pattern successor = successors.next();
                            if (lastPattern == successor && lastPattern.hasSuccessor(successor)) continue;
                            modified |= lastPattern.addDescendingSuccessor(successor);
                        }
                        PatternIterator successors2 = ancestor.getAscendingSuccessors();
                        while (successors2.hasNext()) {
                            Pattern successor = successors2.next();
                            if (lastPattern == successor && lastPattern.hasDescendingSuccessor(successor)) continue;
                            modified |= lastPattern.addDescendingSuccessor(successor);
                        }
                        PatternIterator successors3 = ancestor.getDescendingSuccessors();
                        while (successors3.hasNext()) {
                            Pattern successor = successors3.next();
                            if (lastPattern == successor && lastPattern.hasDescendingSuccessor(successor)) continue;
                            modified |= lastPattern.addDescendingSuccessor(successor);
                        }
                    }
                }
                PatternIterator successors = ancestor.getDescendingSuccessors();
                while (successors.hasNext()) {
                    Pattern successor = successors.next();
                    if (successor.getSymbol() == null || !this.isNullable(successor.getSymbol())) continue;
                    PatternIterator i = successor.getSuccessors();
                    while (i.hasNext()) {
                        Pattern follow = i.next();
                        modified |= ancestor.addDescendingSuccessor(follow);
                    }
                    PatternIterator i2 = successor.getAscendingSuccessors();
                    while (i2.hasNext()) {
                        Pattern follow = i2.next();
                        modified |= ancestor.addDescendingSuccessor(follow);
                    }
                    PatternIterator i3 = successor.getDescendingSuccessors();
                    while (i3.hasNext()) {
                        Pattern follow = i3.next();
                        modified |= ancestor.addDescendingSuccessor(follow);
                    }
                }
            }
        } while (modified);
    }

    public void setStartSymbol(String symbol) {
        this.startSymbol = symbol;
    }

    public String getStartSymbol() {
        return this.startSymbol;
    }

    public Pattern getStartPattern() {
        return this.BOT;
    }

    public Pattern getEndPattern() {
        return this.EOT;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.startSymbol == null) {
            violations.addViolation("Start symbol is not defined", this.location);
        }
        if (this.getDefinition(this.startSymbol) == null) {
            violations.addViolation("Start symbol \"" + this.startSymbol + "\"" + "is not defined through a definition", this.location);
        }
        if (this.getDefinitionCount() <= 0) {
            violations.addViolation("No definitions are defined", this.location);
        }
        int i = 0;
        while (i < this.definitions.length) {
            violations.addViolations(this.definitions[i].validate());
            ++i;
        }
        return violations;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Definitions:\n");
        int i = 0;
        while (i < this.getDefinitionCount()) {
            buffer.append(String.valueOf(i));
            buffer.append(".Definition: ");
            buffer.append(this.definitions[i]);
            buffer.append(" ");
            buffer.append("\n");
            ++i;
        }
        buffer.append("\n");
        return buffer.toString();
    }

    public String toString(PatternSet previous, PatternSet next) {
        boolean first = true;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.getDefinitionCount()) {
            PatternSet pattern = this.definitions[i].getAllPattern();
            boolean found = false;
            PatternIterator previousPattern = previous.getPattern();
            while (previousPattern.hasNext() && !found) {
                found |= pattern.contains(previousPattern.next());
            }
            PatternIterator nextPattern = next.getPattern();
            while (nextPattern.hasNext() && !found) {
                found |= pattern.contains(nextPattern.next());
            }
            if (found) {
                if (!first) {
                    buffer.append("\n");
                }
                buffer.append(this.definitions[i].toString(previous, next));
                first = false;
            }
            ++i;
        }
        return buffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        ExtendedGrammar clone = new ExtendedGrammar();
        clone.startSymbol = this.startSymbol;
        int i = 0;
        while (i < this.definitions.length) {
            clone.addDefinition((Definition)this.definitions[i].clone());
            ++i;
        }
        clone.location = this.location;
        return clone;
    }
}

