/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.text.AttributedCharacterIterator;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGFontElementBridge;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGFontFamily
implements GVTFontFamily {
    protected GVTFontFace fontFace;
    protected Element fontElement;
    protected BridgeContext ctx;
    protected Boolean complex = null;

    public SVGFontFamily(GVTFontFace gVTFontFace, Element element, BridgeContext bridgeContext) {
        this.fontFace = gVTFontFace;
        this.fontElement = element;
        this.ctx = bridgeContext;
    }

    public String getFamilyName() {
        return this.fontFace.getFamilyName();
    }

    public GVTFontFace getFontFace() {
        return this.fontFace;
    }

    public GVTFont deriveFont(float f, AttributedCharacterIterator attributedCharacterIterator) {
        SVGFontElementBridge sVGFontElementBridge = (SVGFontElementBridge)this.ctx.getBridge(this.fontElement);
        Element element = (Element)attributedCharacterIterator.getAttributes().get(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
        return sVGFontElementBridge.createFont(this.ctx, this.fontElement, element, f, this.fontFace);
    }

    public boolean isComplex() {
        if (this.complex != null) {
            return this.complex;
        }
        boolean bl = SVGFontFamily.isComplex(this.fontElement, this.ctx);
        this.complex = new Boolean(bl);
        return bl;
    }

    public static boolean isComplex(Element element, BridgeContext bridgeContext) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/svg", "glyph");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element element3;
                Bridge bridge;
                if (node.getNodeType() != 1 || (bridge = bridgeContext.getBridge(element3 = (Element)node)) == null || !(bridge instanceof GraphicsNodeBridge)) continue;
                return true;
            }
        }
        return false;
    }
}

