/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.NetUtils;

public class LinkTranslatorMapAction
extends ServiceableAction
implements ThreadSafe {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> linkObjectMap = (HashMap<String, String>)objectModel.get("link");
        String[] parameterNames = parameters.getNames();
        int i = 0;
        while (i < parameterNames.length) {
            String parameterName = parameterNames[i];
            String LINK_MAP_PREFIX = "linkMap:";
            if (parameterName.startsWith("linkMap:")) {
                String linkKey = parameterName.substring("linkMap:".length());
                String linkValue = parameters.getParameter(parameterName, null);
                if (linkValue != null) {
                    if (linkObjectMap == null) {
                        linkObjectMap = new HashMap<String, String>();
                        objectModel.put("link", linkObjectMap);
                    }
                    this.getLogger().debug("Add mapping from " + String.valueOf(linkKey) + " to " + String.valueOf(linkValue));
                    linkObjectMap.put(linkKey, linkValue);
                }
            }
            ++i;
        }
        String base = parameters.getParameter("url-base", "");
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String requestURI = request.getRequestURI();
        String extension = NetUtils.getExtension((String)requestURI);
        String path = NetUtils.getPath((String)requestURI);
        this.getLogger().debug("LinkMapTranslator 1 path " + String.valueOf(path));
        path = path + base;
        this.getLogger().debug("LinkMapTranslator 2 path " + String.valueOf(path));
        path = NetUtils.normalize((String)path);
        this.getLogger().debug("LinkMapTranslator 3 path " + String.valueOf(path) + ", " + "base " + String.valueOf(base) + ", " + "ext " + String.valueOf(extension));
        if (extension != null) {
            LinkPatternHashMap lphm = new LinkPatternHashMap(path, extension);
            lphm.setParent(linkObjectMap);
            lphm.enableLogging(this.getLogger());
            objectModel.put("link", lphm);
        }
        return null;
    }

    public static class LinkPatternHashMap
    extends HashMap
    implements LogEnabled {
        Logger logger;
        String pageExtension;
        String path;
        Map parent;

        public LinkPatternHashMap(String path, String pageExtension) {
            this.pageExtension = pageExtension;
            this.path = path;
            this.parent = null;
        }

        public void setParent(Map parent) {
            this.parent = parent;
        }

        public Object get(Object key) {
            String newHref = null;
            if (key instanceof String) {
                int pathLength;
                String keyString = (String)key;
                String PAGE_SCHEMA = "page:";
                int PAGE_SCHEMA_LENGTH = "page:".length();
                if (keyString.startsWith("page:")) {
                    String strippedPageSchema = keyString.substring(PAGE_SCHEMA_LENGTH);
                    newHref = strippedPageSchema + this.pageExtension;
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("href " + String.valueOf(keyString) + " mapped to " + String.valueOf(newHref));
                    }
                }
                if (newHref == null && (newHref = (String)super.get(key)) == null && this.parent != null) {
                    newHref = (String)this.parent.get(key);
                }
                if (newHref == null) {
                    newHref = keyString;
                }
                this.logger.debug("newHref " + String.valueOf(newHref) + ", " + " path " + String.valueOf(this.path));
                if (newHref.startsWith(this.path) && (newHref = newHref.substring(pathLength = this.path.length())).startsWith("/") && newHref.length() > 1) {
                    newHref = newHref.substring(1);
                }
                this.logger.debug("newHref stripped " + String.valueOf(newHref));
            }
            String result = null;
            if (newHref != null) {
                result = newHref;
            } else {
                result = (String)super.get(key);
                if (result == null && this.parent != null) {
                    result = this.parent.get(key);
                }
            }
            this.logger.debug("For key " + String.valueOf(key) + " result is " + String.valueOf(result));
            return result;
        }

        public void enableLogging(Logger logger) {
            this.logger = logger;
        }
    }
}

