/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.caching.IdentifierCacheKey;
import org.apache.cocoon.components.cron.CronJob;
import org.apache.cocoon.components.cron.JobScheduler;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.Refresher;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.ContentHandler;

public class DelayRefresher
extends AbstractLogEnabled
implements Contextualizable,
Serviceable,
Parameterizable,
Disposable,
ThreadSafe,
Refresher,
CronJob {
    private static final String PARAM_CACHE_ROLE = "cache-role";
    private static final String PARAM_CACHE_EXPIRES = "cache-expires";
    private static final String PARAM_UPDATE_TARGET_ROLE = "update-target-role";
    private static final String PARAM_WRITE_INTERVAL = "write-interval";
    private static final String PARAM_WRITE_FILE = "write-file";
    private static final String DEFAULT_WRITE_FILE = "refresher-targets.xml";
    private static final String CACHE_KEY = "cache-key";
    private static final String TAGNAME_TARGET = "target";
    private static final String ATTR_CACHE = "cache";
    private static final String ATTR_EXPIRES = "expires";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_URI = "uri";
    protected ServiceManager manager;
    protected SourceResolver resolver;
    protected JobScheduler scheduler;
    protected String updateTarget;
    protected Map entries = Collections.synchronizedMap(new HashMap());
    protected File workDir;
    protected Source writeSource;
    protected boolean changed = false;

    public void contextualize(Context context) throws ContextException {
        this.workDir = (File)context.get((Object)"work-directory");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.scheduler = (JobScheduler)this.manager.lookup(JobScheduler.ROLE);
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.updateTarget = parameters.getParameter(PARAM_UPDATE_TARGET_ROLE, CronJob.ROLE + "/UpdateTarget");
        int writeInterval = parameters.getParameterAsInteger(PARAM_WRITE_INTERVAL, 0);
        if (writeInterval > 0) {
            this.setupRefreshJobSource(parameters);
            Configuration conf = this.readRefreshJobConfiguration();
            this.setupRefreshJobs(conf);
            this.registerSelfWithScheduler(writeInterval);
        } else if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Not writing update targets to file.");
        }
    }

    public void dispose() {
        this.execute(null);
        if (this.manager != null) {
            this.manager.release((Object)this.scheduler);
            this.scheduler = null;
            if (this.resolver != null) {
                this.resolver.release(this.writeSource);
                this.writeSource = null;
                this.manager.release((Object)this.resolver);
                this.resolver = null;
            }
            this.manager = null;
        }
    }

    public void refresh(IdentifierCacheKey cacheKey, String uri, String cacheRole, Parameters parameters) throws SourceException {
        String name = cacheKey.getKey();
        int expires = parameters.getParameterAsInteger(PARAM_CACHE_EXPIRES, -1);
        if (expires > 0) {
            TargetConfiguration conf = (TargetConfiguration)this.entries.get(name);
            if (conf == null) {
                conf = new TargetConfiguration(cacheKey, uri, cacheRole, parameters);
                try {
                    this.scheduler.addPeriodicJob(name, this.updateTarget, (long)expires, true, conf.parameters, conf.map);
                }
                catch (CascadingException e) {
                    throw new SourceException("Failure scheduling update job.", (Throwable)e);
                }
                this.entries.put(name, conf);
            } else {
                conf.update(uri, cacheRole, parameters);
            }
            this.changed = true;
        }
    }

    public void execute(String name) {
        block3: {
            if (!this.changed || this.writeSource == null) break block3;
            this.changed = false;
            try {
                OutputStream stream = ((ModifiableSource)this.writeSource).getOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(stream);
                writer.write("<targets>\n");
                Iterator iter = this.entries.values().iterator();
                while (iter.hasNext()) {
                    this.writeRefreshJobConfiguration(writer, (TargetConfiguration)iter.next());
                }
                writer.write("</targets>\n");
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException e) {
                if (!this.getLogger().isDebugEnabled()) break block3;
                this.getLogger().debug("Error writing targets to file.", (Throwable)e);
            }
        }
    }

    private void registerSelfWithScheduler(int writeInterval) {
        block2: {
            try {
                this.scheduler.addPeriodicJob(this.getClass().getName(), (Object)this, (long)writeInterval, true, null, null);
            }
            catch (CascadingException ignore) {
                if (!this.getLogger().isDebugEnabled()) break block2;
                this.getLogger().debug("Registering self with scheduler, ignoring exception:", (Throwable)ignore);
            }
        }
    }

    private void setupRefreshJobs(Configuration conf) {
        Configuration[] childs;
        if (conf != null && (childs = conf.getChildren(TAGNAME_TARGET)) != null) {
            int i = 0;
            while (i < childs.length) {
                block4: {
                    try {
                        this.setupSingleRefreshJob(childs[i]);
                    }
                    catch (CascadingException ignore) {
                        if (!this.getLogger().isDebugEnabled()) break block4;
                        this.getLogger().debug("Setting up refresh job, ignoring exception:", (Throwable)ignore);
                    }
                }
                ++i;
            }
        }
    }

    private void setupSingleRefreshJob(Configuration conf) throws ConfigurationException, CascadingException {
        String uri = URLDecoder.decode(conf.getAttribute(ATTR_URI));
        String cache = conf.getAttribute(ATTR_CACHE);
        int expires = conf.getAttributeAsInteger(ATTR_EXPIRES);
        String key = URLDecoder.decode(conf.getAttribute(ATTR_KEY));
        IdentifierCacheKey cacheKey = new IdentifierCacheKey(key, false);
        Parameters parameters = Parameters.fromConfiguration((Configuration)conf);
        TargetConfiguration tc = new TargetConfiguration(cacheKey, uri, cache, parameters);
        this.entries.put(key, tc);
        String name = cacheKey.getKey();
        this.scheduler.addPeriodicJob(name, this.updateTarget, (long)expires, true, tc.parameters, tc.map);
    }

    private Configuration readRefreshJobConfiguration() {
        SAXConfigurationHandler b = new SAXConfigurationHandler();
        try {
            SourceUtil.toSAX((ServiceManager)this.manager, (Source)this.writeSource, (String)this.writeSource.getMimeType(), (ContentHandler)b);
        }
        catch (Exception ignore) {
            this.getLogger().warn("Unable to read configuration from " + this.writeSource.getURI());
        }
        Configuration conf = b.getConfiguration();
        return conf;
    }

    private void setupRefreshJobSource(Parameters parameters) throws ParameterException {
        try {
            String fileName = parameters.getParameter(PARAM_WRITE_FILE, DEFAULT_WRITE_FILE);
            File file = new File(this.workDir, fileName);
            this.writeSource = this.resolver.resolveURI(file.toString());
        }
        catch (IOException ioe) {
            throw new ParameterException("Error getting write-source.", (Throwable)ioe);
        }
        if (!(this.writeSource instanceof ModifiableSource)) {
            throw new ParameterException("Write-source is not modifiable.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Write source location: " + this.writeSource.getURI());
        }
    }

    private void writeRefreshJobConfiguration(Writer writer, TargetConfiguration c) throws IOException {
        writer.write("<target uri=\"");
        writer.write(URLEncoder.encode(c.parameters.getParameter(ATTR_URI, "")));
        writer.write("\" expires=\"");
        writer.write(c.parameters.getParameter(PARAM_CACHE_EXPIRES, "0"));
        writer.write("\" cache=\"");
        writer.write(c.parameters.getParameter(PARAM_CACHE_ROLE, ""));
        writer.write("\" key=\"");
        writer.write(URLEncoder.encode(((IdentifierCacheKey)c.map.get(CACHE_KEY)).getKey()));
        writer.write("\"/>\n");
    }

    class TargetConfiguration {
        final Map map = new HashMap();
        Parameters parameters;

        TargetConfiguration(IdentifierCacheKey cacheKey, String uri, String cacheRole, Parameters parameters) {
            this.map.put(DelayRefresher.CACHE_KEY, cacheKey);
            this.update(uri, cacheRole, parameters);
        }

        void update(String uri, String cacheRole, Parameters parameters) {
            this.parameters = parameters;
            this.parameters.setParameter(DelayRefresher.ATTR_URI, uri);
            this.parameters.setParameter(DelayRefresher.PARAM_CACHE_ROLE, cacheRole);
        }
    }
}

