/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.selection.AbstractSwitchSelector;

public class DateSelector
extends AbstractSwitchSelector
implements Configurable,
ThreadSafe {
    private Configuration config;
    public static final String AFTER_ELEMENT = "after";
    public static final String BEFORE_ELEMENT = "before";
    public static final String NAME_ATTR = "name";
    public static final String DATE_ATTR = "date";
    public static final String DATEFORMAT_ATTR = "dateformat";
    public static final String LANGUAGE_ATTR = "language";
    public static final String COUNTRY_ATTR = "country";

    public void configure(Configuration config) throws ConfigurationException {
        this.config = config;
    }

    protected void configure(Configuration conf, String confName, Map configMap) {
        Configuration[] confs = conf.getChildren(confName);
        String name = null;
        String date = null;
        String dateformat = null;
        String language = null;
        String country = null;
        Calendar now = Calendar.getInstance();
        int i = 0;
        while (i < confs.length) {
            block7: {
                try {
                    name = confs[i].getAttribute(NAME_ATTR);
                    date = confs[i].getAttribute(DATE_ATTR);
                    dateformat = confs[i].getAttribute(DATEFORMAT_ATTR, null);
                    language = confs[i].getAttribute(LANGUAGE_ATTR, null);
                    country = confs[i].getAttribute(COUNTRY_ATTR, null);
                    Date parsed_date = null;
                    SimpleDateFormat sdf = null;
                    if (dateformat != null && language != null && country != null) {
                        Locale locale = new Locale(language, country);
                        sdf = new SimpleDateFormat(dateformat, locale);
                    } else {
                        sdf = dateformat != null ? new SimpleDateFormat(dateformat) : new SimpleDateFormat();
                    }
                    sdf.parse(date);
                    Calendar parsed_calendar = sdf.getCalendar();
                    this.setUnsetFields(parsed_calendar, now);
                    parsed_date = parsed_calendar.getTime();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Parsed date '" + String.valueOf(date) + "' to " + "date object " + parsed_date.toString());
                    }
                    if (parsed_date != null) {
                        configMap.put(name, new DateComparator(parsed_date, confName));
                    }
                }
                catch (Exception e) {
                    if (!this.getLogger().isErrorEnabled()) break block7;
                    this.getLogger().error("Cannot parse date " + String.valueOf(date) + ", using " + NAME_ATTR + " " + String.valueOf(name) + ", " + DATE_ATTR + " " + String.valueOf(date) + ", " + DATEFORMAT_ATTR + " " + String.valueOf(dateformat) + ", " + LANGUAGE_ATTR + " " + String.valueOf(language) + ", " + COUNTRY_ATTR + " " + String.valueOf(country), (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void setUnsetFields(Calendar cal, Calendar default_cal) {
        if (!cal.isSet(1)) {
            cal.set(1, default_cal.get(1));
        }
        if (!cal.isSet(2)) {
            cal.set(2, default_cal.get(2));
        }
        if (!cal.isSet(5)) {
            cal.set(5, default_cal.get(5));
        }
        if (!cal.isSet(11)) {
            cal.set(11, default_cal.get(11));
        }
        if (!cal.isSet(12)) {
            cal.set(12, default_cal.get(12));
        }
        if (!cal.isSet(13)) {
            cal.set(13, default_cal.get(13));
        }
    }

    public Object getSelectorContext(Map objectModel, Parameters parameters) {
        ObjectModelHelper.getResponse((Map)objectModel).addHeader("Vary", "*");
        HashMap map = new HashMap();
        this.configure(this.config, BEFORE_ELEMENT, map);
        this.configure(this.config, AFTER_ELEMENT, map);
        DateSelectorContext csc = new DateSelectorContext(this.getLogger());
        csc.setup(map);
        return csc;
    }

    public boolean select(String expression, Object selectorContext) {
        if (selectorContext == null) {
            this.getLogger().debug("selectorContext is null!");
            return false;
        }
        DateSelectorContext csc = (DateSelectorContext)selectorContext;
        return csc.select(expression);
    }

    private class DateSelectorContext {
        Date now = new Date();
        HashSet set = new HashSet();
        Logger logger;

        public DateSelectorContext(Logger logger) {
            this.logger = logger;
        }

        public void setup(Map map) {
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String name = (String)entry.getKey();
                DateComparator dc = (DateComparator)entry.getValue();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Compare name " + name + " having date " + String.valueOf(dc.getDate()) + " to " + String.valueOf(this.now));
                }
                if (!dc.compareTo(this.now)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Storing name " + String.valueOf(name) + " as it yielded true ");
                }
                this.set.add(name);
            }
        }

        public boolean select(String expression) {
            return this.set.contains(expression);
        }
    }

    private static class DateComparator {
        private Date date;
        private boolean isCompareAfter;
        private boolean isCompareBefore;
        final String AFTER_COMPARATOR_MODE = "after";
        final String BEFORE_COMPARATOR_MODE = "before";

        public DateComparator(Date d, String comparator) {
            this.date = d;
            this.isCompareAfter = DateSelector.AFTER_ELEMENT.equalsIgnoreCase(comparator);
            this.isCompareBefore = DateSelector.BEFORE_ELEMENT.equalsIgnoreCase(comparator);
        }

        public Date getDate() {
            return this.date;
        }

        public boolean isCompareAfter() {
            return this.isCompareAfter;
        }

        public boolean isCompareBefore() {
            return this.isCompareBefore();
        }

        public boolean compareTo(Date now) {
            if (this.isCompareAfter) {
                return now.after(this.date);
            }
            if (this.isCompareBefore) {
                return now.before(this.date);
            }
            return now.compareTo(this.date) == 0;
        }
    }
}

