/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Status;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.starteam.TreeBasedTask;

public class StarTeamList
extends TreeBasedTask {
    private boolean listUncontrolled = true;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss zzz");
    private static final String blankstr = StarTeamList.blanks(30);

    public void setLabel(String label) {
        this._setLabel(label);
    }

    protected View createSnapshotView(View raw) {
        int labelID = this.getLabelID(raw);
        if (labelID >= 0) {
            return new View(raw, ViewConfiguration.createFromLabel((int)labelID));
        }
        return new View(raw, ViewConfiguration.createTip());
    }

    protected void testPreconditions() throws BuildException {
    }

    protected void logOperationDescription(Folder starteamrootFolder, File targetrootFolder) {
        this.log((this.isRecursive() ? "Recursive" : "Non-recursive") + " Listing of: " + starteamrootFolder.getFolderHierarchy());
        this.log("Listing against local folder" + (null == this.getRootLocalFolder() ? " (default): " : ": ") + targetrootFolder.getAbsolutePath(), 2);
        this.logLabel();
        this.logIncludes();
        this.logExcludes();
    }

    protected void visit(Folder starteamFolder, File targetFolder) throws BuildException {
        try {
            if (null != this.getRootLocalFolder()) {
                starteamFolder.setAlternatePathFragment(targetFolder.getAbsolutePath());
            }
            Folder[] subFolders = starteamFolder.getSubFolders();
            Item[] files = starteamFolder.getItems(this.getTypeNames().FILE);
            TreeBasedTask.UnmatchedFileMap ufm = new UnmatchedListingMap().init(targetFolder.getAbsoluteFile(), starteamFolder);
            this.log("");
            this.log("Listing StarTeam folder " + starteamFolder.getFolderHierarchy());
            this.log(" against local folder " + targetFolder.getAbsolutePath());
            int i = 0;
            while (i < files.length) {
                com.starbase.starteam.File eachFile = (com.starbase.starteam.File)files[i];
                String filename = eachFile.getName();
                File localFile = new File(targetFolder, filename);
                ufm.removeControlledItem(localFile);
                if (this.shouldProcess(filename)) {
                    this.list(eachFile, localFile);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < subFolders.length) {
                File targetSubfolder = new File(targetFolder, subFolders[i2].getName());
                ufm.removeControlledItem(targetSubfolder);
                if (this.isRecursive()) {
                    this.visit(subFolders[i2], targetSubfolder);
                }
                ++i2;
            }
            if (this.listUncontrolled) {
                ufm.processUncontrolledItems();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void list(com.starbase.starteam.File reposFile, File localFile) throws IOException {
        StringBuffer b = new StringBuffer();
        int status = reposFile.getStatus();
        Date displayDate = null;
        displayDate = status == 4 ? new Date(localFile.lastModified()) : reposFile.getModifiedTime().createDate();
        b.append(StarTeamList.pad(Status.name((int)status), 12)).append(' ');
        b.append(StarTeamList.pad(this.getUserName(reposFile.getLocker()), 20)).append(' ').append(SDF.format(displayDate)).append(StarTeamList.rpad(String.valueOf(reposFile.getSize()), 9)).append(' ').append(reposFile.getName());
        this.log(b.toString());
    }

    private static String blanks(int len) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < len) {
            b.append(' ');
            ++i;
        }
        return b.toString();
    }

    protected static String pad(String s, int padlen) {
        return (s + blankstr).substring(0, padlen);
    }

    protected static String rpad(String s, int padlen) {
        s = blankstr + s;
        return s.substring(s.length() - padlen);
    }

    private class UnmatchedListingMap
    extends TreeBasedTask.UnmatchedFileMap {
        private UnmatchedListingMap() {
            super(StarTeamList.this);
        }

        protected boolean isActive() {
            return StarTeamList.this.listUncontrolled;
        }

        void processUncontrolledItems() throws BuildException {
            if (this.isActive()) {
                Item remoteItem;
                File local;
                Enumeration e = this.keys();
                while (e.hasMoreElements()) {
                    local = (File)e.nextElement();
                    remoteItem = (Item)this.get(local);
                    if (!local.isFile()) continue;
                    com.starbase.starteam.File remoteFile = (com.starbase.starteam.File)remoteItem;
                    try {
                        StarTeamList.this.list(remoteFile, local);
                    }
                    catch (IOException ie) {
                        throw new BuildException("IOError in stlist", (Throwable)ie);
                    }
                }
                e = this.keys();
                while (e.hasMoreElements()) {
                    local = (File)e.nextElement();
                    remoteItem = (Item)this.get(local);
                    if (!local.isDirectory()) continue;
                    Folder folder = (Folder)remoteItem;
                    if (!StarTeamList.this.isRecursive()) continue;
                    StarTeamList.this.log("Listing uncontrolled folder " + folder.getFolderHierarchy() + " from " + local.getAbsoluteFile());
                    TreeBasedTask.UnmatchedFileMap submap = new UnmatchedListingMap().init(local, folder);
                    submap.processUncontrolledItems();
                }
            }
        }
    }
}

