/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

public class Position {
    public static final int LINESHIFT = 10;
    public static final int COLUMNMASK = 1023;
    public static final int NOPOS = 0;
    public static final int FIRSTPOS = 1025;
    public static final Position NO_POS = new NoPosPosition();
    private int _pos;

    public static int line(int n) {
        return n >>> 10;
    }

    public static int column(int n) {
        return n & 0x3FF;
    }

    protected Position() {
    }

    public Position(int n, int n2) throws PositionException {
        if (n < 1 || n2 < 1) {
            throw new PositionException();
        }
        this._pos = Position.makePos(n, n2);
    }

    static Position makePosition(int n) throws PositionException {
        if (n == 0) {
            return NO_POS;
        }
        Position position = new Position();
        position._pos = n;
        return position;
    }

    public static int makePos(int n, int n2) {
        return (n << 10) + n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Position) {
            if (object == NO_POS) {
                return false;
            }
            try {
                return this.getLine() == ((Position)object).getLine() && this.getColumn() == ((Position)object).getColumn();
            }
            catch (PositionException positionException) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        return this._pos;
    }

    public int getLine() throws PositionException {
        return Position.line(this._pos);
    }

    public int getColumn() throws PositionException {
        return Position.column(this._pos);
    }

    public boolean isValid() {
        return true;
    }

    public static class PositionException
    extends RuntimeException {
    }

    private static class NoPosPosition
    extends Position {
        public boolean isValid() {
            return false;
        }

        public boolean equals(Object object) {
            return object == this;
        }

        public int getLine() throws PositionException {
            throw new PositionException();
        }

        public int getColumn() throws PositionException {
            throw new PositionException();
        }

        NoPosPosition() {
        }
    }
}

