/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.oai;

import org.apache.cocoon.environment.Request;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;


/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Apr 24, 2003
 * Time: 12:03:53 PM
 * To change this template use Options | File Templates.
 */

/**Defines the essentials of an oai request
 *
 */
public interface OAIRequest extends OAIObject {

    int VERB_UNKNOWN = -1;

    int VERB_IDENTIFY = 0;
    static final String VERB_STRING_IDENTIFY = "Identify";

    int VERB_LIST_SETS = 1;
    String VERB_STRING_LIST_SETS = "ListSets";

    int VERB_LIST_METADATA_FORMATS = 2;
    String VERB_STRING_LIST_METADATA_FORMATS = "ListMetadataFormats";

    int VERB_LIST_IDENTIFIERS = 3;
    String VERB_STRING_LIST_IDENTIFIERS = "ListIdentifiers";

    int VERB_LIST_RECORDS = 4;
    String VERB_STRING_LIST_RECORDS = "ListRecords";

    int VERB_GET_RECORD = 5;
    String VERB_STRING_GET_RECORD = "GetRecord";
    
	String verbId = null;

    String PARAM_NAME_USE_OAI_LAST_HARVEST_DATE = "useOaiLastHarvestDate";
    
    String PARAM_NAME_GRANULARITY = "granularity";

    String URL_CHARACTER_QUESTION_MARK = "?";
    String URL_CHARACTER_AMPERSAND = "&";

    String URL_CHARACTER_EQUALS = "=";

    String URL_PARAM_NAME_VERB = OAIObject.Node.Name.VERB;
    String URL_PARAM_NAME_IDENTIFIER = OAIObject.Node.Name.IDENTIFIER;
    String URL_PARAM_NAME_FROM = "from";
    String URL_PARAM_NAME_UNTIL = "until";
    String URL_PARAM_NAME_SET = "set";
    String URL_PARAM_NAME_METADATA_PREFIX = "metadataPrefix";
    String URL_PARAM_NAME_RESUMPTION_TOKEN = "resumptionToken";


    /**Sets the repository url of this request*/
    void setRepositoryURL(String url);

    /**Gets the repository url of this request*/
    String getRepositoryURL();

    /**Sets the url of this request*/
    void setRequestURL(String url);

    /**Gets the url of this request*/
    String getRequestURL();

    /**Sets the request*/
    void setRequest(Request coocoonRequest);

    /**Gets the request*/
    Request getRequest();

    /**Sets the verb int value*/
    void setVerb(int verb);

	 /**Gets the verb int value*/
    int getVerb();

	/**Sets the verb int value*/
    void setVerbId(String verbId);

    /**Gets the verb int value*/
    String getVerbId();

    /**Gets the parameter of the request*/
    String getIdentifier();

    /**Sets the parameter of the request*/
    void setIdentifier(String identifier);

    /**Gets the parameter of the request*/
    String getMetadataPrefix();

    /**Sets the parameter of the request*/
    void setMetadataPrefix(String metadataPrefix);

	/**Gets the parameter of the request*/
    boolean getUseLastHarvestDate();

    /**Sets the parameter of the request*/
    void setUseLastHarvestDate(boolean useLastHarvestDate);
    
    /**Gets the parameter of the request*/
    String getGranularity();

    /**Sets the parameter of the request*/
    void setGranularity(String granularity);

    /**Gets the parameter of the request*/
    String getFrom();

    /**Sets the parameter of the request*/
    void setFrom(String fromDate);

    /**Gets the parameter of the request*/
    String getUntil();

    /**Sets the parameter of the request*/
    void setUntil(String untilDate);

    /**Gets the parameter of the request*/
    String getSetIdentifier();

    /**Sets the parameter of the request*/
    void setSetIdentifier(String setIdentifier);

    /**Sets the parameters of the request*/
    String getResumptionToken();

    /**Sets the parameter of the request*/
    void setResumptionToken(String resumptionToken);


    /**Returns the the verb name*/
    String getVerbString();

    /**Set's the the verb name*/
    void setVerbString(String verbString);

    /**Sends the appropriate SAX event reprensentation
     * of the request for an oai response to the
     * provide handler
     *
     * @param handler   The handler to feed
     * @param sendRequestParams Whether or not the request params should be sent as attributes (according to error state)
     * @throws SAXException
     */
    void toSAX(ContentHandler handler, boolean sendRequestParams) throws SAXException;


}
