/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/

package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.SdxObject;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.xml.XMLPipe;

import java.io.File;

public interface Pipeline extends XMLPipe, SdxObject {

    /**String representation of the pipeline package name (including trailing separator "."). */
    public static final String PACKAGE_QUALNAME = "fr.gouv.culture.sdx.pipeline.";

    /**String representation of the pipeline class name suffix. */
    public static final String CLASS_NAME_SUFFIX = "Pipeline";

    /**Generates a new instance of a Pipeline object*/
    public Pipeline newInstance() throws SDXException;

    /**Set's the default pipeline parameters
     *
     * @param params The parameters for steps of the pipeline
     */
    public void setParameters(Parameters params);


    /** The parameters for this pipeline. */
    public Parameters getParameters();

    /**
     * Adds a transformation to the pipeline and sets the consumer of the last
     * transformation to be the newly added transformation.
     * @param t     The transformation to be added.
     */
    public void addTransformation(Transformation t) throws SDXException;

    /**Returns a byte array which contains the
     * data of a transformation step. The data will only be present
     * after a pipeline is executed, if no transformation data is retained
     * <code>null</code>  will be returned
     */
    public byte[] getTransformedBytes();

    /**Returns a file which contains the
     * data of a transformation step. The data will only be present
     * after a pipeline is executed, if no transformation data is retained
     * <code>null</code>  will be returned
     */
    public File getTransformedFile() throws SDXException;

}
