/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.user;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.database.Property;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.cocoon.xml.XMLConsumer;

import java.util.Enumeration;

/**
 * A group of SDX users.
 *
 * <p>
 * Groups are used in SDX to implement some user rights
 * management. A group must have at least a name, but it can be backed up
 * by a complex XML file with other kinds of information.
 */
public class Group extends AbstractIdentity {

    /** A character buffer for element content. */
    private StringBuffer characterBuffer;

    /** The current field name */
    private String currentFieldName;

    /** name of the object used in toSAX() methods */
    public final static String NODE_NAME = "group"; //TODO : move to constants -pb


    /**
     * Creates a group without information. The name must be supplied at indexing time.
     */
    public Group() throws SDXException {
        super();
    }

    /**
     * Creates a group given a group id.
     *
     * @param   id        The group id.
     */
    public Group(String id) throws SDXException {
        super(id);
    }

    /**
     * Starts the indexing process. For users, it must return at least a "name" field.
     *
     * <p>
     * Indexing is done in the usual way but at the end we keep specific
     * user information and make them available for the getters.
     *
     * @param   parser      A parser that can be used for the indexing.
     * @param   consumer    The consumer that is the target of the indexing (may be <code>null</code>. The previously provided consumer will then be used) TODO?:what does this mean?-rbp
     */
    public void startIndexing(SAXParser parser, XMLConsumer consumer) throws SDXException {
        // First, call the super method for normal indexing.
        super.startIndexing(parser, consumer);
        // Then keep the relevant information.
        Enumeration values = this.getFieldValues();
        if (values != null) {
            // The relevant informations should now be in the field values
            while (values.hasMoreElements()) {
                Property prop = (Property) values.nextElement();
                String name = prop.getName();
                /*
                if (name.equals(ELEMENT_NAME)) setName(prop.getValue());
                */
            }
        }
    }

    /**Gets the docType for the document*/
    public String getDocType() {
        return Document.DOCTYPE_GROUP;
    }

}
