/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import java.net.URL;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContentEmitter
implements ContentHandler,
LexicalHandler,
DTDHandler {
    private NamePool pool;
    private Emitter emitter;
    private boolean inDTD = false;
    private Locator locator;
    private char[] buffer = new char[4096];
    private int used = 0;
    private int[] namespaces = new int[50];
    private int namespacesUsed = 0;

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public void setNamePool(NamePool namePool) {
        this.pool = namePool;
    }

    public void startDocument() throws SAXException {
        try {
            this.used = 0;
            this.namespacesUsed = 0;
            this.emitter.setDocumentLocator(this.locator);
            this.emitter.startDocument();
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.flush();
            this.emitter.endDocument();
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startPrefixMapping(String string, String string2) {
        if (this.namespacesUsed >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesUsed * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesUsed);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesUsed++] = this.pool.allocateNamespaceCode(string, string2);
    }

    public void endPrefixMapping(String string) {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.flush();
            int n = this.getNameCode(string, string2, string3);
            this.emitter.startElement(n, attributes, this.namespaces, this.namespacesUsed);
            this.namespacesUsed = 0;
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    private int getNameCode(String string, String string2, String string3) {
        String string4 = Name.getPrefix(string3);
        return this.pool.allocate(string4, string, string2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.flush();
            String string4 = Name.getPrefix(string3);
            int n = this.pool.allocate(string4, string, string2);
            this.emitter.endElement(n);
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        while (this.used + n2 > this.buffer.length) {
            char[] cArray2 = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, cArray2, 0, this.used);
            this.buffer = cArray2;
        }
        System.arraycopy(cArray, n, this.buffer, this.used, n2);
        this.used += n2;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.flush();
            if (string == null) {
                this.comment(string2.toCharArray(), 0, string2.length());
            } else {
                this.emitter.processingInstruction(string, string2);
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.flush();
            if (!this.inDTD) {
                this.emitter.comment(cArray, n, n2);
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    private void flush() throws TransformerException {
        if (this.used > 0) {
            this.emitter.characters(this.buffer, 0, this.used);
            this.used = 0;
        }
    }

    public void skippedEntity(String string) {
    }

    public void startDTD(String string, String string2, String string3) {
        this.inDTD = true;
    }

    public void endDTD() {
        this.inDTD = false;
    }

    public void startEntity(String string) {
    }

    public void endEntity(String string) {
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void notationDecl(String string, String string2, String string3) {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        String string5 = string3;
        if (this.locator != null) {
            try {
                String string6 = this.locator.getSystemId();
                URL uRL = new URL(new URL(string6), string3);
                string5 = uRL.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.emitter.setUnparsedEntity(string, string5);
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }
}

