/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store;

import com.coyotegulch.jisp.BTreeIndex;
import com.coyotegulch.jisp.IndexedObjectDatabase;
import com.coyotegulch.jisp.KeyNotFound;
import com.coyotegulch.jisp.KeyObject;
import com.coyotegulch.jisp.ObjectIndex;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.store.JispStringKey;
import org.apache.cocoon.components.store.Store;
import org.apache.cocoon.util.IOUtils;

public final class JispFilesystemStore
extends AbstractLoggable
implements Store,
Contextualizable,
ThreadSafe,
Initializable,
Parameterizable {
    protected File workDir;
    protected File cacheDir;
    protected File directoryFile;
    protected volatile String directoryPath;
    private File databaseFile;
    private File indexFile;
    private int mOrder;
    private IndexedObjectDatabase mDatabase;
    private BTreeIndex mIndex;

    public void setDirectory(String directory) throws IOException {
        this.setDirectory(new File(directory));
    }

    public void setDirectory(File directory) throws IOException {
        this.directoryFile = directory;
        this.directoryPath = IOUtils.getFullFilename(this.directoryFile);
        this.directoryPath = this.directoryPath + File.separator;
        if (!this.directoryFile.exists() && !this.directoryFile.mkdir()) {
            throw new IOException("Error creating store directory '" + this.directoryPath + "'");
        }
        if (!this.directoryFile.isDirectory()) {
            throw new IOException("'" + this.directoryPath + "' is not a directory");
        }
        if (!this.directoryFile.canRead() || !this.directoryFile.canWrite()) {
            throw new IOException("Directory '" + this.directoryPath + "' is not readable/writable");
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.workDir = (File)context.get((Object)"work-directory");
        this.cacheDir = (File)context.get((Object)"cache-directory");
    }

    public void parameterize(Parameters params) throws ParameterException {
        try {
            if (params.getParameterAsBoolean("use-cache-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using cache directory: " + this.cacheDir);
                }
                this.setDirectory(this.cacheDir);
            } else if (params.getParameterAsBoolean("use-work-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using work directory: " + this.workDir);
                }
                this.setDirectory(this.workDir);
            } else if (params.getParameter("directory", null) != null) {
                String dir = params.getParameter("directory");
                dir = IOUtils.getContextFilePath(this.workDir.getPath(), dir);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using directory: " + dir);
                }
                this.setDirectory(new File(dir));
            } else {
                try {
                    this.setDirectory(this.workDir);
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            throw new ParameterException("Unable to set directory", (Throwable)e);
        }
        String databaseName = params.getParameter("datafile", "cocoon.dat");
        String indexName = params.getParameter("indexfile", "cocoon.idx");
        this.mOrder = params.getParameterAsInteger("order", 301);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Database file name = " + databaseName);
            this.getLogger().debug("Index file name = " + indexName);
            this.getLogger().debug("Order=" + this.mOrder);
        }
        this.databaseFile = new File(this.directoryFile, databaseName);
        this.indexFile = new File(this.directoryFile, indexName);
    }

    public void initialize() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("initialize() JispFilesystemStore");
        }
        try {
            if (this.databaseFile.exists()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("initialize(): Datafile exists");
                }
                this.mDatabase = new IndexedObjectDatabase(this.databaseFile.toString(), false);
                this.mIndex = new BTreeIndex(this.indexFile.toString());
                this.mDatabase.attachIndex((ObjectIndex)this.mIndex);
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("initialize(): Datafile does not exist");
                }
                this.mDatabase = new IndexedObjectDatabase(this.databaseFile.toString(), false);
                this.mIndex = new BTreeIndex(this.indexFile.toString(), this.mOrder, (KeyObject)new JispStringKey(), false);
                this.mDatabase.attachIndex((ObjectIndex)this.mIndex);
            }
        }
        catch (KeyNotFound ignore) {
        }
        catch (Exception e) {
            this.getLogger().error("initialize(..) Exception", (Throwable)e);
        }
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public Object get(Object key) {
        Object value = null;
        try {
            value = this.mDatabase.read(this.wrapKeyObject(key), (ObjectIndex)this.mIndex);
            if (this.getLogger().isDebugEnabled()) {
                if (value != null) {
                    this.getLogger().debug("Found key: " + key);
                } else {
                    this.getLogger().debug("NOT Found key: " + key);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("get(..): Exception", (Throwable)e);
        }
        return value;
    }

    public void store(Object key, Object value) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("store(): Store file with key: " + key.toString());
            this.getLogger().debug("store(): Store file with value: " + value.toString());
        }
        if (value instanceof Serializable) {
            try {
                KeyObject[] keyArray = new KeyObject[]{this.wrapKeyObject(key)};
                this.mDatabase.write(keyArray, (Serializable)value);
            }
            catch (Exception e) {
                this.getLogger().error("store(..): Exception", (Throwable)e);
            }
        } else {
            throw new IOException("Object not Serializable");
        }
    }

    public void hold(Object key, Object value) throws IOException {
        this.store(key, value);
    }

    public void free() {
    }

    public void remove(Object key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("remove(..) Remove item");
        }
        try {
            KeyObject[] keyArray = new KeyObject[]{this.wrapKeyObject(key)};
            this.mDatabase.remove(keyArray);
        }
        catch (KeyNotFound ignore) {
        }
        catch (Exception e) {
            this.getLogger().error("remove(..): Exception", (Throwable)e);
        }
    }

    public boolean containsKey(Object key) {
        long res = -1L;
        try {
            res = this.mIndex.findKey(this.wrapKeyObject(key));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("containsKey(..): res=" + res);
            }
        }
        catch (KeyNotFound ignore) {
        }
        catch (Exception e) {
            this.getLogger().error("containsKey(..): Exception", (Throwable)e);
        }
        return res > 0L;
    }

    public Enumeration keys() {
        return new Vector(0).elements();
    }

    public int size() {
        return 0;
    }

    private KeyObject wrapKeyObject(Object key) {
        String skey = String.valueOf(key);
        return new JispStringKey(key.toString());
    }
}

