/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.util.StringTokenizer;

public final class DeweyDecimal {
    private int[] m_components;

    public DeweyDecimal(int[] components) {
        this.m_components = new int[components.length];
        int i = 0;
        while (i < this.m_components.length) {
            this.m_components[i] = components[i];
            ++i;
        }
    }

    public DeweyDecimal(String string) throws NumberFormatException {
        StringTokenizer tokenizer = new StringTokenizer(string, ".", true);
        int size = tokenizer.countTokens();
        this.m_components = new int[(size + 1) / 2];
        int i = 0;
        while (i < this.m_components.length) {
            String component = tokenizer.nextToken();
            if (component.equals("")) {
                throw new NumberFormatException("Empty component in string");
            }
            this.m_components[i] = Integer.parseInt(component);
            if (tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) {
                    throw new NumberFormatException("DeweyDecimal ended in a '.'");
                }
            }
            ++i;
        }
    }

    public int getSize() {
        return this.m_components.length;
    }

    public int get(int index) {
        return this.m_components[index];
    }

    public boolean isEqual(DeweyDecimal other) {
        int max = Math.max(other.m_components.length, this.m_components.length);
        int i = 0;
        while (i < max) {
            int component2;
            int component1 = i < this.m_components.length ? this.m_components[i] : 0;
            int n = component2 = i < other.m_components.length ? other.m_components[i] : 0;
            if (component2 != component1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isLessThan(DeweyDecimal other) {
        return !this.isGreaterThanOrEqual(other);
    }

    public boolean isLessThanOrEqual(DeweyDecimal other) {
        return !this.isGreaterThan(other);
    }

    public boolean isGreaterThan(DeweyDecimal other) {
        int max = Math.max(other.m_components.length, this.m_components.length);
        int i = 0;
        while (i < max) {
            int component2;
            int component1 = i < this.m_components.length ? this.m_components[i] : 0;
            int n = component2 = i < other.m_components.length ? other.m_components[i] : 0;
            if (component2 > component1) {
                return false;
            }
            if (component2 < component1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isGreaterThanOrEqual(DeweyDecimal other) {
        int max = Math.max(other.m_components.length, this.m_components.length);
        int i = 0;
        while (i < max) {
            int component2;
            int component1 = i < this.m_components.length ? this.m_components[i] : 0;
            int n = component2 = i < other.m_components.length ? other.m_components[i] : 0;
            if (component2 > component1) {
                return false;
            }
            if (component2 < component1) {
                return true;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.m_components.length) {
            if (i != 0) {
                sb.append('.');
            }
            sb.append(this.m_components[i]);
            ++i;
        }
        return sb.toString();
    }
}

