/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSInputStream;
import org.apache.lucene.store.FSOutputStream;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.util.Constants;

public final class FSDirectory
extends Directory {
    private static final Hashtable DIRECTORIES = new Hashtable();
    private static final boolean DISABLE_LOCKS = Boolean.getBoolean("disableLuceneLocks") || Constants.JAVA_1_1;
    private static MessageDigest DIGESTER;
    private byte[] buffer = null;
    private File directory = null;
    private int refCount;
    private static final char[] HEX_DIGITS;

    public static FSDirectory getDirectory(String path, boolean create) throws IOException {
        return FSDirectory.getDirectory(new File(path), create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSDirectory getDirectory(File file, boolean create) throws IOException {
        FSDirectory dir;
        file = new File(file.getCanonicalPath());
        Hashtable hashtable = DIRECTORIES;
        synchronized (hashtable) {
            dir = (FSDirectory)DIRECTORIES.get(file);
            if (dir == null) {
                dir = new FSDirectory(file, create);
                DIRECTORIES.put(file, dir);
            } else if (create) {
                dir.create();
            }
        }
        FSDirectory fSDirectory = dir;
        synchronized (fSDirectory) {
            ++dir.refCount;
        }
        return dir;
    }

    private FSDirectory(File path, boolean create) throws IOException {
        this.directory = path;
        if (create) {
            this.create();
        }
        if (!this.directory.isDirectory()) {
            throw new IOException(path + " not a directory");
        }
    }

    private synchronized void create() throws IOException {
        if (!this.directory.exists() && !this.directory.mkdir()) {
            throw new IOException("Cannot create directory: " + this.directory);
        }
        String[] files = this.directory.list();
        int i = 0;
        while (i < files.length) {
            File file = new File(this.directory, files[i]);
            if (!file.delete()) {
                throw new IOException("couldn't delete " + files[i]);
            }
            ++i;
        }
        String lockPrefix = this.getLockPrefix().toString();
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        files = tmpdir.list();
        int i2 = 0;
        while (i2 < files.length) {
            File file;
            if (files[i2].startsWith(lockPrefix) && !(file = new File(tmpdir, files[i2])).delete()) {
                throw new IOException("couldn't delete " + files[i2]);
            }
            ++i2;
        }
    }

    public final String[] list() throws IOException {
        return this.directory.list();
    }

    public final boolean fileExists(String name) throws IOException {
        File file = new File(this.directory, name);
        return file.exists();
    }

    public final long fileModified(String name) throws IOException {
        File file = new File(this.directory, name);
        return file.lastModified();
    }

    public static final long fileModified(File directory, String name) throws IOException {
        File file = new File(directory, name);
        return file.lastModified();
    }

    public void touchFile(String name) throws IOException {
        File file = new File(this.directory, name);
        file.setLastModified(System.currentTimeMillis());
    }

    public final long fileLength(String name) throws IOException {
        File file = new File(this.directory, name);
        return file.length();
    }

    public final void deleteFile(String name) throws IOException {
        File file = new File(this.directory, name);
        if (!file.delete()) {
            throw new IOException("couldn't delete " + name);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void renameFile(String from, String to) throws IOException {
        File old = new File(this.directory, from);
        File nu = new File(this.directory, to);
        if (nu.exists() && !nu.delete()) {
            throw new IOException("couldn't delete " + to);
        }
        if (!old.renameTo(nu)) {
            FileInputStream in = null;
            java.io.OutputStream out = null;
            try {
                int len;
                in = new FileInputStream(old);
                out = new FileOutputStream(nu);
                if (this.buffer == null) {
                    this.buffer = new byte[1024];
                }
                while ((len = ((java.io.InputStream)in).read(this.buffer)) >= 0) {
                    void var7_7;
                    out.write(this.buffer, 0, (int)var7_7);
                }
                old.delete();
            }
            catch (IOException ioe) {
                throw new IOException("couldn't rename " + from + " to " + to);
            }
            finally {
                if (in != null) {
                    try {
                        ((java.io.InputStream)in).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("could not close input stream: " + e.getMessage());
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("could not close output stream: " + e.getMessage());
                    }
                }
            }
        }
    }

    public final OutputStream createFile(String name) throws IOException {
        return new FSOutputStream(new File(this.directory, name));
    }

    public final InputStream openFile(String name) throws IOException {
        return new FSInputStream(new File(this.directory, name));
    }

    public final Lock makeLock(String name) {
        StringBuffer buf = this.getLockPrefix();
        buf.append("-");
        buf.append(name);
        final File lockFile = new File(System.getProperty("java.io.tmpdir"), buf.toString());
        return new Lock(){

            public boolean obtain() throws IOException {
                if (DISABLE_LOCKS) {
                    return true;
                }
                return lockFile.createNewFile();
            }

            public void release() {
                if (DISABLE_LOCKS) {
                    return;
                }
                lockFile.delete();
            }

            public boolean isLocked() {
                if (DISABLE_LOCKS) {
                    return false;
                }
                return lockFile.exists();
            }

            public String toString() {
                return "Lock@" + lockFile;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getLockPrefix() {
        byte[] digest;
        String dirName;
        try {
            dirName = this.directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        MessageDigest messageDigest = DIGESTER;
        synchronized (messageDigest) {
            digest = DIGESTER.digest(dirName.getBytes());
        }
        StringBuffer buf = new StringBuffer();
        buf.append("lucene-");
        int i = 0;
        while (i < digest.length) {
            byte b = digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
            ++i;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void close() throws IOException {
        if (--this.refCount <= 0) {
            Hashtable hashtable = DIRECTORIES;
            synchronized (hashtable) {
                DIRECTORIES.remove(this.directory);
            }
        }
    }

    public String toString() {
        return "FSDirectory@" + this.directory;
    }

    static {
        try {
            DIGESTER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.toString());
        }
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

