/*
 * Decompiled with CFR 0.152.
 */
package luke;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class PersistentStringList {
    private List _list = new ArrayList();
    private File _file = null;
    private String _name = "";
    private int _size = 0;

    public PersistentStringList(File file, String name, int size) {
        this._name = name;
        this._file = file;
        this._size = size;
        this.load();
    }

    private void load() {
        try {
            Properties props = new Properties();
            if (this._file.exists()) {
                props.load(new FileInputStream(this._file));
                int i = 0;
                while (i < this._size) {
                    String str = props.getProperty(String.valueOf(this._name) + i);
                    if (str != null && !str.trim().equals("")) {
                        this._list.add(str.trim());
                    }
                    ++i;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void save() {
        try {
            Properties props = new Properties();
            if (this._file.exists()) {
                props.load(new FileInputStream(this._file));
            }
            int i = 0;
            while (i < this._list.size()) {
                String str = (String)this._list.get(i);
                if (str != null && !str.equals("")) {
                    props.put(String.valueOf(this._name) + i, str);
                }
                ++i;
            }
            props.store(new FileOutputStream(this._file), "");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Iterator iterator() {
        return this._list.iterator();
    }

    public void add(String string) {
        if (this._list.indexOf(string) == -1) {
            this._list.add(string);
            this.pack();
            this.save();
        }
    }

    private void pack() {
        if (this._list.size() > this._size) {
            this._list = this._list.subList(this._list.size() - this._size, this._size);
        }
    }
}

