/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.ConcreteComponentTransferFunction;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.PatternPaint;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGPatternElementBridge
extends AbstractSVGBridge
implements PaintBridge,
ErrorConstants {
    public String getLocalName() {
        return "pattern";
    }

    public Paint createPaint(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, float f) {
        Object object;
        CompositeGraphicsNode compositeGraphicsNode = SVGPatternElementBridge.extractPatternContent(element, bridgeContext);
        if (compositeGraphicsNode == null) {
            return null;
        }
        Rectangle2D rectangle2D = SVGUtilities.convertPatternRegion(element, element2, graphicsNode, bridgeContext);
        String string = SVGUtilities.getChainableAttributeNS(element, null, "patternTransform", bridgeContext);
        AffineTransform affineTransform = string.length() != 0 ? SVGUtilities.convertTransform(element, "patternTransform", string) : new AffineTransform();
        boolean bl = CSSUtilities.convertOverflow(element);
        string = SVGUtilities.getChainableAttributeNS(element, null, "patternContentUnits", bridgeContext);
        short s = string.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element, "patternContentUnits", string);
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(rectangle2D.getX(), rectangle2D.getY());
        String string2 = SVGUtilities.getChainableAttributeNS(element, null, "viewBox", bridgeContext);
        if (string2.length() > 0) {
            object = SVGUtilities.getChainableAttributeNS(element, null, "preserveAspectRatio", bridgeContext);
            float f2 = (float)rectangle2D.getWidth();
            float f3 = (float)rectangle2D.getHeight();
            AffineTransform affineTransform3 = ViewBox.getPreserveAspectRatioTransform(element, string2, (String)object, f2, f3);
            affineTransform2.concatenate(affineTransform3);
        }
        if (s == 2) {
            object = new AffineTransform();
            Rectangle2D rectangle2D2 = graphicsNode.getGeometryBounds();
            ((AffineTransform)object).translate(rectangle2D2.getX(), rectangle2D2.getY());
            ((AffineTransform)object).scale(rectangle2D2.getWidth(), rectangle2D2.getHeight());
            affineTransform2.concatenate((AffineTransform)object);
        }
        compositeGraphicsNode.setTransform(affineTransform2);
        if (f != 1.0f) {
            object = compositeGraphicsNode.getGraphicsNodeRable(true);
            object = new ComponentTransferRable8Bit((Filter)object, ConcreteComponentTransferFunction.getLinearTransfer(f, 0.0f), ConcreteComponentTransferFunction.getIdentityTransfer(), ConcreteComponentTransferFunction.getIdentityTransfer(), ConcreteComponentTransferFunction.getIdentityTransfer());
            compositeGraphicsNode.setFilter((Filter)object);
        }
        return new PatternPaint(compositeGraphicsNode, rectangle2D, !bl, affineTransform);
    }

    protected static CompositeGraphicsNode extractPatternContent(Element element, BridgeContext bridgeContext) {
        LinkedList<ParsedURL> linkedList = new LinkedList<ParsedURL>();
        CompositeGraphicsNode compositeGraphicsNode;
        while ((compositeGraphicsNode = SVGPatternElementBridge.extractLocalPatternContent(element, bridgeContext)) == null) {
            String string = XLinkSupport.getXLinkHref(element);
            if (string.length() == 0) {
                return null;
            }
            SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
            ParsedURL parsedURL = new ParsedURL(sVGOMDocument.getURL(), string);
            if (!parsedURL.complete()) {
                throw new BridgeException(element, "uri.malformed", new Object[]{string});
            }
            if (SVGPatternElementBridge.contains(linkedList, parsedURL)) {
                throw new BridgeException(element, "xlink.href.circularDependencies", new Object[]{string});
            }
            linkedList.add(parsedURL);
            element = bridgeContext.getReferencedElement(element, string);
        }
        return compositeGraphicsNode;
    }

    protected static CompositeGraphicsNode extractLocalPatternContent(Element element, BridgeContext bridgeContext) {
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        CompositeGraphicsNode compositeGraphicsNode = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            GraphicsNode graphicsNode;
            if (node.getNodeType() != 1 || (graphicsNode = gVTBuilder.build(bridgeContext, (Element)node)) == null) continue;
            if (compositeGraphicsNode == null) {
                compositeGraphicsNode = new CompositeGraphicsNode();
            }
            compositeGraphicsNode.getChildren().add(graphicsNode);
        }
        return compositeGraphicsNode;
    }

    private static boolean contains(List list, ParsedURL parsedURL) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!parsedURL.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }
}

