/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.FeatureList;
import org.apache.batik.svggen.font.table.LigatureSubst;
import org.apache.batik.svggen.font.table.LookupList;
import org.apache.batik.svggen.font.table.LookupSubtable;
import org.apache.batik.svggen.font.table.LookupSubtableFactory;
import org.apache.batik.svggen.font.table.ScriptList;
import org.apache.batik.svggen.font.table.SingleSubst;
import org.apache.batik.svggen.font.table.Table;

public class GsubTable
implements Table,
LookupSubtableFactory {
    private ScriptList scriptList;
    private FeatureList featureList;
    private LookupList lookupList;

    protected GsubTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(directoryEntry.getOffset());
        int n = randomAccessFile.readInt();
        int n2 = randomAccessFile.readUnsignedShort();
        int n3 = randomAccessFile.readUnsignedShort();
        int n4 = randomAccessFile.readUnsignedShort();
        this.scriptList = new ScriptList(randomAccessFile, directoryEntry.getOffset() + n2);
        this.featureList = new FeatureList(randomAccessFile, directoryEntry.getOffset() + n3);
        this.lookupList = new LookupList(randomAccessFile, directoryEntry.getOffset() + n4, this);
    }

    public LookupSubtable read(int n, RandomAccessFile randomAccessFile, int n2) throws IOException {
        LookupSubtable lookupSubtable = null;
        switch (n) {
            case 1: {
                lookupSubtable = SingleSubst.read(randomAccessFile, n2);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                lookupSubtable = LigatureSubst.read(randomAccessFile, n2);
                break;
            }
            case 5: {
                break;
            }
        }
        return lookupSubtable;
    }

    public int getType() {
        return 1196643650;
    }

    public ScriptList getScriptList() {
        return this.scriptList;
    }

    public FeatureList getFeatureList() {
        return this.featureList;
    }

    public LookupList getLookupList() {
        return this.lookupList;
    }

    public String toString() {
        return "GSUB";
    }
}

